/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import modulardiversity.util.ICraftingResourceHolder;
import modulardiversity.util.IResourceToken;

public abstract class RequirementConsumeOnce<T, V extends IResourceToken>
extends ComponentRequirement<T> {
    V checkToken;
    V outputToken;

    public RequirementConsumeOnce(ComponentType componentType, MachineComponent.IOType actionType) {
        super(componentType, actionType);
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (!this.isCorrectHatch(component)) {
            return false;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                handler.consume(this.outputToken, true);
                return this.outputToken.isEmpty();
            }
        }
        return false;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (!this.isCorrectHatch(component)) {
            return false;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case OUTPUT: {
                handler.generate(this.outputToken, true);
                return this.outputToken.isEmpty();
            }
        }
        return false;
    }

    public ComponentRequirement.CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> list) {
        if (!this.isCorrectHatch(component)) {
            return ComponentRequirement.CraftCheck.INVALID_SKIP;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = handler.consume(this.checkToken, false);
                if (!didConsume) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                if (this.checkToken.isEmpty()) {
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
            case OUTPUT: {
                handler.generate(this.checkToken, false);
                if (this.checkToken.isEmpty()) {
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
    }

    public void startRequirementCheck(ResultChance chance, RecipeCraftingContext context) {
        this.checkToken = this.emitConsumptionToken(context);
        this.checkToken.setModifier(context.applyModifiers((ComponentRequirement)this, this.getActionType(), this.checkToken.getModifier(), false));
        this.outputToken = this.emitConsumptionToken(context);
        this.outputToken.setModifier(context.applyModifiers((ComponentRequirement)this, this.getActionType(), this.outputToken.getModifier(), false));
    }

    public void endRequirementCheck() {
        this.checkToken = this.emitConsumptionToken(null);
        this.outputToken = this.emitConsumptionToken(null);
    }

    protected abstract boolean isCorrectHatch(MachineComponent var1);

    protected abstract V emitConsumptionToken(RecipeCraftingContext var1);
}

