/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.render;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.IArrowGateLogic;
import pl.asie.simplelogic.gates.logic.IGateContainer;
import pl.asie.simplelogic.gates.render.GateCustomRenderer;

public abstract class GateCustomRendererArrow<T extends GateLogic>
extends GateCustomRenderer<T> {
    public static IModel arrowModel;

    @Override
    public boolean hasDynamic() {
        return true;
    }

    @Override
    public void renderDynamic(IGateContainer gate, T logic, IBlockAccess world, double xpos, double ypos, double zpos, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        if (arrowModel == null || !(logic instanceof IArrowGateLogic)) {
            return;
        }
        float v = -(((IArrowGateLogic)logic).getArrowPosition() + ((IArrowGateLogic)logic).getArrowRotationDelta() * partialTicks);
        IBakedModel baked = arrowModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
        float factor = (float)((double)v * Math.PI * 2.0);
        this.renderTransformedModel(baked, (quad, element, data) -> {
            float factorf;
            switch (element.func_177375_c()) {
                case POSITION: {
                    factorf = 0.5f;
                    break;
                }
                case NORMAL: {
                    factorf = 0.0f;
                    break;
                }
                default: {
                    return data;
                }
            }
            float x = data[0] - factorf;
            float z = data[2] - factorf;
            return new float[]{z * MathHelper.func_76126_a((float)factor) + x * MathHelper.func_76134_b((float)factor) + factorf, data[1], z * MathHelper.func_76134_b((float)factor) - x * MathHelper.func_76126_a((float)factor) + factorf, data[3]};
        }, gate, world, xpos, ypos, zpos, buffer);
    }
}

