/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;

public class GateLogicXOR
extends GateLogic {
    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        if (dir == EnumFacing.SOUTH) {
            return GateConnection.NONE;
        }
        return dir == EnumFacing.NORTH ? GateConnection.OUTPUT : GateConnection.INPUT;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.WEST));
            }
            case 2: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.EAST));
            }
            case 3: {
                return GateRenderState.bool(this.getInputValueInside(EnumFacing.WEST) == 0 && this.getInputValueInside(EnumFacing.EAST) == 0);
            }
            case 4: {
                return GateRenderState.input(this.getOutputValueOutside(EnumFacing.NORTH));
            }
        }
        return GateRenderState.OFF;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.WEST)).invert();
            }
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.EAST)).invert();
            }
            case 2: {
                return GateRenderState.bool(this.getInputValueInside(EnumFacing.WEST) == 0 && this.getInputValueInside(EnumFacing.EAST) == 0);
            }
        }
        return GateRenderState.ON;
    }

    @Override
    public byte calculateOutputInside(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return this.digiToRs(this.rsToDigi(this.getInputValueInside(EnumFacing.WEST)) ^ this.rsToDigi(this.getInputValueInside(EnumFacing.EAST)));
        }
        return 0;
    }

    private boolean rsToDigi(byte v) {
        return v > 0;
    }

    private byte digiToRs(boolean v) {
        return v ? (byte)15 : 0;
    }
}

