/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicRSLatch
extends GateLogic {
    private boolean toggled;
    private boolean burnt;

    @Override
    public boolean tick(IGateContainer gate) {
        boolean oldIS = this.getOutputValueInside(EnumFacing.WEST) != 0;
        boolean oldIR = this.getOutputValueInside(EnumFacing.EAST) != 0;
        boolean newIS = this.getInputValueInside(EnumFacing.WEST) != 0;
        boolean newIR = this.getInputValueInside(EnumFacing.EAST) != 0;
        boolean bl = (!oldIR && newIR) | (!oldIS && newIS ? 2 : 0);
        boolean oldToggled = this.toggled;
        switch (bl ? 1 : 0) {
            default: {
                break;
            }
            case 1: {
                this.toggled = false;
                break;
            }
            case 2: {
                this.toggled = true;
                break;
            }
            case 3: {
                this.toggled = !this.toggled;
            }
        }
        return oldToggled != this.toggled;
    }

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return false;
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        return dir.func_176740_k() == EnumFacing.Axis.X ? GateConnection.INPUT_OUTPUT : GateConnection.OUTPUT;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        super.writeToNBT(tag, isClient);
        tag.func_74757_a("tg", this.toggled);
        tag.func_74757_a("br", this.burnt);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        boolean oldTg = this.toggled;
        boolean oldBt = this.burnt;
        this.toggled = tag.func_74767_n("tg");
        this.burnt = tag.func_74767_n("br");
        return super.readFromNBT(tag, isClient) || oldTg != this.toggled || oldBt != this.burnt;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        if (this.burnt) {
            return GateRenderState.OFF;
        }
        switch (id) {
            case 1: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
            case 0: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.SOUTH));
            }
        }
        return null;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        if (this.burnt) {
            return GateRenderState.OFF;
        }
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
            case 1: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.SOUTH));
            }
        }
        return null;
    }

    @Override
    public byte calculateOutputInside(EnumFacing facing) {
        if (this.burnt) {
            return 0;
        }
        return this.toggled ^ (facing == EnumFacing.NORTH || facing == EnumFacing.EAST) ? (byte)15 : 0;
    }
}

