/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicPulseFormer
extends GateLogic {
    private long checkTime = -1L;
    private long tickTime = -1L;
    private byte prevValue;
    private byte pulse;

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return side == EnumFacing.SOUTH;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        tag = super.writeToNBT(tag, isClient);
        tag.func_74774_a("pl", this.pulse);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        byte oldPl = this.pulse;
        this.pulse = tag.func_74771_c("pl");
        return super.readFromNBT(tag, isClient) || oldPl != this.pulse;
    }

    @Override
    public boolean updateInputs(IGateContainer gate) {
        long time = gate.getGateWorld().func_82737_E();
        if (this.checkTime != time) {
            this.checkTime = time;
            this.prevValue = this.getInputValueInside(EnumFacing.SOUTH);
        }
        return super.updateInputs(gate);
    }

    @Override
    public void onChanged(IGateContainer gate) {
        long time = gate.getGateWorld().func_82737_E();
        if (this.pulse == 0 || this.tickTime == time) {
            this.pulse = this.getInputValueInside(EnumFacing.SOUTH);
            if (this.pulse == this.prevValue) {
                this.pulse = 0;
            }
            this.tickTime = time;
            if (this.updateOutputs(gate)) {
                if (this.pulse != 0) {
                    gate.scheduleRedstoneTick();
                }
                gate.markGateChanged(true);
            }
        }
    }

    @Override
    public boolean tick(IGateContainer gate) {
        if (this.pulse != 0) {
            this.pulse = 0;
            return true;
        }
        return false;
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return GateConnection.OUTPUT;
        }
        if (dir == EnumFacing.SOUTH) {
            return GateConnection.INPUT;
        }
        return GateConnection.NONE;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        boolean hasSignal = this.getInputValueInside(EnumFacing.SOUTH) != 0;
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 1: 
            case 2: {
                return GateRenderState.bool(!hasSignal);
            }
            case 3: {
                return GateRenderState.bool(hasSignal);
            }
            case 4: {
                return GateRenderState.input(this.getOutputValueOutside(EnumFacing.NORTH));
            }
        }
        return GateRenderState.OFF;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH)).invert();
            }
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 2: {
                return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
            }
        }
        return GateRenderState.ON;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        return this.pulse;
    }
}

