/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicComparator
extends GateLogic {
    private byte mode = 0;

    @Override
    public GateConnection getType(EnumFacing dir) {
        switch (dir) {
            case NORTH: {
                return GateConnection.OUTPUT_ANALOG;
            }
            case WEST: 
            case EAST: {
                return GateConnection.INPUT_ANALOG;
            }
            case SOUTH: {
                return GateConnection.INPUT_COMPARATOR;
            }
        }
        return GateConnection.NONE;
    }

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.X;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        super.writeToNBT(tag, isClient);
        tag.func_74774_a("gm", this.mode);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        byte oldMode = this.mode;
        this.mode = tag.func_74771_c("gm");
        return super.readFromNBT(tag, isClient) || this.mode != oldMode;
    }

    @Override
    public boolean onRightClick(IGateContainer gate, EntityPlayer playerIn, Vec3d vec, EnumHand hand) {
        if (!playerIn.func_70093_af()) {
            this.mode = (byte)(1 - this.mode);
            if (!gate.getGateWorld().field_72995_K) {
                gate.markGateChanged(true);
            }
        }
        gate.createNotice((NotificationComponent)NotificationComponentString.translated((String)("notice.simplelogic.gate.comparator.mode." + this.mode), (NotificationComponent[])new NotificationComponent[0])).sendTo(playerIn);
        return true;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 2: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.WEST, this.getInputValueInside(EnumFacing.WEST));
            }
            case 3: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.EAST, this.getInputValueInside(EnumFacing.EAST));
            }
        }
        return GateRenderState.OFF;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return GateRenderState.input(this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 2: {
                return this.mode == 0 ? GateRenderState.OFF : GateRenderState.NO_RENDER;
            }
            case 3: {
                return this.mode == 1 ? GateRenderState.ON : GateRenderState.NO_RENDER;
            }
        }
        return GateRenderState.OFF;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        if (side == EnumFacing.NORTH) {
            int maxSide = Math.max(this.getInputValueInside(EnumFacing.WEST), this.getInputValueInside(EnumFacing.EAST));
            byte rear = this.getInputValueInside(EnumFacing.SOUTH);
            switch (this.mode) {
                default: {
                    return maxSide > rear ? (byte)0 : rear;
                }
                case 1: 
            }
            return (byte)MathHelper.func_76125_a((int)(rear - maxSide), (int)0, (int)15);
        }
        return 0;
    }

    @Override
    public boolean renderEquals(GateLogic other) {
        if (!super.renderEquals(other) || !(other instanceof GateLogicComparator)) {
            return false;
        }
        return ((GateLogicComparator)other).mode == this.mode;
    }

    @Override
    public int renderHashCode(int hash) {
        return Objects.hash(super.renderHashCode(hash), this.mode);
    }
}

