/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.stagingapi.IConfigurationHolder;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicBundledTransposer
extends GateLogic
implements ICapabilityProvider,
IConfigurationHolder {
    public int[] transpositionMap = new int[16];
    private int tMapHash = 0;

    private boolean readTmap(NBTTagCompound tag) {
        if (tag.func_150297_b("tmap", 11)) {
            int[] oldTranspositionMap = this.transpositionMap;
            this.transpositionMap = this.ensureSizeAndCopy(tag.func_74759_k("tmap"), 16);
            this.tMapHash = Arrays.hashCode(this.transpositionMap);
            return !Arrays.equals(oldTranspositionMap, this.transpositionMap);
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        tag = super.writeToNBT(tag, isClient);
        if (isClient) {
            tag.func_74783_a("tmap", this.transpositionMap);
        } else {
            for (int i = 0; i < 16; ++i) {
                if (this.transpositionMap[i] == 0) continue;
                tag.func_74783_a("tmap", this.transpositionMap);
                break;
            }
        }
        return tag;
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound tag, boolean silky) {
        tag = super.writeItemNBT(tag, silky);
        if (silky) {
            tag.func_74783_a("tmap", this.transpositionMap);
        }
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        return super.readFromNBT(tag, isClient) | this.readTmap(tag);
    }

    @Override
    public void onChanged(IGateContainer gate) {
        byte[] input = this.getInputValueBundled(EnumFacing.SOUTH);
        byte[] oldOutput = this.getOutputValueBundled(EnumFacing.NORTH);
        byte[] data = new byte[16];
        if (input == null) {
            for (int i = 0; i < 16; ++i) {
                data[i] = 0;
            }
        } else {
            for (int from = 0; from < 16; ++from) {
                int v = this.transpositionMap[from];
                int i = 0;
                while (v != 0) {
                    if ((v & 1) != 0) {
                        data[i] = (byte)Math.max(data[i], input[from]);
                    }
                    v >>= 1;
                    ++i;
                }
            }
        }
        if (!Arrays.equals(oldOutput, data)) {
            this.outputValuesBundled[0] = data;
            gate.markGateChanged(true);
        }
    }

    public void onTMapChanged(IGateContainer gate) {
        this.tMapHash = Arrays.hashCode(this.transpositionMap);
        gate.markGateChanged(false);
        this.onChanged(gate);
    }

    @Override
    public boolean onRightClick(IGateContainer gate, EntityPlayer playerIn, Vec3d vec, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            gate.openGUI(playerIn);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateOutputs(IGateContainer gate) {
        return false;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        return GateRenderState.OFF;
    }

    @Override
    public GateRenderState getTorchState(int id) {
        return GateRenderState.OFF;
    }

    @Override
    public GateConnection getType(EnumFacing dir) {
        switch (dir) {
            case SOUTH: {
                return GateConnection.INPUT_BUNDLED;
            }
            case NORTH: {
                return GateConnection.OUTPUT_BUNDLED;
            }
        }
        return GateConnection.NONE;
    }

    @Override
    public boolean renderEquals(GateLogic other) {
        if (!(other instanceof GateLogicBundledTransposer)) {
            return false;
        }
        return Arrays.equals(((GateLogicBundledTransposer)other).transpositionMap, this.transpositionMap);
    }

    @Override
    public int renderHashCode(int hash) {
        return hash * 31 + this.tMapHash;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Capabilities.CONFIGURATION_HOLDER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.CONFIGURATION_HOLDER ? Capabilities.CONFIGURATION_HOLDER.cast((Object)this) : null);
    }

    public ResourceLocation getConfigType() {
        return new ResourceLocation("simplelogic:bundled_transposer");
    }

    public NBTTagCompound serializeConfig() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("tmap", this.transpositionMap);
        return tag;
    }

    public IConfigurationHolder.DeserializationResult deserializeConfig(NBTTagCompound compound, ResourceLocation type) {
        if (compound.func_150297_b("tmap", 11)) {
            return this.readTmap(compound) ? IConfigurationHolder.DeserializationResult.CHANGED_ACCURATE : IConfigurationHolder.DeserializationResult.UNCHANGED;
        }
        return IConfigurationHolder.DeserializationResult.INVALID;
    }
}

