/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.api.lib.IDebuggable;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.misc.ISimpleLogicSidedEmitter;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.render.model.IRenderComparable;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataProvider;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.Quaternion;
import pl.asie.charset.lib.utils.RotationUtils;
import pl.asie.charset.lib.utils.redstone.RedstoneUtils;
import pl.asie.charset.lib.wires.SignalMeterDataBundledWire;
import pl.asie.charset.lib.wires.SignalMeterDataWire;
import pl.asie.simplelogic.gates.ItemGate;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateLogicDummy;
import pl.asie.simplelogic.gates.logic.GateLogicRepeater;
import pl.asie.simplelogic.gates.logic.IGateContainer;
import pl.asie.simplelogic.gates.logic.IGateTickable;

public class PartGate
extends TileBase
implements IDebuggable,
IGateContainer,
IRenderComparable<PartGate>,
ISignalMeterDataProvider,
ITickable {
    public static final AxisAlignedBB[] BOXES = new AxisAlignedBB[6];
    private static final Vec3d[] HIT_VECTORS;
    private final RedstoneCommunications[] COMMS = new RedstoneCommunications[4];
    public boolean mirrored;
    public GateLogic logic;
    private long tickScheduleTime = -1L;
    private long pendingTick = -1L;
    private Orientation orientation = Orientation.FACE_UP_POINT_NORTH;
    private final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}};

    public Orientation getOrientation() {
        return this.orientation;
    }

    public PartGate(GateLogic logic) {
        this.logic = logic;
        this.COMMS[0] = new RedstoneCommunications(EnumFacing.NORTH);
        this.COMMS[1] = new RedstoneCommunications(EnumFacing.SOUTH);
        this.COMMS[2] = new RedstoneCommunications(EnumFacing.WEST);
        this.COMMS[3] = new RedstoneCommunications(EnumFacing.EAST);
    }

    public PartGate() {
        this(new GateLogicDummy());
    }

    PartGate setInvertedSides(int invertedSides) {
        this.logic.invertedSides = (byte)(invertedSides & 0xF);
        return this;
    }

    private boolean hasRedstoneCapability(Capability<?> capability, EnumFacing direction) {
        EnumFacing dir;
        if (direction != null && direction.func_176740_k() != this.orientation.facing.func_176740_k() && this.logic.isSideOpen(dir = this.realToGate(direction))) {
            GateConnection conn = this.logic.getType(dir);
            if (capability == Capabilities.BUNDLED_EMITTER && conn.isOutput() && conn.isBundled()) {
                return true;
            }
            if (capability == Capabilities.BUNDLED_RECEIVER && conn.isInput() && conn.isBundled()) {
                return true;
            }
            if (capability == Capabilities.REDSTONE_EMITTER && conn.isOutput() && conn.isRedstone()) {
                return true;
            }
            if (capability == Capabilities.REDSTONE_RECEIVER && conn.isInput() && conn.isRedstone()) {
                return true;
            }
        }
        return false;
    }

    public void func_189667_a(Rotation rotationIn) {
        super.func_189667_a(rotationIn);
        for (int i = 0; i < rotationIn.ordinal(); ++i) {
            this.orientation = this.orientation.rotateAround(EnumFacing.UP);
        }
        this.onChanged();
        this.scheduleTick(0);
        this.markBlockForUpdate();
    }

    public void func_189668_a(Mirror mirror) {
        super.func_189668_a(mirror);
        if (this.orientation.facing.func_176740_k() == EnumFacing.Axis.Y && this.logic.canMirror()) {
            switch (mirror) {
                case LEFT_RIGHT: {
                    if (this.orientation.top.func_176740_k() == EnumFacing.Axis.Z) {
                        this.mirrored = !this.mirrored;
                        break;
                    }
                    this.orientation = this.orientation.getNextRotationOnFace().getNextRotationOnFace();
                    this.mirrored = !this.mirrored;
                    break;
                }
                case FRONT_BACK: {
                    if (this.orientation.top.func_176740_k() == EnumFacing.Axis.X) {
                        this.mirrored = !this.mirrored;
                        break;
                    }
                    this.orientation = this.orientation.getNextRotationOnFace().getNextRotationOnFace();
                    this.mirrored = !this.mirrored;
                }
            }
            this.onChanged();
            this.scheduleTick(0);
            this.markBlockForUpdate();
        } else {
            this.orientation = this.orientation.mirror(mirror);
            this.onChanged();
            this.scheduleTick(0);
            this.markBlockForUpdate();
        }
    }

    @Override
    public void openGUI(EntityPlayer player) {
        SimpleLogicGates.proxy.openGui(this, player);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing direction) {
        return capability == Capabilities.DEBUGGABLE || capability == Capabilities.SIGNAL_METER_DATA_PROVIDER || capability == SimpleLogicGates.GATE_CAP && direction == this.getSide() || this.hasRedstoneCapability(capability, direction) || this.logic instanceof ICapabilityProvider && ((ICapabilityProvider)this.logic).hasCapability(capability, direction) || super.hasCapability(capability, direction);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing direction) {
        if (capability == Capabilities.DEBUGGABLE || capability == SimpleLogicGates.GATE_CAP || capability == Capabilities.SIGNAL_METER_DATA_PROVIDER) {
            return (T)this;
        }
        if (this.hasRedstoneCapability(capability, direction)) {
            EnumFacing dir = this.realToGate(direction);
            if (dir.ordinal() >= 2) {
                return (T)this.COMMS[dir.ordinal() - 2];
            }
            return null;
        }
        if (this.logic instanceof ICapabilityProvider && ((ICapabilityProvider)this.logic).hasCapability(capability, direction)) {
            return (T)((ICapabilityProvider)this.logic).getCapability(capability, direction);
        }
        return (T)super.getCapability(capability, direction);
    }

    public ItemStack getPickedBlock(@Nullable EntityPlayer player, @Nullable RayTraceResult result, IBlockState state) {
        ItemStack stack = ItemGate.getStack(this, true);
        this.saveToStack(stack);
        return stack;
    }

    public void getDrops(NonNullList<ItemStack> stacks, IBlockState state, int fortune, boolean silkTouch) {
        ItemStack stack = ItemGate.getStack(this, silkTouch);
        this.saveToStack(stack);
        stacks.add((Object)stack);
    }

    public void func_73660_a() {
        if (this.func_145831_w() != null) {
            if (this.logic instanceof IGateTickable) {
                ((IGateTickable)((Object)this.logic)).update(this);
            }
            if (!this.func_145831_w().field_72995_K && this.pendingTick >= 0L && this.field_145850_b.func_82737_E() >= this.pendingTick && this.logic.shouldTick()) {
                this.pendingTick = -1L;
                if (this.logic.tick(this)) {
                    this.markGateChanged(this.logic.updateOutputs(this));
                }
                if (this.logic.updateInputs(this)) {
                    this.logic.onChanged(this);
                }
            }
        }
    }

    @Override
    public byte getRedstoneInput(EnumFacing facing) {
        GateConnection conn = this.logic.getType(facing);
        if (conn == GateConnection.INPUT_REPEATER) {
            EnumFacing real = this.gateToReal(facing);
            World w = this.func_145831_w();
            BlockPos p = this.func_174877_v().func_177972_a(real);
            Predicate<TileEntity> predicate = tileEntity -> tileEntity instanceof PartGate && ((PartGate)tileEntity).logic instanceof GateLogicRepeater;
            return (byte)MathHelper.func_76125_a((int)RedstoneUtils.getModdedWeakPower((IBlockAccess)w, (BlockPos)p, (EnumFacing)real, (EnumFacing)this.getSide(), predicate), (int)0, (int)15);
        }
        if (conn.isInput() && conn.isRedstone()) {
            int v = 0;
            if (this.logic.isSideOpen(facing)) {
                EnumFacing real = this.gateToReal(facing);
                World w = this.func_145831_w();
                BlockPos p = this.func_174877_v().func_177972_a(real);
                Predicate<TileEntity> predicate = tileEntity -> true;
                int mpValue = RedstoneUtils.getModdedWeakPower((IBlockAccess)w, (BlockPos)p, (EnumFacing)real, (EnumFacing)this.getSide(), predicate);
                if (mpValue >= 0) {
                    v = (byte)mpValue;
                } else {
                    TileEntity tile = w.func_175625_s(p);
                    if (tile != null && tile.hasCapability(Capabilities.REDSTONE_EMITTER, real.func_176734_d())) {
                        IRedstoneEmitter emitter = (IRedstoneEmitter)tile.getCapability(Capabilities.REDSTONE_EMITTER, real.func_176734_d());
                        if (!(emitter instanceof ISimpleLogicSidedEmitter) || ((ISimpleLogicSidedEmitter)emitter).getEmitterFace() == this.getOrientation().facing.func_176734_d()) {
                            v = (byte)emitter.getRedstoneSignal();
                        }
                    } else {
                        IBlockState s = w.func_180495_p(p);
                        if (RedstoneUtils.canConnectFace((IBlockAccess)w, (BlockPos)p, (IBlockState)s, (EnumFacing)real, (EnumFacing)this.getSide())) {
                            v = s.func_177230_c() instanceof BlockRedstoneWire ? (int)((Integer)s.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).byteValue() : (int)((byte)s.func_185911_a((IBlockAccess)w, p, real));
                        }
                    }
                }
                if (conn.isComparator() && v < 15) {
                    IBlockState s = w.func_180495_p(p);
                    if (s.func_185912_n()) {
                        v = (byte)Math.max(MathHelper.func_76125_a((int)s.func_185888_a(w, p), (int)0, (int)15), v);
                    } else if (s.func_185915_l()) {
                        v = 0;
                        BlockPos pp = p.func_177972_a(real);
                        s = w.func_180495_p(pp);
                        if (s.func_185912_n()) {
                            v = (byte)Math.max(MathHelper.func_76125_a((int)s.func_185888_a(w, pp), (int)0, (int)15), v);
                        } else if (!s.func_185915_l()) {
                            List frames = this.field_145850_b.func_175647_a(EntityItemFrame.class, new AxisAlignedBB(pp), frame -> frame != null && frame.func_174811_aO() == facing);
                            for (EntityItemFrame frame2 : frames) {
                                v = (byte)Math.max(MathHelper.func_76125_a((int)frame2.func_174866_q(), (int)0, (int)15), v);
                            }
                        }
                    }
                }
                if (conn.isDigital()) {
                    int n = v = v != 0 ? 15 : 0;
                }
                if (this.logic.isSideInverted(facing)) {
                    v = v != 0 ? 0 : 15;
                }
            }
            return (byte)v;
        }
        return 0;
    }

    @Override
    public byte[] getBundledInput(EnumFacing facing) {
        GateConnection conn = this.logic.getType(facing);
        if (conn.isInput() && conn.isBundled() && this.logic.isSideOpen(facing)) {
            IBundledEmitter emitter;
            BlockPos p;
            EnumFacing real = this.gateToReal(facing);
            World w = this.func_145831_w();
            byte[] mpValue = RedstoneUtils.getModdedBundledPower((IBlockAccess)w, (BlockPos)(p = this.func_174877_v().func_177972_a(real)), (EnumFacing)real, (EnumFacing)this.getSide(), t -> true);
            if (mpValue != null) {
                return mpValue;
            }
            TileEntity tile = w.func_175625_s(p);
            if (tile != null && tile.hasCapability(Capabilities.BUNDLED_EMITTER, real.func_176734_d()) && (!((emitter = (IBundledEmitter)tile.getCapability(Capabilities.BUNDLED_EMITTER, real.func_176734_d())) instanceof ISimpleLogicSidedEmitter) || ((ISimpleLogicSidedEmitter)emitter).getEmitterFace() == this.getOrientation().facing.func_176734_d())) {
                return emitter.getBundledSignal();
            }
        }
        return new byte[16];
    }

    @Override
    public Notice createNotice(NotificationComponent component) {
        return new Notice((Object)this, component);
    }

    @Override
    public void markGateChanged(boolean changedIO) {
        if (changedIO) {
            this.field_145850_b.func_175722_b(this.func_174877_v(), this.func_145838_q(), false);
        }
        if (this.field_145850_b.field_72995_K) {
            if (!SimpleLogicGates.useTESRs) {
                this.markBlockForRenderUpdate();
            }
        } else {
            this.markChunkDirty();
            this.markBlockForUpdate();
        }
    }

    public boolean getInverterState(EnumFacing facing) {
        byte value = this.logic.getType(facing).isInput() ? this.logic.getInputValueOutside(facing) : this.logic.getOutputValueInside(facing);
        return value == 0;
    }

    protected void onChanged() {
        if ((this.pendingTick < 0L || this.tickScheduleTime == this.field_145850_b.func_82737_E()) && this.logic.updateInputs(this)) {
            this.logic.onChanged(this);
        }
    }

    @Override
    public World getGateWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getGatePos() {
        return this.field_174879_c;
    }

    @Override
    public void scheduleTick(int duration) {
        if (this.pendingTick < 0L) {
            this.pendingTick = this.field_145850_b.func_82737_E() + (long)duration;
            this.tickScheduleTime = this.field_145850_b.func_82737_E();
        } else {
            this.pendingTick = Math.min(this.pendingTick, this.field_145850_b.func_82737_E() + (long)duration);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.scheduleTick(0);
    }

    public void onNeighborBlockChange(BlockPos fromPos, @Nullable Block block) {
        if (this.logic instanceof GateLogicDummy || !this.func_145831_w().isSideSolid(this.func_174877_v().func_177972_a(this.getSide()), this.getSide().func_176734_d())) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            state.func_177230_c().func_176226_b(this.field_145850_b, this.field_174879_c, state, 0);
            this.field_145850_b.func_175698_g(this.field_174879_c);
            return;
        }
        this.onChanged();
    }

    public boolean rotate(EnumFacing axis) {
        if (axis.func_176740_k() == this.orientation.facing.func_176740_k()) {
            this.orientation = axis.func_176743_c() == this.orientation.facing.func_176743_c() ? this.orientation.getNextRotationOnFace() : this.orientation.getPrevRotationOnFace();
            this.onChanged();
            this.markBlockForUpdate();
            return true;
        }
        return false;
    }

    @Nullable
    private EnumFacing getClosestFace(Vec3d vec, Predicate<EnumFacing> predicate) {
        EnumFacing closestFace = null;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i <= 4; ++i) {
            EnumFacing face;
            double d = HIT_VECTORS[i].func_72436_e(vec);
            if (!(d < distance)) continue;
            EnumFacing enumFacing = face = i == 4 ? null : EnumFacing.func_82600_a((int)(i + 2));
            if (!predicate.test(face)) continue;
            closestFace = face;
            distance = d;
        }
        return closestFace;
    }

    public boolean onActivated(EntityPlayer playerIn, EnumHand hand, float hitX, float hitY, float hitZ) {
        boolean changed = false;
        boolean used = false;
        boolean remote = this.func_145831_w().field_72995_K;
        ItemStack stack = playerIn.func_184586_b(hand);
        Vec3d vecOrig = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        Vec3d vec = this.realToGate(vecOrig);
        if (!stack.func_190926_b()) {
            Block block;
            if (stack.func_77973_b().getToolClasses(stack).contains("wrench")) {
                if (playerIn.func_70093_af()) {
                    if (this.logic.canMirror()) {
                        this.mirrored = !this.mirrored;
                        changed = true;
                    }
                } else {
                    changed = this.rotate(this.orientation.facing);
                }
                used = true;
            } else if (stack.func_77973_b() instanceof ItemBlock && ((block = Block.func_149634_a((Item)stack.func_77973_b())) == Blocks.field_150429_aA || block == Blocks.field_150437_az)) {
                EnumFacing closestFace = this.getClosestFace(vec, facing -> true);
                if (closestFace != null && this.logic.canInvertSide(closestFace) && !this.logic.isSideInverted(closestFace)) {
                    if (!remote) {
                        this.logic.invertedSides = (byte)(this.logic.invertedSides | 1 << closestFace.ordinal() - 2);
                        if (!playerIn.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                    }
                    changed = true;
                }
                used = true;
            }
        }
        if (!used) {
            EnumFacing closestFace = this.getClosestFace(vec, facing -> true);
            if (closestFace != null) {
                if (this.logic.canInvertSide(closestFace) && this.logic.isSideInverted(closestFace)) {
                    if (!remote) {
                        this.logic.invertedSides = (byte)(this.logic.invertedSides & ~(1 << closestFace.ordinal() - 2));
                        ItemUtils.spawnItemEntity((World)this.func_145831_w(), (Vec3d)vecOrig.func_72441_c((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), (ItemStack)new ItemStack(Blocks.field_150429_aA), (float)0.0f, (float)0.2f, (float)0.0f, (float)0.1f);
                    }
                    changed = true;
                } else if (playerIn.func_70093_af() && this.logic.canBlockSide(closestFace)) {
                    if (!remote) {
                        this.logic.enabledSides = (byte)(this.logic.enabledSides ^ 1 << closestFace.ordinal() - 2);
                    }
                    changed = true;
                }
            }
            if (!changed) {
                changed = this.logic.onRightClick(this, playerIn, vec, hand);
            }
        }
        if (changed) {
            this.logic.updateInputs(this);
            this.logic.onChanged(this);
            return true;
        }
        return false;
    }

    public String getBaseModelName() {
        return this.mirrored ? "base_mirrored" : "base";
    }

    public String getLayerModelName() {
        return this.mirrored ? "layer_mirrored" : "layer";
    }

    public boolean canConnectRedstone(@Nullable EnumFacing direction) {
        EnumFacing dir;
        if (direction != null && this.orientation.facing.func_176740_k() != direction.func_176740_k() && (dir = this.realToGate(direction)) != null && this.logic.isSideOpen(dir)) {
            return this.logic.getType(dir).isRedstone();
        }
        return false;
    }

    public int getWeakSignal(EnumFacing facing) {
        EnumFacing dir = this.realToGate(facing);
        if (dir != null && this.logic.getType(dir).isOutput() && this.logic.getType(dir).isRedstone() && this.logic.isSideOpen(dir)) {
            return this.logic.getOutputValueOutside(dir);
        }
        return 0;
    }

    public void onPlacedBy(EntityLivingBase placer, @Nullable EnumFacing face, ItemStack stack, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(placer, face, stack, hitX, hitY, hitZ);
        if (face != null) {
            this.orientation = Orientation.fromDirection((EnumFacing)(SimpleLogicGates.onlyBottomFace ? EnumFacing.UP : face));
            Vec3d vec = this.realToGate(new Vec3d((double)hitX, (double)hitY, (double)hitZ));
            this.orientation = this.orientation.pointTopTo(this.gateToReal(this.getClosestFace(vec, Objects::nonNull)));
        }
        if (this.logic != null) {
            this.logic.updateOutputs(this);
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound tag, boolean isClient) {
        if (!(this.logic instanceof GateLogicDummy)) {
            tag.func_74778_a("logic", ((ResourceLocation)SimpleLogicGates.logicClasses.inverse().get(this.logic.getClass())).toString());
            tag = this.logic.writeToNBT(tag, isClient);
        }
        tag.func_74757_a("m", this.mirrored);
        tag.func_74774_a("o", (byte)this.orientation.ordinal());
        if (!isClient && this.pendingTick >= 0L) {
            tag.func_74772_a("pt", this.pendingTick);
        }
        return tag;
    }

    public void loadFromStack(ItemStack stack) {
        super.loadFromStack(stack);
        if (stack.func_77942_o()) {
            this.readItemNBT(stack.func_77978_p());
        }
    }

    public void readItemNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("logic", 8)) {
            Optional<GateLogic> logic = ItemGate.getGateLogic(new ResourceLocation(tag.func_74779_i("logic")));
            logic.ifPresent(a -> a.readFromNBT(tag, false));
            this.logic = logic.orElseGet(GateLogicDummy::new);
        }
    }

    public NBTTagCompound writeItemNBT(NBTTagCompound tag, boolean silky) {
        if (!(this.logic instanceof GateLogicDummy)) {
            tag.func_74778_a("logic", ((ResourceLocation)SimpleLogicGates.logicClasses.inverse().get(this.logic.getClass())).toString());
            return this.logic.writeItemNBT(tag, silky);
        }
        return tag;
    }

    public void readNBTData(NBTTagCompound tag, boolean isClient) {
        boolean renderUpdate = false;
        boolean orientationUpdate = false;
        if (tag.func_150297_b("logic", 8)) {
            Optional<GateLogic> logic = ItemGate.getGateLogic(this.logic, new ResourceLocation(tag.func_74779_i("logic")));
            if (logic.isPresent()) {
                renderUpdate |= logic.get().readFromNBT(tag, isClient);
            }
            this.logic = logic.orElseGet(GateLogicDummy::new);
        }
        if (tag.func_74764_b("m")) {
            boolean om = this.mirrored;
            this.mirrored = tag.func_74767_n("m");
            orientationUpdate |= this.mirrored != om;
        }
        if (!isClient) {
            this.pendingTick = tag.func_74764_b("pt") ? tag.func_74763_f("pt") : -1L;
        }
        Orientation oldO = this.orientation;
        this.orientation = Orientation.getOrientation((int)tag.func_74771_c("o"));
        if (isClient && ((orientationUpdate |= oldO != this.orientation) || !SimpleLogicGates.useTESRs && renderUpdate)) {
            this.markBlockForRenderUpdate();
        }
    }

    @Override
    public EnumFacing getSide() {
        return this.orientation.facing.func_176734_d();
    }

    @Override
    public EnumFacing getTop() {
        EnumFacing[] f = this.CONNECTION_DIRS[this.getSide().ordinal()];
        for (int i = 0; i < 4; ++i) {
            if (this.orientation.top != f[i]) continue;
            return EnumFacing.func_82600_a((int)(i + 2));
        }
        throw new RuntimeException("!?");
    }

    @Override
    public GateLogic getLogic() {
        return this.logic;
    }

    public AxisAlignedBB getBox() {
        return BOXES[this.getSide().ordinal()];
    }

    protected EnumFacing gateToReal(EnumFacing dir) {
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            return null;
        }
        if (dir.func_176740_k() == EnumFacing.Axis.X && this.mirrored) {
            dir = dir.func_176734_d();
        }
        for (EnumFacing itop = this.getTop(); itop != EnumFacing.NORTH; itop = itop.func_176735_f()) {
            dir = dir.func_176746_e();
        }
        return this.CONNECTION_DIRS[this.getSide().ordinal()][dir.ordinal() - 2];
    }

    protected Vec3d realToGate(Vec3d vec) {
        return Quaternion.fromOrientation((Orientation)this.orientation.getPrevRotationOnFace()).applyReverseRotation(vec.func_186678_a(2.0).func_178786_a(1.0, 1.0, 1.0)).func_72441_c(1.0, 1.0, 1.0).func_186678_a(0.5);
    }

    protected EnumFacing realToGate(EnumFacing rdir) {
        if (rdir.func_176740_k() == this.orientation.facing.func_176740_k()) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.CONNECTION_DIRS[this.getSide().ordinal()][i] != rdir) continue;
            EnumFacing dir = EnumFacing.func_82600_a((int)(i + 2));
            for (EnumFacing itop = this.getTop(); itop != EnumFacing.NORTH; itop = itop.func_176735_f()) {
                dir = dir.func_176735_f();
            }
            if (dir.func_176740_k() == EnumFacing.Axis.X && this.mirrored) {
                return dir.func_176734_d();
            }
            return dir;
        }
        return null;
    }

    private int getUniqueSideRenderID(EnumFacing side) {
        return (this.logic.isSideInverted(side) ? 16 : 0) | (this.logic.isSideOpen(side) ? 32 : 0) | this.logic.getInputValueInside(side) << 6 | this.logic.getOutputValueInside(side);
    }

    public boolean renderEquals(PartGate other) {
        if (this.logic.getClass() != other.logic.getClass()) {
            return false;
        }
        if (this.orientation != other.orientation || this.mirrored != other.mirrored) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (this.getUniqueSideRenderID(facing) == other.getUniqueSideRenderID(facing)) continue;
            return false;
        }
        return this.logic.renderEquals(other.logic);
    }

    public int renderHashCode() {
        return this.logic.renderHashCode(Objects.hash(this.logic.getClass(), this.orientation, this.mirrored, this.getUniqueSideRenderID(EnumFacing.NORTH), this.getUniqueSideRenderID(EnumFacing.SOUTH), this.getUniqueSideRenderID(EnumFacing.WEST), this.getUniqueSideRenderID(EnumFacing.EAST)));
    }

    public void addDebugInformation(List<String> stringList, Side side) {
        if (side == Side.SERVER) {
            stringList.add("O: " + this.getOrientation().name() + (this.mirrored ? TextFormatting.RED + "M" : ""));
        }
        if (this.logic instanceof IDebuggable) {
            ((IDebuggable)this.logic).addDebugInformation(stringList, side);
        }
    }

    public ISignalMeterData getSignalMeterData(RayTraceResult result) {
        GateConnection type;
        Vec3d vecOrig = result.field_72307_f.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        Vec3d vec = this.realToGate(vecOrig);
        EnumFacing facing = this.getClosestFace(vec, facing1 -> {
            if (facing1 == null) {
                return true;
            }
            return this.logic.getType((EnumFacing)facing1).isInput() || this.logic.getType((EnumFacing)facing1).isOutput();
        });
        if (facing == null) {
            if (this.logic instanceof ISignalMeterDataProvider) {
                return ((ISignalMeterDataProvider)this.logic).getSignalMeterData(result);
            }
            facing = this.getClosestFace(vec, facing1 -> {
                if (facing1 == null) {
                    return false;
                }
                return this.logic.getType((EnumFacing)facing1).isInput() || this.logic.getType((EnumFacing)facing1).isOutput();
            });
        }
        if ((type = this.logic.getType(facing)).isInput() && type.isBundled()) {
            return new SignalMeterDataBundledWire(this.logic.getInputValueBundled(facing));
        }
        if (type.isInput() && type.isRedstone()) {
            return new SignalMeterDataWire(this.logic.getInputValueInside(facing), -1);
        }
        if (type.isOutput() && type.isBundled()) {
            return new SignalMeterDataBundledWire(this.logic.getOutputValueBundled(facing));
        }
        if (type.isOutput() && type.isRedstone()) {
            return new SignalMeterDataWire(this.logic.getOutputValueInside(facing), -1);
        }
        return null;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            PartGate.BOXES[i] = RotationUtils.rotateFace((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), (EnumFacing)facing);
        }
        HIT_VECTORS = new Vec3d[5];
        PartGate.HIT_VECTORS[0] = new Vec3d(0.5, 0.125, 0.0);
        PartGate.HIT_VECTORS[1] = new Vec3d(0.5, 0.125, 1.0);
        PartGate.HIT_VECTORS[2] = new Vec3d(0.0, 0.125, 0.5);
        PartGate.HIT_VECTORS[3] = new Vec3d(1.0, 0.125, 0.5);
        PartGate.HIT_VECTORS[4] = new Vec3d(0.5, 0.125, 0.5);
    }

    private class RedstoneCommunications
    implements IBundledEmitter,
    IBundledReceiver,
    IRedstoneEmitter,
    IRedstoneReceiver,
    ISimpleLogicSidedEmitter {
        private final EnumFacing side;

        RedstoneCommunications(EnumFacing side) {
            this.side = side;
        }

        public byte[] getBundledSignal() {
            GateConnection type = PartGate.this.logic.getType(this.side);
            return type.isOutput() && type.isBundled() ? PartGate.this.logic.getOutputValueBundled(this.side) : new byte[]{};
        }

        public void onBundledInputChange() {
            PartGate.this.onChanged();
        }

        public int getRedstoneSignal() {
            GateConnection type = PartGate.this.logic.getType(this.side);
            return type.isOutput() && type.isRedstone() ? (int)PartGate.this.logic.getOutputValueOutside(this.side) : 0;
        }

        public void onRedstoneInputChange() {
            PartGate.this.onChanged();
        }

        public EnumFacing getEmitterFace() {
            return ((PartGate)PartGate.this).orientation.facing.func_176734_d();
        }
    }
}

