/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.utils.UnlistedPropertyGeneric;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.SimpleLogicGates;

public class BlockGate
extends BlockBase
implements ITileEntityProvider {
    public static final UnlistedPropertyGeneric<PartGate> PROPERTY = new UnlistedPropertyGeneric("part", PartGate.class);

    public BlockGate() {
        super(Material.field_151594_q);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setOpaqueCube(false);
        this.setFullCube(false);
    }

    protected ISubItemProvider createSubItemProvider() {
        return () -> ImmutableList.copyOf(SimpleLogicGates.gateStacks);
    }

    public BlockFaceShape func_193383_a(IBlockAccess source, IBlockState state, BlockPos pos, EnumFacing facing) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof PartGate && ((PartGate)tile).getOrientation().facing == facing.func_176734_d()) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return ((PartGate)tile).getBox();
        }
        return Block.field_185505_j;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return ((IExtendedBlockState)state).withProperty(PROPERTY, (Object)((PartGate)tile));
        }
        return state;
    }

    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{PROPERTY});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return ((PartGate)tile).canConnectRedstone(side != null ? side.func_176734_d() : null);
        }
        return false;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return ((PartGate)tile).getWeakSignal(side.func_176734_d());
        }
        return 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return ((PartGate)tile).onActivated(playerIn, hand, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PartGate) {
            ((PartGate)tile).onNeighborBlockChange(fromPos, blockIn);
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return ((PartGate)tile).rotate(axis);
        }
        return false;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PartGate) {
            return new EnumFacing[]{((PartGate)tile).getOrientation().facing, ((PartGate)tile).getOrientation().facing.func_176734_d()};
        }
        return null;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new PartGate();
    }

    public void onNeighborChange(IBlockAccess worldIn, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PartGate) {
            PartGate gate = (PartGate)tile;
            if (gate.logic.hasComparatorInputs()) {
                ((PartGate)tile).onChanged();
                return;
            }
        }
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

