/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farmstructure;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.power.storage.IPowerStation;
import ipsis.woot.tileentity.TileEntityMobFactoryCell;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.EnumFarmUpgrade;
import ipsis.woot.util.WootMob;
import ipsis.woot.util.WootMobName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FarmSetup
implements IFarmSetup {
    private Map<EnumFarmUpgrade, Integer> upgradeMap = new HashMap<EnumFarmUpgrade, Integer>();
    private WootMob wootMob;
    private EnumEnchantKey enchantKey = EnumEnchantKey.NO_ENCHANT;
    private EnumMobFactoryTier tier = EnumMobFactoryTier.TIER_ONE;
    private EnumFacing facing = EnumFacing.SOUTH;
    private BlockPos exportBlockPos;
    private BlockPos importBlockPos;
    private IPowerStation powerStation;
    private World world;
    private int storedXp = 0;

    public FarmSetup(World world, WootMob wootMob) {
        this.wootMob = wootMob;
        this.world = world;
    }

    @Override
    public void setStoredXp(int storedXp) {
        this.storedXp = storedXp;
    }

    @Override
    public int getStoredXp() {
        return this.storedXp;
    }

    @Override
    @Nonnull
    public WootMob getWootMob() {
        return this.wootMob;
    }

    @Override
    @Nonnull
    public WootMobName getWootMobName() {
        return this.wootMob.getWootMobName();
    }

    @Override
    public int getNumMobs() {
        int numMobs;
        int massLevel = this.getUpgradeLevel(EnumFarmUpgrade.MASS);
        switch (massLevel) {
            case 1: {
                numMobs = Woot.wootConfiguration.getInteger(this.wootMob.getWootMobName(), EnumConfigKey.MASS_1_PARAM);
                break;
            }
            case 2: {
                numMobs = Woot.wootConfiguration.getInteger(this.wootMob.getWootMobName(), EnumConfigKey.MASS_2_PARAM);
                break;
            }
            case 3: {
                numMobs = Woot.wootConfiguration.getInteger(this.wootMob.getWootMobName(), EnumConfigKey.MASS_3_PARAM);
                break;
            }
            default: {
                numMobs = Woot.wootConfiguration.getInteger(this.wootMob.getWootMobName(), EnumConfigKey.NUM_MOBS);
            }
        }
        return numMobs;
    }

    @Override
    public int getUpgradeLevel(EnumFarmUpgrade upgrade) {
        if (this.upgradeMap.containsKey((Object)upgrade)) {
            return this.upgradeMap.get((Object)upgrade);
        }
        return 0;
    }

    @Override
    public void setUpgradeLevel(EnumFarmUpgrade upgrade, int level) {
        this.upgradeMap.put(upgrade, level);
    }

    @Override
    public void setFarmTier(EnumMobFactoryTier tier) {
        this.tier = tier;
    }

    @Override
    public void setEnchantKey(EnumEnchantKey key) {
        this.enchantKey = key;
    }

    @Override
    public boolean hasUpgrade(EnumFarmUpgrade upgrade) {
        return this.getUpgradeLevel(upgrade) != 0;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    @Nonnull
    public EnumEnchantKey getEnchantKey() {
        return this.enchantKey;
    }

    @Override
    @Nonnull
    public EnumMobFactoryTier getFarmTier() {
        return this.tier;
    }

    @Override
    public IPowerStation getPowerStation() {
        return this.powerStation;
    }

    @Override
    public void setPowerCellBlockPos(BlockPos blockPos) {
        if (blockPos == null) {
            this.powerStation = null;
            return;
        }
        TileEntity te = this.world.func_175625_s(blockPos);
        this.powerStation = te instanceof TileEntityMobFactoryCell ? ((TileEntityMobFactoryCell)te).getPowerStation() : null;
    }

    @Override
    public void setExportBlockPos(BlockPos blockPos) {
        this.exportBlockPos = blockPos;
    }

    @Override
    public void setImportBlockPos(BlockPos blockPos) {
        this.importBlockPos = blockPos;
    }

    @Nonnull
    private List<InventoryInfo> getConnectedChests(BlockPos origin) {
        ArrayList<InventoryInfo> chests = new ArrayList<InventoryInfo>();
        for (EnumFacing f : EnumFacing.field_176754_o) {
            IItemHandler iItemHandler;
            TileEntity te;
            if (!this.world.func_175667_e(origin.func_177972_a(f)) || (te = this.world.func_175625_s(origin.func_177972_a(f))) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d()) || (iItemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) == null) continue;
            chests.add(new InventoryInfo(te, iItemHandler));
        }
        return chests;
    }

    @Nonnull
    private List<TankInfo> getConnectedTanks(BlockPos origin, boolean drain) {
        ArrayList<TankInfo> tanks = new ArrayList<TankInfo>();
        block0: for (EnumFacing f : EnumFacing.field_176754_o) {
            IFluidTankProperties[] properties;
            IFluidHandler iFluidHandler;
            TileEntity te;
            if (!this.world.func_175667_e(origin.func_177972_a(f)) || (te = this.world.func_175625_s(origin.func_177972_a(f))) == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d()) || (iFluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) == null || (properties = iFluidHandler.getTankProperties()) == null) continue;
            for (IFluidTankProperties p : properties) {
                if ((!drain || !p.canDrain()) && (drain || !p.canFill())) continue;
                tanks.add(new TankInfo(te, iFluidHandler));
                continue block0;
            }
        }
        return tanks;
    }

    @Override
    @Nonnull
    public List<TileEntity> getConnectedImportTanksTiles() {
        ArrayList<TileEntity> tanks = new ArrayList<TileEntity>();
        if (this.importBlockPos == null) {
            return tanks;
        }
        List<TankInfo> connected = this.getConnectedTanks(this.importBlockPos, true);
        for (TankInfo i : connected) {
            tanks.add(i.te);
        }
        return tanks;
    }

    @Override
    @Nonnull
    public List<TileEntity> getConnectedExportTanksTiles() {
        ArrayList<TileEntity> tanks = new ArrayList<TileEntity>();
        if (this.exportBlockPos == null) {
            return tanks;
        }
        List<TankInfo> connected = this.getConnectedTanks(this.exportBlockPos, false);
        for (TankInfo i : connected) {
            tanks.add(i.te);
        }
        return tanks;
    }

    @Override
    @Nonnull
    public List<IFluidHandler> getConnectedImportTanks() {
        ArrayList<IFluidHandler> tanks = new ArrayList<IFluidHandler>();
        if (this.importBlockPos == null) {
            return tanks;
        }
        List<TankInfo> connected = this.getConnectedTanks(this.importBlockPos, true);
        for (TankInfo i : connected) {
            tanks.add(i.iFluidHandler);
        }
        return tanks;
    }

    @Override
    @Nonnull
    public List<IFluidHandler> getConnectedExportTanks() {
        ArrayList<IFluidHandler> tanks = new ArrayList<IFluidHandler>();
        if (this.exportBlockPos == null) {
            return tanks;
        }
        List<TankInfo> connected = this.getConnectedTanks(this.exportBlockPos, false);
        for (TankInfo i : connected) {
            tanks.add(i.iFluidHandler);
        }
        return tanks;
    }

    @Override
    @Nonnull
    public List<IItemHandler> getConnectedImportChests() {
        ArrayList<IItemHandler> chests = new ArrayList<IItemHandler>();
        if (this.importBlockPos == null) {
            return chests;
        }
        List<InventoryInfo> connected = this.getConnectedChests(this.importBlockPos);
        for (InventoryInfo i : connected) {
            chests.add(i.iItemHandler);
        }
        return chests;
    }

    @Override
    @Nonnull
    public List<IItemHandler> getConnectedExportChests() {
        ArrayList<IItemHandler> chests = new ArrayList<IItemHandler>();
        if (this.exportBlockPos == null) {
            return chests;
        }
        List<InventoryInfo> connected = this.getConnectedChests(this.exportBlockPos);
        for (InventoryInfo i : connected) {
            chests.add(i.iItemHandler);
        }
        return chests;
    }

    @Override
    @Nonnull
    public List<TileEntity> getConnectedImportChestsTiles() {
        ArrayList<TileEntity> chests = new ArrayList<TileEntity>();
        if (this.importBlockPos == null) {
            return chests;
        }
        List<InventoryInfo> connected = this.getConnectedChests(this.importBlockPos);
        for (InventoryInfo i : connected) {
            chests.add(i.te);
        }
        return chests;
    }

    @Override
    @Nonnull
    public List<TileEntity> getConnectedExportChestsTiles() {
        ArrayList<TileEntity> chests = new ArrayList<TileEntity>();
        if (this.exportBlockPos == null) {
            return chests;
        }
        List<InventoryInfo> connected = this.getConnectedChests(this.exportBlockPos);
        for (InventoryInfo i : connected) {
            chests.add(i.te);
        }
        return chests;
    }

    private class TankInfo {
        TileEntity te;
        IFluidHandler iFluidHandler;

        public TankInfo(TileEntity te, IFluidHandler iFluidHandler) {
            this.te = te;
            this.iFluidHandler = iFluidHandler;
        }
    }

    private class InventoryInfo {
        TileEntity te;
        IItemHandler iItemHandler;

        public InventoryInfo(TileEntity te, IItemHandler iItemHandler) {
            this.te = te;
            this.iItemHandler = iItemHandler;
        }
    }
}

