/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.configuration.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.Woot;
import ipsis.woot.configuration.ChangeLog;
import ipsis.woot.oss.FileUtils;
import ipsis.woot.oss.LogHelper;
import net.minecraft.util.JsonUtils;

public class ChangelogLoader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public void load() {
        try {
            String changelog = FileUtils.getFileFromJar("changelog.json");
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193837_a((Gson)GSON, (String)changelog, JsonObject.class, (boolean)false);
            this.parse(jsonObject);
        }
        catch (Exception e) {
            LogHelper.error("Could not load changelog");
            e.printStackTrace();
        }
    }

    private void parse(JsonObject jsonObject) {
        if (jsonObject == null || jsonObject.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"versions")) {
            String desc;
            int id;
            JsonObject json3;
            ChangeLog.Changes changes;
            JsonObject json2;
            String version;
            if (ele == null || !ele.isJsonObject() || (version = JsonUtils.func_151219_a((JsonObject)(json2 = (JsonObject)ele), (String)"version", (String)"")).equalsIgnoreCase("") || (changes = Woot.changeLog.addVersion(version)) == null) continue;
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json2, (String)"features")) {
                if (ele2 == null || !ele2.isJsonObject()) continue;
                json3 = (JsonObject)ele2;
                id = JsonUtils.func_151208_a((JsonObject)json3, (String)"id", (int)-1);
                desc = JsonUtils.func_151219_a((JsonObject)json3, (String)"desc", (String)"");
                changes.addFeature(id, desc);
            }
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json2, (String)"fixes")) {
                if (ele2 == null || !ele2.isJsonObject()) continue;
                json3 = (JsonObject)ele2;
                id = JsonUtils.func_151208_a((JsonObject)json3, (String)"id", (int)-1);
                desc = JsonUtils.func_151219_a((JsonObject)json3, (String)"desc", (String)"");
                changes.addFix(id, desc);
            }
        }
    }
}

