/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.gui;

import com.inventorypets.gui.GuiScrollingList;
import com.inventorypets.gui.GuiSlotBiomeList;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Mouse;

public class GuiBiomeList
extends GuiScreen {
    private GuiScreen mainMenu;
    private GuiSlotBiomeList biomesList;
    private GuiScrollingList modInfo;
    private int selected = -1;
    private ModContainer selectedMod;
    private int listWidth;
    private ArrayList<ModContainer> mods;
    private GuiButton configModButton;
    private GuiButton disableModButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiBiomeList(GuiScreen mainMenu) {
        int biomeNum = Biome.field_185377_q.func_148742_b().size();
        Biome[] allBiomeIds = new Biome[biomeNum];
        Object[] allBiomeNames = new String[biomeNum];
        for (int i = 0; i < biomeNum; ++i) {
            allBiomeNames[i] = Biome.field_185377_q.func_148754_a(i) != null ? Biome.func_185357_a((int)i).func_185359_l() + "||" + i : "zzzzz";
        }
        Arrays.sort(allBiomeNames);
        this.biomesList = (GuiSlotBiomeList)((Object)Arrays.asList(allBiomeNames));
        this.mainMenu = mainMenu;
    }

    public void func_73866_w_() {
        int slotHeight = 35;
        for (ModContainer mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.getName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.getVersion()) + 5 + slotHeight);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.biomesList = new GuiSlotBiomeList(this, this.mods, this.listWidth, slotHeight);
        this.field_146292_n.add(new GuiButton(6, (this.biomesList.right + this.field_146294_l) / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.configModButton = new GuiButton(20, 10, this.field_146295_m - 49, this.listWidth, 20, "Config");
        this.disableModButton = new GuiButton(21, 10, this.field_146295_m - 27, this.listWidth, 20, "Disable");
        this.field_146292_n.add(this.configModButton);
        this.field_146292_n.add(this.disableModButton);
        this.search = new GuiTextField(0, this.getFontRenderer(), 12, this.biomesList.bottom + 17, this.biomesList.listWidth - 4, 14);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int width = this.biomesList.listWidth / 1;
        int x = 10;
        int y = 10;
        GuiButton normalSort = new GuiButton(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, I18n.func_135052_a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.field_146124_l = false;
        this.field_146292_n.add(normalSort);
        this.field_146292_n.add(new GuiButton(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.field_146292_n.add(new GuiButton(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
        this.updateCache();
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.search.func_146192_a(x, y, button);
        if (button == 1 && x >= this.search.field_146209_f && x < this.search.field_146209_f + this.search.field_146218_h && y >= this.search.field_146210_g && y < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.search.func_146201_a(c, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadBiomes();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadBiomes();
            Collections.sort(this.mods, this.sortType);
            this.selected = this.biomesList.selectedIndex = this.mods.indexOf(this.selectedMod);
            this.sorted = true;
        }
    }

    private void reloadBiomes() {
        ArrayList<ModContainer> mods = this.biomesList.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getName().toLowerCase().contains(this.search.func_146179_b().toLowerCase()) || m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.mods = mods;
        this.lastFilterText = this.search.func_146179_b();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                for (GuiButton b : this.field_146292_n) {
                    if (SortType.getTypeForButton(b) == null) continue;
                    b.field_146124_l = true;
                }
                button.field_146124_l = false;
                this.sorted = false;
                this.sortType = type;
                this.mods = this.biomesList.getMods();
            } else {
                switch (button.field_146127_k) {
                    case 6: {
                        this.field_146297_k.func_147108_a(this.mainMenu);
                        return;
                    }
                    case 20: {
                        try {
                            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                            GuiScreen newScreen = guiFactory.createConfigGui((GuiScreen)this);
                            this.field_146297_k.func_147108_a(newScreen);
                        }
                        catch (Exception e) {
                            FMLLog.log.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selectedMod.getModId(), (Object)e);
                        }
                        return;
                    }
                }
            }
        }
        super.func_146284_a(button);
    }

    public int drawLine(String line, int offset, int shifty) {
        this.field_146289_q.func_78276_b(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.biomesList.drawScreen(mouseX, mouseY, partialTicks);
        if (this.modInfo != null) {
            this.modInfo.drawScreen(mouseX, mouseY, partialTicks);
        }
        int left = (this.field_146294_l - this.listWidth - 38) / 2 + this.listWidth + 30;
        this.func_73732_a(this.field_146289_q, "Mod List", left, 16, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String text = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
        int x = (10 + this.biomesList.right) / 2 - this.getFontRenderer().func_78256_a(text) / 2;
        this.getFontRenderer().func_78276_b(text, x, this.biomesList.bottom + 5, 0xFFFFFF);
        this.search.func_146194_f();
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        if (this.modInfo != null) {
            this.modInfo.handleMouseInput(mouseX, mouseY);
        }
        this.biomesList.handleMouseInput(mouseX, mouseY);
    }

    Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void selectModIndex(int index) {
        if (index == this.selected) {
            return;
        }
        this.selected = index;
        this.selectedMod = index >= 0 && index <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.updateCache();
    }

    public boolean modIndexSelected(int index) {
        return index == this.selected;
    }

    private void updateCache() {
        this.configModButton.field_146125_m = false;
        this.disableModButton.field_146125_m = false;
        this.modInfo = null;
        if (this.selectedMod == null) {
            return;
        }
        ResourceLocation logoPath = null;
        Dimension logoDims = new Dimension(0, 0);
        ArrayList<String> lines = new ArrayList<String>();
        ForgeVersion.CheckResult vercheck = ForgeVersion.getResult((ModContainer)this.selectedMod);
        String logoFile = this.selectedMod.getMetadata().logoFile;
        if (!logoFile.isEmpty()) {
            TextureManager tm = this.field_146297_k.func_110434_K();
            IResourcePack pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
            try {
                BufferedImage logo = null;
                if (pack != null) {
                    logo = pack.func_110586_a();
                } else {
                    InputStream logoResource = ((Object)((Object)this)).getClass().getResourceAsStream(logoFile);
                    if (logoResource != null) {
                        logo = ImageIO.read(logoResource);
                    }
                }
                if (logo != null) {
                    logoPath = tm.func_110578_a("modlogo", new DynamicTexture(logo));
                    logoDims = new Dimension(logo.getWidth(), logo.getHeight());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.selectedMod.getMetadata().autogenerated) {
            this.disableModButton.field_146125_m = true;
            this.disableModButton.field_146124_l = true;
            this.disableModButton.packedFGColour = 0;
            ModContainer.Disableable disableable = this.selectedMod.canBeDisabled();
            if (disableable == ModContainer.Disableable.RESTART) {
                this.disableModButton.packedFGColour = 0xFF3377;
            } else if (disableable != ModContainer.Disableable.YES) {
                this.disableModButton.field_146124_l = false;
            }
            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
            this.configModButton.field_146125_m = true;
            this.configModButton.field_146124_l = false;
            if (guiFactory != null) {
                this.configModButton.field_146124_l = guiFactory.hasConfigGui();
            }
            lines.add(this.selectedMod.getMetadata().name);
            lines.add(String.format("Version: %s (%s)", this.selectedMod.getDisplayVersion(), this.selectedMod.getVersion()));
            lines.add(String.format("Mod ID: '%s' Mod State: %s", this.selectedMod.getModId(), Loader.instance().getModState(this.selectedMod)));
            if (!this.selectedMod.getMetadata().credits.isEmpty()) {
                lines.add("Credits: " + this.selectedMod.getMetadata().credits);
            }
            lines.add("Authors: " + this.selectedMod.getMetadata().getAuthorList());
            lines.add("URL: " + this.selectedMod.getMetadata().url);
            if (this.selectedMod.getMetadata().childMods.isEmpty()) {
                lines.add("No child mods for this mod");
            } else {
                lines.add("Child mods: " + this.selectedMod.getMetadata().getChildModList());
            }
            if (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add("Update Available: " + (vercheck.url == null ? "" : vercheck.url));
            }
            lines.add(null);
            lines.add(this.selectedMod.getMetadata().description);
        } else {
            lines.add(TextFormatting.WHITE + this.selectedMod.getName());
            lines.add(TextFormatting.WHITE + "Version: " + this.selectedMod.getVersion());
            lines.add(TextFormatting.WHITE + "Mod State: " + Loader.instance().getModState(this.selectedMod));
            if (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add("Update Available: " + (vercheck.url == null ? "" : vercheck.url));
            }
            lines.add(null);
            lines.add(TextFormatting.RED + "No mod information found");
            lines.add(TextFormatting.RED + "Ask your mod author to provide a mod mcmod.info file");
        }
        if ((vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) && vercheck.changes.size() > 0) {
            lines.add(null);
            lines.add("Changes:");
            for (Map.Entry entry : vercheck.changes.entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add((String)entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo = new Info(this.field_146294_l - this.listWidth - 30, lines, logoPath, logoDims);
    }

    private class Info
    extends GuiScrollingList {
        @Nullable
        private ResourceLocation logoPath;
        private Dimension logoDims;
        private List<ITextComponent> lines;

        public Info(int width, @Nullable List<String> lines, ResourceLocation logoPath, Dimension logoDims) {
            super(GuiBiomeList.this.getMinecraftInstance(), width, GuiBiomeList.this.field_146295_m, 32, GuiBiomeList.this.field_146295_m - 88 + 4, GuiBiomeList.this.listWidth + 20, 60, GuiBiomeList.this.field_146294_l, GuiBiomeList.this.field_146295_m);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        @Override
        protected int getSize() {
            return 0;
        }

        @Override
        protected void elementClicked(int index, boolean doubleClick) {
        }

        @Override
        protected boolean isSelected(int index) {
            return false;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                int maxTextLength = this.listWidth - 8;
                if (maxTextLength < 0) continue;
                ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)GuiBiomeList.this.field_146289_q, (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if (this.logoPath != null) {
                double scaleX = (double)this.logoDims.width / 200.0;
                double scaleY = (double)this.logoDims.height / 65.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.logoDims.width = (int)((double)this.logoDims.width * scale);
                this.logoDims.height = (int)((double)this.logoDims.height * scale);
                height += this.logoDims.height;
                height += 10;
            }
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            if (this.logoPath != null) {
                GlStateManager.func_179147_l();
                GuiBiomeList.this.field_146297_k.field_71446_o.func_110577_a(this.logoPath);
                BufferBuilder wr = tess.func_178180_c();
                int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                wr.func_181662_b((double)offset, (double)(top + this.logoDims.height), (double)GuiBiomeList.this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)(top + this.logoDims.height), (double)GuiBiomeList.this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)top, (double)GuiBiomeList.this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
                wr.func_181662_b((double)offset, (double)top, (double)GuiBiomeList.this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179084_k();
                top += this.logoDims.height + 10;
            }
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.func_179147_l();
                    GuiBiomeList.this.field_146289_q.func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                top += 10;
            }
        }

        @Override
        protected void clickHeader(int x, int y) {
            int offset = y;
            if (this.logoPath != null) {
                offset -= this.logoDims.height + 10;
            }
            if (offset <= 0) {
                return;
            }
            int lineIdx = offset / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            ITextComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (ITextComponent part : line) {
                    if (!(part instanceof TextComponentString) || (k += GuiBiomeList.this.field_146289_q.func_78256_a(((TextComponentString)part).func_150265_g())) < x) continue;
                    GuiBiomeList.this.func_175276_a(part);
                    break;
                }
            }
        }
    }

    private static enum SortType implements Comparator<ModContainer>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        @Nullable
        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = StringUtils.func_76338_a((String)o1.getName()).toLowerCase();
            String name2 = StringUtils.func_76338_a((String)o2.getName()).toLowerCase();
            return this.compare(name1, name2);
        }
    }
}

