/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank;

import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.ItemEIO;
import crazypants.enderio.base.power.forge.item.IInternalPoweredItem;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.powertools.config.PersonalConfig;
import crazypants.enderio.powertools.init.PowerToolObject;
import crazypants.enderio.powertools.machine.capbank.BlockCapBank;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.util.NbtValue;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class BlockItemCapBank
extends ItemEIO
implements EnderCoreMethods.IOverlayRenderAware,
IInternalPoweredItem {
    @Nonnull
    public static ItemStack createItemStackWithPower(int meta, int storedEnergy) {
        ItemStack res = new ItemStack(PowerToolObject.block_cap_bank.getBlockNN(), 1, meta);
        if (storedEnergy > 0) {
            BlockItemCapBank.setStoredEnergyForItem(res, storedEnergy);
        }
        return res;
    }

    public static int getStoredEnergyForItem(@Nonnull ItemStack item) {
        return NbtValue.ENERGY.getInt(item);
    }

    public static void setStoredEnergyForItem(@Nonnull ItemStack item, int storedEnergy) {
        NbtValue.ENERGY.setInt(item, Math.max(0, storedEnergy));
    }

    public BlockItemCapBank(@Nonnull BlockCapBank blockCapBank) {
        super(blockCapBank);
        this.func_77627_a(true);
        this.func_77637_a(EnderIOTab.tabEnderIOMachines);
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack par1ItemStack) {
        return CapBankType.getTypeFromMeta(par1ItemStack.func_77960_j()).getUnlocalizedName();
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        if (((Boolean)PersonalConfig.capacitorBankRenderPowerOverlayOnItem.get()).booleanValue()) {
            PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
        }
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return CapBankType.getTypeFromMeta(stack.func_77960_j()).isCreative() || super.func_77636_d(stack);
    }

    @Override
    public int getMaxEnergyStored(@Nonnull ItemStack stack) {
        return CapBankType.getTypeFromMeta(stack.func_77960_j()).getMaxEnergyStored();
    }

    @Override
    public int getMaxInput(@Nonnull ItemStack container) {
        return CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxIO();
    }

    @Override
    public int getMaxOutput(@Nonnull ItemStack container) {
        return CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxIO();
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack container) {
        if (CapBankType.getTypeFromMeta(container.func_77960_j()).isCreative()) {
            return CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxEnergyStored() / 2;
        }
        return IInternalPoweredItem.super.getEnergyStored(container);
    }

    @Override
    public void setEnergyStored(@Nonnull ItemStack container, int energy) {
        if (CapBankType.getTypeFromMeta(container.func_77960_j()).isCreative()) {
            energy = CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxEnergyStored() / 2;
        }
        IInternalPoweredItem.super.setEnergyStored(container, energy);
    }
}

