/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.forge.item;

import crazypants.enderio.base.power.forge.item.IInternalPoweredItem;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalPoweredItemCap
implements IEnergyStorage {
    @Nonnull
    protected final ItemStack container;
    @Nonnull
    protected IInternalPoweredItem item;

    public InternalPoweredItemCap(@Nonnull ItemStack container) {
        this.container = container;
        this.item = (IInternalPoweredItem)container.func_77973_b();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - energy, Math.min(this.item.getMaxInput(this.container), maxReceive));
        if (!simulate) {
            this.setEnergyStored(energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.item.getMaxOutput(this.container), maxExtract));
        if (!simulate) {
            this.setEnergyStored(energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public void setEnergyStored(int energy) {
        this.item.setEnergyStored(this.container, energy);
    }

    public int getEnergyStored() {
        return this.item.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return this.item.getMaxEnergyStored(this.container);
    }

    public boolean canExtract() {
        if (this.container.func_190916_E() > 1) {
            return false;
        }
        return this.item.getMaxOutput(this.container) > 0;
    }

    public boolean canReceive() {
        if (this.container.func_190916_E() > 1) {
            return false;
        }
        return this.item.getMaxInput(this.container) > 0;
    }
}

