/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.integration.jei.IntegrationJEI;
import com.raoulvdberge.refinedstorage.integration.jei.RSJEIPlugin;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class TextFieldSearch
extends GuiTextField {
    private static final List<String> HISTORY = new ArrayList<String>();
    private int mode;
    private int historyIndex = -1;
    private List<Runnable> listeners = new LinkedList<Runnable>();

    public TextFieldSearch(int componentId, FontRenderer fontRenderer, int x, int y, int width) {
        super(componentId, fontRenderer, x, y, width, fontRenderer.field_78288_b);
        this.func_146185_a(false);
        this.func_146189_e(true);
        this.func_146193_g(0xFFFFFF);
        this.listeners.add(() -> {
            if (IntegrationJEI.isLoaded() && (this.mode == 2 || this.mode == 3)) {
                RSJEIPlugin.INSTANCE.getRuntime().getIngredientFilter().setFilterText(this.func_146179_b());
            }
        });
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
        boolean flag;
        boolean wasFocused = this.func_146206_l();
        boolean result = super.func_146192_a(mouseX, mouseY, mouseButton);
        boolean bl = flag = mouseX >= this.field_146209_f && mouseX < this.field_146209_f + this.field_146218_h && mouseY >= this.field_146210_g && mouseY < this.field_146210_g + this.field_146219_i;
        if (flag && mouseButton == 1) {
            this.func_146180_a("");
            this.func_146195_b(true);
            this.listeners.forEach(Runnable::run);
        } else if (wasFocused != this.func_146206_l()) {
            this.saveHistory();
        }
        return result;
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        boolean canLoseFocus = (Boolean)ObfuscationReflectionHelper.getPrivateValue(GuiTextField.class, (Object)((Object)this), (int)10);
        boolean result = super.func_146201_a(typedChar, keyCode);
        if (this.func_146206_l()) {
            if (keyCode == 200) {
                this.updateSearchHistory(-1);
                result = true;
            } else if (keyCode == 208) {
                this.updateSearchHistory(1);
                result = true;
            } else if (keyCode == 28) {
                this.saveHistory();
                if (canLoseFocus) {
                    this.func_146195_b(false);
                }
                result = true;
            }
        }
        if (keyCode == RSKeyBindings.FOCUS_SEARCH_BAR.func_151463_i() && canLoseFocus) {
            this.func_146195_b(!this.func_146206_l());
            this.saveHistory();
            result = true;
        }
        if (result) {
            this.listeners.forEach(Runnable::run);
        }
        return result;
    }

    private void updateSearchHistory(int delta) {
        if (HISTORY.isEmpty()) {
            return;
        }
        if (this.historyIndex == -1) {
            this.historyIndex = HISTORY.size();
        }
        this.historyIndex += delta;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        } else if (this.historyIndex > HISTORY.size() - 1) {
            this.historyIndex = HISTORY.size() - 1;
            if (delta == 1) {
                this.func_146180_a("");
                this.listeners.forEach(Runnable::run);
                return;
            }
        }
        this.func_146180_a(HISTORY.get(this.historyIndex));
        this.listeners.forEach(Runnable::run);
    }

    private void saveHistory() {
        if (!HISTORY.isEmpty() && HISTORY.get(HISTORY.size() - 1).equals(this.func_146179_b())) {
            return;
        }
        if (!this.func_146179_b().trim().isEmpty()) {
            HISTORY.add(this.func_146179_b());
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.func_146205_d(!IGrid.isSearchBoxModeWithAutoselection(mode));
        this.func_146195_b(IGrid.isSearchBoxModeWithAutoselection(mode));
    }
}

