/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNode
implements INetworkNode,
INetworkNodeVisitor {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_DIRECTION = "Direction";
    private static final String NBT_VERSION = "Version";
    @Nullable
    protected INetwork network;
    protected World world;
    protected BlockPos pos;
    protected int ticks;
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @Nullable
    protected UUID owner;
    protected String version;
    private EnumFacing direction = EnumFacing.NORTH;
    private boolean throttlingDisabled = true;
    private boolean couldUpdate;
    private int ticksSinceUpdateChanged;
    private boolean active;

    public NetworkNode(World world, BlockPos pos) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.world = world;
        this.pos = pos;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.markDirty();
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        IBlockState state = this.world.func_180495_p(this.pos);
        return new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_176201_c(state));
    }

    @Override
    public void onConnected(INetwork network) {
        this.onConnectedStateChange(network, true);
        this.network = network;
    }

    @Override
    public void onDisconnected(INetwork network) {
        this.network = null;
        this.onConnectedStateChange(network, false);
    }

    protected void onConnectedStateChange(INetwork network, boolean state) {
    }

    @Override
    public void markDirty() {
        if (!this.world.field_72995_K) {
            API.instance().getNetworkNodeManager(this.world).markForSaving();
        }
    }

    @Override
    public boolean canUpdate() {
        if (this.redstoneMode.isEnabled(this.world, this.pos) && this.network != null) {
            return this.network.canRun();
        }
        return false;
    }

    protected int getUpdateThrottleInactiveToActive() {
        return 20;
    }

    protected int getUpdateThrottleActiveToInactive() {
        return 4;
    }

    public void setThrottlingDisabled() {
        this.throttlingDisabled = true;
    }

    @Override
    public void update() {
        ++this.ticks;
        boolean canUpdate = this.canUpdate();
        if (this.couldUpdate != canUpdate) {
            ++this.ticksSinceUpdateChanged;
            if ((!canUpdate ? this.ticksSinceUpdateChanged > this.getUpdateThrottleActiveToInactive() : this.ticksSinceUpdateChanged > this.getUpdateThrottleInactiveToActive()) || this.throttlingDisabled) {
                this.ticksSinceUpdateChanged = 0;
                this.couldUpdate = canUpdate;
                this.throttlingDisabled = false;
                if (this.hasConnectivityState()) {
                    WorldUtils.updateBlock(this.world, this.pos);
                }
                if (this.network != null) {
                    this.onConnectedStateChange(this.network, canUpdate);
                    if (this.shouldRebuildGraphOnChange()) {
                        this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.world(), this.network.getPosition());
                    }
                }
            }
        } else {
            this.ticksSinceUpdateChanged = 0;
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        if (this.owner != null) {
            tag.func_186854_a(NBT_OWNER, this.owner);
        }
        tag.func_74778_a(NBT_VERSION, "1.6.14");
        tag.func_74768_a(NBT_DIRECTION, this.direction.ordinal());
        this.writeConfiguration(tag);
        return tag;
    }

    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        this.redstoneMode.write(tag);
        return tag;
    }

    public void read(NBTTagCompound tag) {
        if (tag.func_186855_b(NBT_OWNER)) {
            this.owner = tag.func_186857_a(NBT_OWNER);
        }
        if (tag.func_74764_b(NBT_DIRECTION)) {
            this.direction = EnumFacing.func_82600_a((int)tag.func_74762_e(NBT_DIRECTION));
        }
        if (tag.func_74764_b(NBT_VERSION)) {
            this.version = tag.func_74779_i(NBT_VERSION);
        }
        this.readConfiguration(tag);
        OneSixMigrationHelper.removalHook();
        if (this.version == null) {
            this.version = "1.6.14";
        }
    }

    public void readConfiguration(NBTTagCompound tag) {
        this.redstoneMode = RedstoneMode.read(tag);
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    public boolean canConduct(@Nullable EnumFacing direction) {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.canConduct(facing)) continue;
            operator.apply(this.world, this.pos.func_177972_a(facing), facing.func_176734_d());
        }
    }

    @Nullable
    public TileEntity getFacingTile() {
        return this.world.func_175625_s(this.pos.func_177972_a(this.getDirection()));
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
        this.onDirectionChanged();
        this.markDirty();
    }

    protected void onDirectionChanged() {
    }

    @Nullable
    public IItemHandler getDrops() {
        return null;
    }

    public boolean shouldRebuildGraphOnChange() {
        return false;
    }

    public boolean hasConnectivityState() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.markDirty();
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        return API.instance().isNetworkNodeEqual(this, o);
    }

    public int hashCode() {
        return API.instance().getNetworkNodeHashCode(this);
    }
}

