/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.hcmr;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.imageio.ImageIO;
import modmuss50.hcmr.GuiMapList;
import modmuss50.hcmr.WorldInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.io.FileUtils;

public class WorldVariations
extends WorldInfo {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    WorldInfo.AuthorData info;
    File directory;

    public static WorldVariations loadDir(File dir) throws IOException {
        File variations = new File(dir, "variations.json");
        if (!variations.exists()) {
            throw new RuntimeException("variations.json not found");
        }
        WorldVariations worldVariations = new WorldVariations();
        worldVariations.directory = dir;
        if (!variations.exists()) {
            worldVariations.info = new WorldInfo.AuthorData();
            FileUtils.writeStringToFile((File)variations, (String)GSON.toJson((Object)worldVariations.info), (Charset)Charsets.UTF_8);
        } else {
            worldVariations.info = (WorldInfo.AuthorData)GSON.fromJson(FileUtils.readFileToString((File)variations, (Charset)Charsets.UTF_8), WorldInfo.AuthorData.class);
        }
        return worldVariations;
    }

    @Override
    public String getName() {
        return this.directory.getName();
    }

    @Override
    public WorldInfo.AuthorData getAuthorData() {
        return this.info;
    }

    @Override
    public File getSaveFile() {
        return this.directory;
    }

    @Override
    public BufferedImage getIconImage() {
        if (this.getAuthorData() == null || this.getAuthorData().thumbnail == null) {
            return null;
        }
        File iconFile = new File(this.getSaveFile(), this.getAuthorData().thumbnail);
        if (!iconFile.exists()) {
            return null;
        }
        try {
            return ImageIO.read(iconFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void copy(GuiMapList mapList) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMapList(mapList, this.directory));
    }

    @Override
    public Optional<String> valid() {
        return Optional.empty();
    }
}

