/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.hcmr;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.imageio.ImageIO;
import modmuss50.hcmr.GuiMapList;
import modmuss50.hcmr.HardCoreMapReset;
import modmuss50.hcmr.WorldInfo;
import modmuss50.hcmr.voidWorld.HCMRWorldTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.world.storage.ISaveFormat;
import org.apache.commons.io.FileUtils;

public class WorldStructure
extends WorldInfo {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private String name;
    private WorldInfo.AuthorData author;
    private File structureFile;
    private File dir;

    public static WorldStructure loadStructure(File inputDir) throws IOException {
        StrctureInfo strctureInfo;
        File authorFile = new File(inputDir, "info.json");
        if (!authorFile.exists()) {
            strctureInfo = new StrctureInfo();
            FileUtils.writeStringToFile((File)authorFile, (String)GSON.toJson((Object)strctureInfo), (Charset)Charsets.UTF_8);
        } else {
            strctureInfo = (StrctureInfo)GSON.fromJson(FileUtils.readFileToString((File)authorFile, (Charset)Charsets.UTF_8), StrctureInfo.class);
        }
        File structureFile = new File(inputDir, strctureInfo.structureFile);
        WorldStructure structure = new WorldStructure();
        structure.name = inputDir.getName();
        structure.author = strctureInfo;
        structure.structureFile = structureFile;
        structure.dir = inputDir;
        return structure;
    }

    public static String getStructureFileName(File dir) {
        File authorFile = new File(dir, "info.json");
        if (!authorFile.exists()) {
            return "structure.nbt";
        }
        try {
            return ((StrctureInfo)WorldStructure.GSON.fromJson((String)FileUtils.readFileToString((File)authorFile, (Charset)Charsets.UTF_8), StrctureInfo.class)).structureFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "structure.nbt";
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WorldInfo.AuthorData getAuthorData() {
        return this.author;
    }

    @Override
    public File getSaveFile() {
        return this.structureFile;
    }

    @Override
    public BufferedImage getIconImage() {
        if (this.getAuthorData() == null || this.getAuthorData().thumbnail == null) {
            return null;
        }
        File iconFile = new File(this.dir, this.getAuthorData().thumbnail);
        if (!iconFile.exists()) {
            return null;
        }
        try {
            return ImageIO.read(iconFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void copy(GuiMapList mapList) {
        String name = mapList.nameField.func_146179_b();
        String folderName = GuiCreateWorld.func_146317_a((ISaveFormat)Minecraft.func_71410_x().func_71359_d(), (String)name);
        HCMRWorldTypes.createNewVoidWorld(folderName, name, this.structureFile);
    }

    @Override
    public Optional<String> valid() {
        if (HardCoreMapReset.voidWorldGeneration) {
            return Optional.empty();
        }
        return Optional.of("Enable void world generation in config!");
    }

    public static class StrctureInfo
    extends WorldInfo.AuthorData {
        public String structureFile = "structure.nbt";
    }
}

