/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.hcmr;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import modmuss50.hcmr.TemplateSaveLoader;
import modmuss50.hcmr.WorldInfo;
import modmuss50.hcmr.WorldVariations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.ISaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiMapList
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final int CREATE_BUTTON_ID = 0;
    private static final int CANCEL_BUTTON_ID = 1;
    public GuiScreen parent;
    private TemplateSaveLoader saveLoader;
    private List<WorldInfo> saveList;
    private GuiButton createButton;
    public GuiTextField nameField;
    private MapList mapList;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int selectedSlot;
    public String folderString;
    private static final String[] portNames = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private File dir;

    public GuiMapList(GuiScreen parent, File dir) {
        this.parent = parent;
        this.dir = dir;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initSaveList();
        this.nameField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 45, 200, 20);
        this.nameField.func_146195_b(true);
        if (this.parent instanceof GuiMapList) {
            this.nameField.func_146180_a(((GuiMapList)this.parent).nameField.func_146179_b());
        } else {
            this.nameField.func_146180_a(I18n.func_135052_a((String)"selectWorld.newWorld", (Object[])new Object[0]));
        }
        this.sanitizeFolderName();
        this.mapList = new MapList();
        this.createButton = new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0]));
        this.field_146292_n.add(this.createButton);
        String cancelButtonText = "gui.cancel";
        if (this.parent instanceof GuiMapList) {
            cancelButtonText = "gui.back";
        }
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)cancelButtonText, (Object[])new Object[0])));
        this.createButton.field_146124_l = false;
    }

    private void initSaveList() {
        if (this.saveLoader == null) {
            this.saveLoader = new TemplateSaveLoader(this.dir);
        }
        this.saveList = this.saveLoader.getSaveList();
        this.saveList.sort(Comparator.comparingInt(o -> o.getAuthorData().sort));
        this.selectedSlot = -1;
    }

    public void func_146284_a(GuiButton guiButton) throws IOException {
        WorldInfo saveFormat;
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == 1) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
        } else if (guiButton.field_146127_k == 0 && !(saveFormat = this.saveList.get(this.selectedSlot)).valid().isPresent()) {
            this.createMap();
        }
        this.mapList.func_148147_a(guiButton);
    }

    protected void func_73869_a(char keyChar, int keyCode) throws IOException {
        if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        if (this.nameField.func_146206_l()) {
            this.nameField.func_146201_a(keyChar, keyCode);
        }
        this.sanitizeFolderName();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.mapList.func_178039_p();
    }

    public void sanitizeFolderName() {
        ISaveFormat saveLoader = this.field_146297_k.func_71359_d();
        this.folderString = this.nameField.func_146179_b().trim();
        this.folderString = this.folderString.replaceAll("[\\./\"]", "_");
        for (char c0 : ChatAllowedCharacters.field_71567_b) {
            this.folderString = this.folderString.replace(c0, '_');
        }
        for (String s0 : portNames) {
            if (!this.folderString.equalsIgnoreCase(s0)) continue;
            this.folderString = "_" + this.folderString + "_";
        }
        while (saveLoader.func_75803_c(this.folderString) != null) {
            this.folderString = this.folderString + "-";
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.mapList.func_148128_a(x, y, f);
        this.nameField.func_146194_f();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.hardcoremapreset.create_title", (Object[])new Object[0]), this.field_146294_l / 2, 20, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterName", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 35, -6250336);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.resultFolder", (Object[])new Object[0]) + " " + this.folderString, this.field_146294_l / 2 - 100, 68, -6250336);
        super.func_73863_a(x, y, f);
    }

    private WorldInfo getSave() {
        return this.saveList.get(this.selectedSlot);
    }

    private void createMap() {
        if (this.selectedSlot == -1) {
            return;
        }
        this.getSave().copy(this);
    }

    private class MapList
    extends GuiSlot {
        public MapList() {
            super(GuiMapList.this.field_146297_k, GuiMapList.this.field_146294_l, GuiMapList.this.field_146295_m, 78, GuiMapList.this.field_146295_m - 32, 36);
        }

        protected int func_148127_b() {
            return GuiMapList.this.saveList.size();
        }

        protected void func_148144_a(int slot, boolean doubleClicked, int mouseX, int mouseY) {
            GuiMapList.this.selectedSlot = slot;
            ((GuiMapList)GuiMapList.this).createButton.field_146124_l = true;
            WorldInfo saveFormat = (WorldInfo)GuiMapList.this.saveList.get(slot);
            ((GuiMapList)GuiMapList.this).createButton.field_146126_j = saveFormat instanceof WorldVariations ? "Open Folder" : I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0]);
            if (!saveFormat.valid().isPresent() && doubleClicked) {
                GuiMapList.this.createMap();
            }
        }

        protected boolean func_148131_a(int slot) {
            return slot == GuiMapList.this.selectedSlot;
        }

        protected void func_148123_a() {
            GuiMapList.this.func_146276_q_();
        }

        public int func_148139_c() {
            return GuiMapList.this.field_146294_l - 40;
        }

        protected int func_148137_d() {
            return this.field_148155_a / 2 + this.func_148139_c() / 2 - 6;
        }

        public void func_192637_a(int slot, int x, int y, int slotHeight, int mouseX, int mouseY, float f) {
            WorldInfo saveFormat = (WorldInfo)GuiMapList.this.saveList.get(slot);
            String displayName = saveFormat.getName();
            String author = saveFormat.getAuthorData().author;
            String by = I18n.func_135052_a((String)"gui.hardcoremapreset.by", (Object[])new Object[0]);
            String topLine = displayName + ", " + TextFormatting.ITALIC + TextFormatting.BOLD + by + TextFormatting.RESET + ": " + author;
            if (GuiMapList.this.parent instanceof GuiMapList) {
                topLine = displayName;
            }
            String middleLine = saveFormat.getAuthorData().description;
            if (saveFormat.valid().isPresent()) {
                middleLine = middleLine + "   " + TextFormatting.RED + saveFormat.valid().get();
            }
            GuiMapList.this.func_73731_b(GuiMapList.this.field_146289_q, topLine, x + 34, y + 5, 0xFFFFFF);
            GuiMapList.this.func_73731_b(GuiMapList.this.field_146289_q, middleLine, x + 34, y + 17, 0x808080);
            if (((GuiMapList)GuiMapList.this).saveLoader.imageList.containsKey(saveFormat)) {
                ResourceLocation texture = ((GuiMapList)GuiMapList.this).saveLoader.imageList.get(saveFormat);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
                GlStateManager.func_179084_k();
            }
        }
    }
}

