/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.filters;

import com.latmod.mods.itemfilters.api.StringValueFilterVariant;
import com.latmod.mods.itemfilters.filters.StringValueFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CreativeTabFilter
extends StringValueFilter {
    private static Field labelField;
    private CreativeTabs tab = null;

    public static String getTabID(CreativeTabs tab) {
        if (labelField == null) {
            labelField = ObfuscationReflectionHelper.findField(CreativeTabs.class, (String)"field_78034_o");
        }
        try {
            return labelField.get(tab).toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public String getID() {
        return "creative_tab";
    }

    @Override
    public void setValue(String v) {
        super.setValue(v);
        this.tab = null;
    }

    @SideOnly(value=Side.CLIENT)
    public List<StringValueFilterVariant> getValueVariants() {
        ArrayList<StringValueFilterVariant> variants = new ArrayList<StringValueFilterVariant>();
        for (CreativeTabs t : CreativeTabs.field_78032_a) {
            if (t == CreativeTabs.field_78027_g || t == CreativeTabs.field_78036_m) continue;
            StringValueFilterVariant variant = new StringValueFilterVariant(CreativeTabFilter.getTabID(t));
            variant.title = I18n.func_135052_a((String)t.func_78024_c(), (Object[])new Object[0]);
            variant.icon = t.func_151244_d();
            variants.add(variant);
        }
        return variants;
    }

    public CreativeTabs getTab() {
        if (this.tab == null) {
            for (CreativeTabs t : CreativeTabs.field_78032_a) {
                if (!this.getValue().equals(CreativeTabFilter.getTabID(t))) continue;
                this.tab = t;
                return this.tab;
            }
            if (this.tab == null) {
                this.tab = CreativeTabs.field_78026_f;
            }
        }
        return this.tab;
    }

    @Override
    public boolean filter(ItemStack stack) {
        if (this.getValue().isEmpty()) {
            return false;
        }
        for (CreativeTabs t : stack.func_77973_b().getCreativeTabs()) {
            if (t != this.getTab()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getValidItems(List<ItemStack> list) {
        if (this.cachedItems == null) {
            NonNullList allItems = NonNullList.func_191196_a();
            for (Item item : Item.field_150901_e) {
                item.func_150895_a(this.getTab(), allItems);
            }
            this.cachedItems = CreativeTabFilter.compress((Collection<ItemStack>)allItems);
        }
        if (!this.cachedItems.isEmpty()) {
            list.addAll(this.cachedItems);
        }
    }
}

