/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2.experimental;

import ic2.api.recipe.Recipes;
import ic2.core.item.tool.ItemTreetap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.Core;
import techreborn.api.IC2Helper;
import techreborn.api.Reference;
import techreborn.api.TechRebornAPI;
import techreborn.compat.ICompatModule;
import techreborn.compatmod.ic2.IC2Dict;
import techreborn.compatmod.ic2.IC2Recipes;
import techreborn.compatmod.ic2.experimental.IC2DictExperimental;
import techreborn.compatmod.ic2.experimental.IC2RecipesExperimental;
import techreborn.init.IC2Duplicates;

@RebornRegistry(modOnly="ic2,!ic2-classic-spmod", modID="techreborn")
public class IC2ModuleExperimental
implements ICompatModule,
IC2Helper {
    @ConfigRegistry(config="ic2", comment="When enabled all of TR's compressor recipes are added to the IC2 compressor (Requies deduplication) (Requires restart)")
    public static boolean syncCompressorRecipes = true;

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TechRebornAPI.ic2Helper = this;
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (IC2Duplicates.deduplicate() && syncCompressorRecipes) {
            IC2Recipes.cloneMachineRecipes(Reference.COMPRESSOR_RECIPE, Recipes.compressor);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IC2Recipes.registerRecipes();
        IC2RecipesExperimental.registerRecipes();
    }

    public void initDuplicates() {
        try {
            IC2Dict.initDuplicates();
            IC2Dict.initOreDictionary();
            IC2DictExperimental.initDuplicates();
            IC2DictExperimental.initOreDictionary();
        }
        catch (NoClassDefFoundError notFound) {
            Core.logHelper.warn((Object)"Can't enable integration: IC2 is installed but cannot be hooked\nAre you using an incompatible IC2 version?\nPlease create an issue on GitHub and provide the FULL LOG and mod list");
        }
        catch (Throwable error) {
            Core.logHelper.warn((Object)"Exception thrown during IC2 integration init\nAre you using an incompatible IC2 version?\nPlease create an issue on GitHub and provide the FULL LOG and mod list\nError stack trace: ");
            error.printStackTrace();
        }
    }

    public boolean extractSap(EntityPlayer player, World world, BlockPos pos, EnumFacing side, IBlockState state, List<ItemStack> stacks) {
        if (state.func_177230_c() != Block.func_149634_a((Item)IC2Dict.getItem("rubber_wood").func_77973_b())) {
            return false;
        }
        return ItemTreetap.attemptExtract((EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side, (IBlockState)state, null);
    }
}

