/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block;

import com.latmod.mods.tesslocator.block.TessNetKey;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.AdvancedTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public enum TessNet {
    INSTANCE;

    private final Map<TessNetKey, List<AdvancedTesslocatorPart>> map = new HashMap<TessNetKey, List<AdvancedTesslocatorPart>>();
    private boolean refresh = true;

    public void refresh() {
        this.refresh = true;
    }

    public void update() {
        if (this.refresh) {
            this.map.clear();
            this.refresh = false;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                for (WorldServer world : server.field_71305_c) {
                    if (world == null) continue;
                    for (TileEntity tileEntity : world.field_147482_g) {
                        if (!(tileEntity instanceof TileTesslocator)) continue;
                        for (TesslocatorPart part : ((TileTesslocator)tileEntity).parts) {
                            if (!(part instanceof AdvancedTesslocatorPart)) continue;
                            TessNetKey key = new TessNetKey((AdvancedTesslocatorPart)part);
                            List<AdvancedTesslocatorPart> list = this.map.get(key);
                            if (list == null) {
                                list = new ArrayList<AdvancedTesslocatorPart>();
                                this.map.put(key, list);
                            }
                            list.add((AdvancedTesslocatorPart)part);
                        }
                    }
                }
            }
        }
    }

    public List<AdvancedTesslocatorPart> getAllParts(TessNetKey key) {
        List<AdvancedTesslocatorPart> list = this.map.get(key);
        return list == null ? Collections.emptyList() : list;
    }
}

