/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.engineering;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import pl.asie.charset.api.tools.IStopwatchTracker;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.charset.module.tools.engineering.ItemStopwatch;

public class StopwatchTracker
implements IStopwatchTracker,
IWorldEventListener {
    private final World world;
    private final Map<String, BlockPos> startPosMap = new HashMap<String, BlockPos>();
    private final Map<String, BlockPos> endPosMap = new HashMap<String, BlockPos>();
    private final Multimap<BlockPos, String> startPosListeners = HashMultimap.create();
    private final Multimap<BlockPos, String> endPosListeners = HashMultimap.create();
    private final Object2LongMap<String> startPosTimes = new Object2LongOpenHashMap();

    public StopwatchTracker() {
        this.world = null;
        this.startPosTimes.defaultReturnValue(-1L);
    }

    public StopwatchTracker(World world) {
        this.world = world;
        this.startPosTimes.defaultReturnValue(-1L);
        world.func_72954_a((IWorldEventListener)this);
    }

    public boolean clearPosition(String key) {
        BlockPos startPos = this.startPosMap.remove(key);
        BlockPos endPos = this.endPosMap.remove(key);
        if (startPos != null) {
            this.startPosListeners.remove((Object)startPos, (Object)key);
        }
        if (endPos != null) {
            this.endPosListeners.remove((Object)endPos, (Object)key);
        }
        return startPos != null || endPos != null;
    }

    public IStopwatchTracker.AddPositionResult addPosition(String key, BlockPos pos) {
        if (this.endPosMap.containsKey(key)) {
            this.clearPosition(key);
        }
        if (this.startPosMap.containsKey(key)) {
            this.endPosMap.put(key, pos);
            this.endPosListeners.put((Object)pos, (Object)key);
            return IStopwatchTracker.AddPositionResult.END;
        }
        this.startPosMap.put(key, pos);
        this.startPosListeners.put((Object)pos, (Object)key);
        return IStopwatchTracker.AddPositionResult.START;
    }

    private boolean notify(EntityPlayer player, ItemStack stack, String key, BiConsumer<EntityPlayer, ItemStack> onFound) {
        String stackKey;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStopwatch && key.equals(stackKey = ((ItemStopwatch)stack.func_77973_b()).getKey(stack))) {
            onFound.accept(player, stack);
            return true;
        }
        return false;
    }

    public void notify(String key, BiConsumer<EntityPlayer, ItemStack> onFound) {
        block0: for (EntityPlayer player : this.world.field_73010_i) {
            for (int i = 0; i < 10; ++i) {
                ItemStack stack;
                ItemStack itemStack = stack = i == 9 ? player.func_184592_cb() : player.field_71071_by.func_70301_a(i);
                if (this.notify(player, stack, key, onFound)) continue block0;
            }
        }
    }

    public void markChanged(BlockPos pos) {
        for (String s : this.endPosListeners.get((Object)pos)) {
            long time;
            long spt = this.startPosTimes.removeLong((Object)s);
            if (spt < 0L || (time = this.world.func_82737_E() - spt) <= 0L) continue;
            this.notify(s, (player, stack) -> {
                BlockPos endPos;
                String timeStr = String.format("%d.%02d", time / 20L, time % 20L * 5L);
                BlockPos startPos = this.startPosMap.get(s);
                if (!startPos.equals((Object)(endPos = pos))) {
                    new Notice((Object)startPos, (NotificationComponent)NotificationComponentString.translated((String)"notice.charset.stopwatch.timeStart", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.raw((String)timeStr, (NotificationComponent[])new NotificationComponent[0])})).withStyle(new NoticeStyle[]{NoticeStyle.DRAWFAR}).sendTo(player);
                }
                new Notice((Object)endPos, (NotificationComponent)NotificationComponentString.translated((String)"notice.charset.stopwatch.timeEnd", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.raw((String)timeStr, (NotificationComponent[])new NotificationComponent[0])})).withStyle(new NoticeStyle[]{NoticeStyle.DRAWFAR}).sendTo(player);
            });
        }
        for (String s : this.startPosListeners.get((Object)pos)) {
            if (this.startPosTimes.containsKey((Object)s)) continue;
            this.startPosTimes.put((Object)s, this.world.func_82737_E());
        }
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        this.markChanged(pos);
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

