/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui.components;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.mods.ftbguides.FTBGuidesLocalConfig;
import com.feed_the_beast.mods.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.IGuideComponentWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class TextGuideComponent
extends GuideComponent {
    public final String text;
    public Icon icon = Icon.EMPTY;
    public boolean bold = false;
    public boolean italic = false;
    public boolean underlined = false;
    public boolean strikethrough = false;
    public boolean code = false;
    public String click = "";
    public String hover = "";
    public double textScale = 1.0;

    public TextGuideComponent(String txt) {
        this.text = txt;
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new TextWidget(parent, this);
    }

    private static class TextWidget
    extends Widget
    implements IGuideComponentWidget {
        public final TextGuideComponent component;
        public final double scale;
        public final String[] text;

        public TextWidget(ComponentPanel parent, TextGuideComponent t) {
            super((Panel)parent);
            this.component = t;
            this.scale = MathHelper.func_151237_a((double)this.component.textScale, (double)0.25, (double)4.0);
            ArrayList strings = new ArrayList();
            Theme theme = this.getGui().getTheme();
            for (String s : t.text.split("\n")) {
                strings.addAll(theme.listFormattedStringToWidth(s, (int)((double)parent.maxWidth / this.scale)));
            }
            this.text = strings.isEmpty() ? StringUtils.EMPTY_ARRAY : strings.toArray(new String[0]);
            this.setWidth(0);
            for (int i = 0; i < this.text.length; ++i) {
                if (this.component.bold) {
                    this.text[i] = TextFormatting.BOLD + this.text[i];
                }
                if (this.component.italic) {
                    this.text[i] = TextFormatting.ITALIC + this.text[i];
                }
                if (this.component.underlined) {
                    this.text[i] = TextFormatting.UNDERLINE + this.text[i];
                }
                if (this.component.strikethrough) {
                    this.text[i] = TextFormatting.STRIKETHROUGH + this.text[i];
                }
                if (this.component.code) {
                    this.setWidth(Math.max(this.width, (int)((double)(this.text[i].length() * (FTBGuidesLocalConfig.general.use_unicode_font ? 4 : 6)) * this.scale)));
                    continue;
                }
                this.setWidth(Math.max(this.width, (int)((double)theme.getStringWidth(this.text[i]) * this.scale)));
            }
            int h1 = (int)(((double)theme.getFontHeight() + 1.0) * this.scale);
            this.setHeight(this.text.length == 0 ? h1 : h1 * this.text.length);
            if (!this.component.icon.isEmpty()) {
                this.setWidth(this.width + 10);
            }
        }

        public void addMouseOverText(List<String> list) {
            if (!this.component.hover.isEmpty()) {
                list.add(this.component.hover);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && !this.component.click.isEmpty() && this.handleClick(this.component.click)) {
                GuiHelper.playClickSound();
                return true;
            }
            return false;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.isMouseOver() && (!this.component.click.isEmpty() || !this.component.hover.isEmpty());
            if (!this.component.icon.isEmpty()) {
                this.component.icon.draw(x, y, 8, 8);
                x += 10;
            }
            int h1 = theme.getFontHeight() + 1;
            if (this.scale != 1.0) {
                GuiHelper.setFixUnicode((boolean)false);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
            Color4I color = theme.getContentColor(mouseOver || this.component.code ? WidgetType.MOUSE_OVER : WidgetType.NORMAL);
            for (int i = 0; i < this.text.length; ++i) {
                if (this.component.code) {
                    for (int ci = 0; ci < this.text[i].length(); ++ci) {
                        theme.drawString(Character.toString(this.text[i].charAt(ci)), ci * (FTBGuidesLocalConfig.general.use_unicode_font ? 4 : 6), h1 * i, color, 0);
                    }
                    continue;
                }
                theme.drawString(this.text[i], 0, h1 * i, color, 0);
            }
            GlStateManager.func_179121_F();
            if (this.scale != 1.0) {
                GuiHelper.setFixUnicode((boolean)this.getGui().fixUnicode);
            }
        }
    }
}

