/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui.components;

import com.feed_the_beast.mods.ftbguides.gui.GuidePage;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.ImageGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.LineBreakGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.TextGuideComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ComponentPage {
    public static final Pattern LINK_PATTERN = Pattern.compile("^\\[(.*)\\]\\((.*)\\)$");
    public static final Pattern IMAGE_PATTERN = Pattern.compile("^!\\[(.*)\\]\\((.*)\\)$");
    public static final Pattern HR_PATTERN = Pattern.compile("^-{3,}|\\*{3,}|_{3,}$");
    public final GuidePage page;
    public final List<GuideComponent> components;

    public ComponentPage(GuidePage p) {
        this.page = p;
        this.components = new ArrayList<GuideComponent>();
    }

    public void println(GuideComponent component) {
        if (!this.components.isEmpty() && component.isInline()) {
            this.components.add(LineBreakGuideComponent.INSTANCE);
        }
        this.components.add(component);
    }

    public void println(String text) {
        this.println(text.isEmpty() ? LineBreakGuideComponent.INSTANCE : new TextGuideComponent(text));
    }

    public void println() {
        this.println(LineBreakGuideComponent.INSTANCE);
    }

    public void println(@Nullable ITextComponent component) {
        if (component != null) {
            for (ITextComponent c : component) {
                TextGuideComponent t = new TextGuideComponent(c.func_150261_e());
                t.bold = c.func_150256_b().func_150223_b();
                t.italic = c.func_150256_b().func_150242_c();
                t.strikethrough = c.func_150256_b().func_150236_d();
                t.underlined = c.func_150256_b().func_150234_e();
                ClickEvent clickEvent = c.func_150256_b().func_150235_h();
                if (clickEvent != null) {
                    t.click = clickEvent.func_150669_a().func_150673_b() + ":" + clickEvent.func_150668_b();
                }
                this.components.add(t);
            }
        }
        this.components.add(LineBreakGuideComponent.INSTANCE);
    }

    public void printlnMarkdown(String s) {
        if ((s = s.trim()).isEmpty()) {
            this.println(LineBreakGuideComponent.INSTANCE);
            return;
        }
        if (HR_PATTERN.matcher(s).matches()) {
            this.println(HRGuideComponent.INSTANCE);
            return;
        }
        double scale = 1.0;
        boolean bold = false;
        if (s.startsWith("###")) {
            s = s.substring(3).trim();
            scale = 1.25;
        } else if (s.startsWith("##")) {
            s = s.substring(2).trim();
            scale = 1.25;
            bold = true;
        } else if (s.startsWith("#")) {
            s = s.substring(1).trim();
            scale = 1.5;
            bold = true;
        }
        Matcher matcher = IMAGE_PATTERN.matcher(s);
        if (matcher.find()) {
            ImageGuideComponent component = new ImageGuideComponent(this.page.getIcon(matcher.group(2)));
            component.hover = matcher.group(1);
            this.println(component);
            return;
        }
        matcher = LINK_PATTERN.matcher(s);
        if (matcher.find()) {
            TextGuideComponent component = new TextGuideComponent(matcher.group(1));
            component.textScale = scale;
            component.bold = bold;
            component.click = matcher.group(2);
            this.println(component);
            return;
        }
        TextGuideComponent component = new TextGuideComponent(s);
        component.textScale = scale;
        component.bold = bold;
        this.println(component);
    }
}

