/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides;

import com.feed_the_beast.ftblib.events.SidebarButtonCreatedEvent;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.mods.ftbguides.FTBGuides;
import com.feed_the_beast.mods.ftbguides.FTBGuidesConfig;
import com.feed_the_beast.mods.ftbguides.FTBGuidesLocalConfig;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbguides", value={Side.CLIENT})
public class FTBGuidesEventHandler {
    private static final ResourceLocation GUIDES_BUTTON = new ResourceLocation("ftbguides", "guides");

    @SubscribeEvent
    public static void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)GUIDES_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (FTBGuidesConfig.general.flash_guides && !FTBGuidesConfig.general.modpack_guide_version.isEmpty() && System.currentTimeMillis() % 1000L >= 500L && !FTBGuidesLocalConfig.general.last_guide_version.equals(FTBGuidesConfig.general.modpack_guide_version)) {
                    return "[!]";
                }
                return "";
            });
            event.getButton().setTooltipHandler(list -> {
                if (FTBGuidesConfig.general.flash_guides && !FTBGuidesConfig.general.modpack_guide_version.isEmpty() && !FTBGuidesLocalConfig.general.last_guide_version.equals(FTBGuidesConfig.general.modpack_guide_version)) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"sidebar_button.ftbguides.guides.new_version", (Object[])new Object[0]));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBGuides.KEY_GUIDE.func_151468_f()) {
            FTBGuides.openGuidesGui("");
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K && event.getItemStack().func_77973_b() == Items.field_151122_aG && event.getItemStack().func_77942_o() && event.getItemStack().func_77978_p().func_74764_b("Guide")) {
            FTBGuides.openGuidesGui(event.getItemStack().func_77978_p().func_74779_i("Guide"));
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbguides")) {
            switch (event.getID().func_110623_a()) {
                case "reload": {
                    FTBGuides.setShouldReload();
                    break;
                }
                case "open_gui": {
                    FTBGuides.openGuidesGui("");
                }
            }
            event.setCanceled(true);
        } else if (event.getID().func_110624_b().equals("guide")) {
            FTBGuides.openGuidesGui(event.getID().func_110623_a());
            event.setCanceled(true);
        }
    }
}

