/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.gui;

import bre.smoothfont.util.ModLib;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiSliderEx
extends GuiSlider {
    private String prefix;
    private String normalStr;
    private double normalVal;
    private String specialStr = null;
    private double specialVal;
    private boolean showDec;
    private boolean showPercent;
    private double resolutionFactor = 1.0;

    public GuiSliderEx(int id, int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean showPercent, boolean drawStr, String normalStr, double normalVal) {
        super(id, xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr);
        this.prefix = prefix;
        this.normalStr = normalStr;
        this.normalVal = normalVal;
        this.showDec = showDec;
        this.showPercent = showPercent;
        if (showDec) {
            this.precision = 1;
        }
        if (drawStr && normalStr != null && currentVal == normalVal) {
            this.field_146126_j = this.field_146126_j + " (" + normalStr + ")";
        }
        if (this.drawString && this.specialStr != null && currentVal == this.specialVal) {
            this.field_146126_j = prefix + this.specialStr;
        }
    }

    public void updateSlider() {
        super.updateSlider();
        if (this.showDec || this.showPercent) {
            double val = (double)ModLib.round((this.sliderValue * (this.maxValue - this.minValue) + this.minValue) * this.resolutionFactor) / this.resolutionFactor;
            if (this.drawString) {
                if (this.showPercent) {
                    int percent = ModLib.round((val - this.normalVal) / this.normalVal * 100.0);
                    this.field_146126_j = this.dispString + (percent > 0 ? "+" : "") + percent + "%";
                } else {
                    this.field_146126_j = this.dispString + val + this.suffix;
                }
                if (this.normalStr != null && val == this.normalVal) {
                    this.field_146126_j = this.field_146126_j + " (" + this.normalStr + ")";
                }
                if (this.specialStr != null && val == this.specialVal) {
                    this.field_146126_j = this.prefix + this.specialStr;
                }
            }
        } else {
            int val = (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (this.drawString) {
                this.field_146126_j = this.dispString + val + this.suffix;
                if (this.normalStr != null && (long)val == Math.round(this.normalVal)) {
                    this.field_146126_j = this.field_146126_j + " (" + this.normalStr + ")";
                }
                if (this.specialStr != null && (long)val == Math.round(this.specialVal)) {
                    this.field_146126_j = this.prefix + this.specialStr;
                }
            }
        }
    }

    public GuiSliderEx setValueResolution(double resolution) {
        this.resolutionFactor = 1.0 / resolution;
        return this;
    }

    public GuiSliderEx setDisplayPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public GuiSliderEx setSpecialStr(String str) {
        this.specialStr = str;
        return this;
    }

    public GuiSliderEx setSpecialVal(double val) {
        this.specialVal = val;
        return this;
    }

    public GuiSliderEx updateSliderString() {
        this.updateSlider();
        return this;
    }

    public double getValueEx() {
        double val = (double)ModLib.round(super.getValue() * this.resolutionFactor) / this.resolutionFactor;
        return val;
    }
}

