/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.gui;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontShader;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.asm.Transformer;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.gui.GuiCommon;
import bre.smoothfont.gui.GuiConfigAdvanced;
import bre.smoothfont.gui.GuiFontSelection;
import bre.smoothfont.gui.GuiSliderEx;
import bre.smoothfont.util.ModLib;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiConfigScreen
extends GuiScreen
implements GuiYesNoCallback {
    private static final int dx = -160;
    private static final int btnGap = 4;
    private static final int bx = 158;
    private static final int bx3 = 104;
    private static final int by = 20;
    private static final int rowOfParts = 6;
    private static final int gridHeight = 24;
    private static final int sampleHeight = 70;
    private int baseY;
    private static int prevX;
    private static int prevY;
    private GuiScreen parentScreen;
    protected int sampleScaleFactor = 4;
    private HoverChecker[] buttonHover = new HoverChecker[GuiPart.values().length];
    private static final int tooltipTimer = 500;

    public GuiConfigScreen(GuiScreen parent) {
        this.parentScreen = parent;
    }

    public void func_73866_w_() {
        boolean featuresEnabled = CommonConfig.currentConfig.runMode == 0;
        this.field_146292_n.clear();
        this.baseY = this.field_146295_m / 2 - 107;
        Object btn = this.arrangeHalfButton(GuiPart.BTN_ENABLE_INTERPOLATION, I18n.func_135052_a((String)"smoothfont.config.menu.enableInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableInterpolation));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_BLUR_REDUCTION, I18n.func_135052_a((String)"smoothfont.config.menu.blurReduction", (Object[])new Object[0]) + ": " + (CommonConfig.currentConfig.blurReduction == 0 ? I18n.func_135052_a((String)"smoothfont.config.OFF", (Object[])new Object[0]) : "<=" + CommonConfig.currentConfig.blurReduction));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfSlider(GuiPart.SLD_BRIGHTNESS, I18n.func_135052_a((String)"smoothfont.config.menu.brightness", (Object[])new Object[0]) + ": ", "", -1.0, 10.0, CommonConfig.currentConfig.autoBrightness ? -1.0 : (double)CommonConfig.currentConfig.brightness, I18n.func_135052_a((String)"smoothfont.config.OFF", (Object[])new Object[0]), 0, false, false).setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.auto", (Object[])new Object[0]) + " (" + this.getCurrentAutoBrightness() + ")").setSpecialVal(-1.0).updateSliderString();
        this.field_146292_n.add(btn);
        btn.field_146124_l = !CommonConfig.currentConfig.performanceMode && featuresEnabled && FontShader.getInstance().isSupported();
        btn = this.arrangeHalfSlider(GuiPart.SLD_SHADOW_LENGTH, I18n.func_135052_a((String)"smoothfont.config.menu.shadowLength", (Object[])new Object[0]) + ": ", "", 0.0, 20.0, CommonConfig.currentConfig.shadowLength, I18n.func_135052_a((String)"smoothfont.config.default", (Object[])new Object[0]), 5, false, false);
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_EXCLUDE_INT_MULTIPLE, I18n.func_135052_a((String)"smoothfont.config.menu.excludeIntMultiple", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.excludeIntMultiple));
        this.field_146292_n.add(btn);
        btn.field_146124_l = !CommonConfig.currentConfig.performanceMode && featuresEnabled;
        btn = this.arrangeHalfSlider(GuiPart.SLD_MAGNIFICATION_LIMIT, I18n.func_135052_a((String)"smoothfont.config.menu.limitMagnification", (Object[])new Object[0]) + ": ", "x", 1.0, 5.0, CommonConfig.currentConfig.limitMagnification, null, 3, true, false).setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.unlimited", (Object[])new Object[0])).setSpecialVal(5.0).setValueResolution(0.1).setDisplayPrecision(1).updateSliderString();
        this.field_146292_n.add(btn);
        btn.field_146124_l = !CommonConfig.currentConfig.performanceMode && featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_PERFORMANCE, I18n.func_135052_a((String)"smoothfont.config.menu.performanceMode", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.menu.performanceMode." + (CommonConfig.currentConfig.performanceMode ? 1 : 0)), (Object[])new Object[0]));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_ADVANCED_OPTIONS, I18n.func_135052_a((String)"smoothfont.config.menu.advancedOptions", (Object[])new Object[0])));
        btn = this.customButton(GuiPart.BTN_FONT, I18n.func_135052_a((String)"smoothfont.config.menu.font", (Object[])new Object[0]), this.field_146294_l / 2 + -160, this.baseY + 120, 104, 20);
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.customButton(GuiPart.BTN_DEFAULT, I18n.func_135052_a((String)"smoothfont.config.menu.default", (Object[])new Object[0]), this.field_146294_l / 2 + -160 + 104 + 4, this.baseY + 120, 104, 20);
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.customButton(GuiPart.BTN_EXIT, I18n.func_135052_a((String)"smoothfont.config.menu.exit", (Object[])new Object[0]), this.field_146294_l / 2 + -160 + 216, this.baseY + 120, 104, 20);
        this.field_146292_n.add(btn);
        btn = this.customButton(GuiPart.BTN_TOGGLE_CONFIG, I18n.func_135052_a((String)("smoothfont.config.menu." + (CommonConfig.isPlayerConfig() ? "playerConfig" : "globalConfig")), (Object[])new Object[0]), this.field_146294_l - 80, 0, 80, 20);
        this.field_146292_n.add(btn);
        btn.field_146124_l = CommonConfig.globalConfig.enablePerPlayerConfig;
        btn = this.customButton(GuiPart.BTN_RUN_MODE, I18n.func_135052_a((String)("smoothfont.config.menu.runMode." + CommonConfig.currentConfig.runMode), (Object[])new Object[0]), 0, 0, 80, 20);
        this.field_146292_n.add(btn);
    }

    private GuiButton arrangeHalfButton(GuiPart guiPart, String buttonLabel) {
        int id = guiPart.ordinal();
        GuiButton button = new GuiButton(id, this.field_146294_l / 2 + ((id & 1) == 0 ? -160 : 2), this.baseY + 24 * ((id >>> 1) + 1), 158, 20, buttonLabel);
        this.buttonHover[id] = new HoverChecker(button, 500);
        return button;
    }

    private GuiButton customButton(GuiPart guiPart, String buttonLabel, int posX, int posY, int width, int height) {
        int id = guiPart.ordinal();
        GuiButton button = new GuiButton(id, posX, posY, width, height, buttonLabel);
        this.buttonHover[id] = new HoverChecker(button, 500);
        return button;
    }

    private GuiSliderEx arrangeHalfSlider(GuiPart guiPart, String sliderLabel, String suffix, double minVal, double maxVal, double curVal, String normalStr, int normalVal, boolean showDec, boolean showPercent) {
        int id = guiPart.ordinal();
        GuiSliderEx slider = new GuiSliderEx(id, this.field_146294_l / 2 + ((id & 1) == 0 ? -160 : 2), this.baseY + 24 * ((id >>> 1) + 1), 158, 20, sliderLabel, suffix, minVal, maxVal, curVal, showDec, showPercent, true, normalStr, normalVal){

            protected void func_146119_b(Minecraft mc, int par1, int par2) {
                super.func_146119_b(mc, par1, par2);
                if (this.dragging) {
                    GuiConfigScreen.this.func_146284_a((GuiButton)this);
                }
            }
        };
        this.buttonHover[id] = new HoverChecker((GuiButton)slider, 500);
        return slider;
    }

    public void func_146284_a(GuiButton button) {
        GuiPart[] guiPartArray = GuiPart.values();
        GuiPart guiPart = guiPartArray[button.field_146127_k];
        switch (guiPart) {
            case BTN_ENABLE_INTERPOLATION: {
                CommonConfig.currentConfig.enableInterpolation = !CommonConfig.currentConfig.enableInterpolation;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.enableInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableInterpolation);
                FontRendererHook.texFilterSettingId = FontUtils.getTexFilterSettingId();
                CommonConfig.saveCurrentConfig();
                break;
            }
            case BTN_BLUR_REDUCTION: {
                if (CommonConfig.currentConfig.blurReduction <= 0) {
                    CommonConfig.currentConfig.blurReduction = 10;
                } else if (CommonConfig.currentConfig.blurReduction < 16) {
                    CommonConfig.currentConfig.blurReduction = 16;
                } else if (CommonConfig.currentConfig.blurReduction >= 16) {
                    CommonConfig.currentConfig.blurReduction = 0;
                }
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.blurReduction", (Object[])new Object[0]) + ": " + (CommonConfig.currentConfig.blurReduction == 0 ? I18n.func_135052_a((String)"smoothfont.config.OFF", (Object[])new Object[0]) : "<=" + CommonConfig.currentConfig.blurReduction);
                CommonConfig.saveCurrentConfig();
                FontTextureManager.getInstance().func_110549_a(this.field_146297_k.func_110442_L());
                break;
            }
            case SLD_BRIGHTNESS: {
                CommonConfig.currentConfig.autoBrightness = ((GuiSlider)button).getValueInt() == -1;
                CommonConfig.currentConfig.brightness = CommonConfig.currentConfig.autoBrightness ? this.getCurrentAutoBrightness() : ((GuiSlider)button).getValueInt();
                CommonConfig.saveCurrentConfig();
                break;
            }
            case SLD_SHADOW_LENGTH: {
                CommonConfig.currentConfig.shadowLength = ((GuiSlider)button).getValueInt();
                FontRendererHook.shadowAdjustVal = FontUtils.getShadowAdjustVal(CommonConfig.currentConfig.shadowLength);
                CommonConfig.saveCurrentConfig();
                break;
            }
            case BTN_EXCLUDE_INT_MULTIPLE: {
                CommonConfig.currentConfig.excludeIntMultiple = !CommonConfig.currentConfig.excludeIntMultiple;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.excludeIntMultiple", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.excludeIntMultiple);
                CommonConfig.saveCurrentConfig();
                break;
            }
            case SLD_MAGNIFICATION_LIMIT: {
                CommonConfig.currentConfig.limitMagnification = ((GuiSliderEx)button).getValueEx();
                CommonConfig.currentConfig.excludeHighMag = CommonConfig.currentConfig.limitMagnification != ((GuiSliderEx)button).maxValue;
                CommonConfig.saveCurrentConfig();
                break;
            }
            case BTN_FONT: {
                GuiFontSelection guiFontSelection = new GuiFontSelection(this);
                this.field_146297_k.func_147108_a((GuiScreen)guiFontSelection);
                break;
            }
            case BTN_ADVANCED_OPTIONS: {
                GuiConfigAdvanced guiConfigAdvanced = new GuiConfigAdvanced(this);
                this.field_146297_k.func_147108_a((GuiScreen)guiConfigAdvanced);
                break;
            }
            case BTN_PERFORMANCE: {
                CommonConfig.currentConfig.performanceMode = !CommonConfig.currentConfig.performanceMode;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.performanceMode", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.menu.performanceMode." + (CommonConfig.currentConfig.performanceMode ? 1 : 0)), (Object[])new Object[0]);
                CommonConfig.saveCurrentConfig();
                ((GuiButton)this.field_146292_n.get((int)GuiPart.SLD_BRIGHTNESS.ordinal())).field_146124_l = !CommonConfig.currentConfig.performanceMode;
                ((GuiButton)this.field_146292_n.get((int)GuiPart.BTN_EXCLUDE_INT_MULTIPLE.ordinal())).field_146124_l = !CommonConfig.currentConfig.performanceMode;
                ((GuiButton)this.field_146292_n.get((int)GuiPart.SLD_MAGNIFICATION_LIMIT.ordinal())).field_146124_l = !CommonConfig.currentConfig.performanceMode;
                break;
            }
            case BTN_DEFAULT: {
                GuiYesNo guiYesNo = new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"smoothfont.key.categories", (Object[])new Object[0]), CommonConfig.isPlayerConfig() ? I18n.func_135052_a((String)"smoothfont.config.menu.default.yesno.player", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.menu.default.yesno.global", (Object[])new Object[0]), 0);
                this.field_146297_k.func_147108_a((GuiScreen)guiYesNo);
                break;
            }
            case BTN_EXIT: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                if (this.parentScreen != null) break;
                this.field_146297_k.func_71381_h();
                break;
            }
            case BTN_TOGGLE_CONFIG: {
                boolean curAltLERP = CommonConfig.currentConfig.alternativeInterpolation;
                CommonConfig.toggleConfig();
                button.field_146126_j = I18n.func_135052_a((String)("smoothfont.config.menu." + (CommonConfig.isPlayerConfig() ? "playerConfig" : "globalConfig")), (Object[])new Object[0]);
                FontUtils.applyAllConfigParameters(curAltLERP != CommonConfig.currentConfig.alternativeInterpolation);
                this.func_73866_w_();
                this.refreshGuiScale();
                break;
            }
            case BTN_RUN_MODE: {
                CommonConfig.currentConfig.runMode = ModLib.getNextCyclicCounter(CommonConfig.currentConfig.runMode, 0, 2, GuiConfigScreen.func_146272_n());
                button.field_146126_j = I18n.func_135052_a((String)("smoothfont.config.menu.runMode." + CommonConfig.currentConfig.runMode), (Object[])new Object[0]);
                CommonConfig.saveCurrentConfig();
                FontRendererHook.updateRunMode();
                this.func_73866_w_();
                break;
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        switch (id) {
            case 0: {
                if (!result) break;
                boolean curAltInterpolation = CommonConfig.currentConfig.alternativeInterpolation;
                CommonConfig.resetCurrentConfig();
                FontUtils.applyAllConfigParameters(curAltInterpolation != CommonConfig.currentConfig.alternativeInterpolation);
                this.func_73866_w_();
                this.refreshGuiScale();
                break;
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    private void refreshGuiScale() {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int x = scaledresolution.func_78326_a();
        int y = scaledresolution.func_78328_b();
        this.func_146280_a(this.field_146297_k, x, y);
    }

    public void func_146286_b(int mouseX, int mouseY, int which) {
        super.func_146286_b(mouseX, mouseY, which);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"smoothfont.key.categories", (Object[])new Object[0]), this.field_146294_l / 2, this.baseY + 8, 0xFFFFFF);
        GuiCommon.drawSamples(this, this.field_146294_l / 2, this.baseY + 144, this.sampleScaleFactor);
        this.drawWarningMessage(2, this.field_146295_m - 18);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltip(mouseX, mouseY);
    }

    private void drawWarningMessage(int posX, int posY) {
        if (CommonConfig.globalConfig.debugLog && Transformer.transformingErrorId != 0) {
            GuiConfigScreen.func_73734_a((int)posX, (int)posY, (int)(posX + this.field_146294_l), (int)(posY + 18), (int)-536870912);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"smoothfont.msg.transformingFailed", (Object[])new Object[0]) + "(" + Transformer.transformingErrorId + ")", posX, posY, 0xFF0000);
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    private void drawTooltip(int mouseX, int mouseY) {
        for (GuiPart gp : GuiPart.values()) {
            if (this.buttonHover[gp.ordinal()] == null || !this.buttonHover[gp.ordinal()].checkHover(mouseX, mouseY)) continue;
            if (mouseX != prevX || mouseY != prevY || GuiConfigScreen.func_146272_n() || GuiConfigScreen.func_146271_m() || GuiConfigScreen.func_175283_s()) {
                this.buttonHover[gp.ordinal()].resetHoverTimer();
            } else {
                switch (gp) {
                    case BTN_ENABLE_INTERPOLATION: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.enableInterpolation", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_BLUR_REDUCTION: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.blurReduction", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_BRIGHTNESS: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.brightness", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_SHADOW_LENGTH: {
                        break;
                    }
                    case BTN_EXCLUDE_INT_MULTIPLE: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.excludeIntMultiple", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_MAGNIFICATION_LIMIT: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.limitMagnification", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_FONT: {
                        break;
                    }
                    case BTN_ADVANCED_OPTIONS: {
                        break;
                    }
                    case BTN_PERFORMANCE: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.performanceMode", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_DEFAULT: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.setToDefault", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_EXIT: {
                        break;
                    }
                    case BTN_TOGGLE_CONFIG: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.configSelection", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_RUN_MODE: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.runMode", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                }
            }
            prevX = mouseX;
            prevY = mouseY;
        }
    }

    private List strToList(String str) {
        return GuiCommon.strToList(this.field_146289_q, Math.min(200, this.field_146294_l / 2 - 20), str);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel() / 120;
        this.sampleScaleFactor += i;
        if (this.sampleScaleFactor < 1) {
            this.sampleScaleFactor = 1;
        }
        if (this.sampleScaleFactor > 16) {
            this.sampleScaleFactor = 16;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 2) {
            this.sampleScaleFactor = 4;
        }
    }

    private int getCurrentAutoBrightness() {
        Minecraft mc = Minecraft.func_71410_x();
        if (CommonConfig.currentConfig.useOSFont) {
            return FontRasterizer.getInstance().autoBrightnessValue;
        }
        FontRendererHook frh = FontRendererHook.getMcDefaultFontRendererHook();
        if (frh != null) {
            if (mc.func_152349_b()) {
                return frh.autoBrightnessUnicode;
            }
            return frh.autoBrightnessDefault;
        }
        return -1;
    }

    private static enum GuiPart {
        BTN_ENABLE_INTERPOLATION,
        BTN_BLUR_REDUCTION,
        SLD_BRIGHTNESS,
        SLD_SHADOW_LENGTH,
        BTN_EXCLUDE_INT_MULTIPLE,
        SLD_MAGNIFICATION_LIMIT,
        BTN_PERFORMANCE,
        BTN_ADVANCED_OPTIONS,
        BTN_DEFAULT,
        BTN_FONT,
        BTN_EXIT,
        BTN_TOGGLE_CONFIG,
        BTN_RUN_MODE;

    }
}

