/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.config;

import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.OldConfig;
import bre.smoothfont.util.ModLib;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GlobalConfig
extends CommonConfig {
    public static boolean existingConfigFile;
    public static boolean debug;
    public static boolean coreDebug;
    public static int multiThread;
    public static float autosizingTgtAscent;
    public static float referenceBaseline;
    public static boolean configLoaded;
    public boolean mcStdRendererNotUseHighPRC = false;
    public boolean debugLog;
    public boolean chatMsg;
    public String debugOption;
    private Property debugLogProp;
    private Property chatMsgProp;
    private Property debugOptionProp;
    public String[] highPrecisionClasses;
    public String[] vanillaPrecisionClasses;
    public String[] unaffectedClasses;
    public boolean setMcRendererToHighPRC;
    public String[] modsNotUsingHighPRC;
    public boolean workaroundKeepOriginalWidthValues;
    public boolean workaroundTransparentScoreboard;
    public boolean workaroundWrongGlState;
    public boolean enablePerPlayerConfig;
    public boolean tweakLoadTexture;
    public boolean tweakRenderExperience;
    public boolean tweakScaledResolution;
    public String[] externalFontsPaths;
    public boolean asyncInit;
    private Property highPrecisionClassesProp;
    private Property vanillaPrecisionClassesProp;
    private Property unaffectedClassesProp;
    private Property setMcRendererToHighPRCProp;
    private Property modsNotUsingHighPRCProp;
    private Property workaroundKeepOriginalWidthValuesProp;
    private Property workaroundTransparentScoreboardProp;
    private Property workaroundWrongGlStateProp;
    private Property enablePerPlayerConfigProp;
    private Property tweakLoadTextureProp;
    private Property tweakRenderExperienceProp;
    private Property tweakScaledResolutionProp;
    private Property externalFontsPathsProp;
    private Property asyncInitProp;
    public boolean useGrayscaleImage;
    public boolean compressImage;
    public int compressImageRequiredCPUs;
    public int maxTempMemForGlyphImgGen;
    private Property useGrayscaleImageProp;
    private Property compressImageProp;
    private Property compressImageRequiredCPUsProp;
    private Property maxTempMemForGlyphImgGenProp;

    public GlobalConfig(File configFile) {
        super(configFile);
    }

    public GlobalConfig() {
    }

    public boolean loadConfigAsm() {
        try {
            File cfgFile = new File("config" + File.separator + "smoothfont" + File.separator + "smoothfont" + ".cfg");
            existingConfigFile = cfgFile.exists();
            this.config = new Configuration(cfgFile, "6");
            this.loadConfig();
            this.preConvertVersion();
            this.readConfig();
            this.convertVersion();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected void initDefaultValues() {
        super.initDefaultValues();
        this.highPrecisionClasses = new String[]{"net.minecraft.client.gui.FontRenderer"};
        this.vanillaPrecisionClasses = new String[0];
        this.unaffectedClasses = new String[]{"malte0811.industrialWires.client.panelmodel.RawModelFontRenderer"};
        this.externalFontsPaths = new String[]{"fontfiles"};
        this.modsNotUsingHighPRC = new String[]{"betterquesting"};
    }

    @Override
    public void readConfig() {
        super.readConfig();
        this.debugLogProp = this.config.get("debug", "debugLog", false, "Enable debug log.");
        this.chatMsgProp = this.config.get("debug", "showLogInChat", false, "Show event log on the game screen.");
        this.debugOptionProp = this.config.get("debug", "debugOption", "", "Debug option");
        this.highPrecisionClassesProp = this.config.get("global", "highPrecisionClasses", this.highPrecisionClasses, "These font renderer classes use high precision font width.\nBest quality, but width calculation compatibility may slightly decreases\nin other font renderer other than the Minecraft default font renderer.");
        this.vanillaPrecisionClassesProp = this.config.get("global", "vanillaPrecisionClasses", this.vanillaPrecisionClasses, "These font renderer classes is most high compatibility with vanilla font width calculation,\nbut the precision of font width calculation is more poorer than the other precision modes.");
        this.unaffectedClassesProp = this.config.get("global", "unaffectedClasses", this.unaffectedClasses, "These font renderer classes are not affected by this mod.");
        this.setMcRendererToHighPRCProp = this.config.get("global", "setMcRendererToHighPrecision", true, "Minecraft standard font renderer object is always set to high precision even if it is replaced.");
        this.modsNotUsingHighPRCProp = this.config.get("global", "modsNotUsingHighPrecision", this.modsNotUsingHighPRC, "High precision mode for MC standard font renderer is not used if these mods(mod ids) exist.\nThis option is useful when there is a text wrapping problem with particular MODs or\nwhen there is an error in computing the text width.\nThis option takes precedence over setMcRendererToHighPrecision option.");
        this.workaroundKeepOriginalWidthValuesProp = this.config.get("global", "workaroundKeepOriginalWidthValues", true, "Workaround for the broken font width of a mod. Some mods have an independent font renderer which\ndirectly refer charWidth/glyphWidth values of a MC standard font renderer in order to get the font\nwidth values of the Minecraft standard fonts or the resource pack fonts. If this workaround is true,\ncharWidth and glyphWidth of the MC standard font renderer keep the font width values of the MC\nstandard fonts or the resource pack fonts even if using the platform fonts.\n(ex. MalisisDoors(MalisisCore) needs this workaround.)");
        this.workaroundTransparentScoreboardProp = this.config.get("global", "workaroundTransparentScoreboard", true, "Workaround for transparent texts on a scoreboard.");
        this.workaroundWrongGlStateProp = this.config.get("global", "workaroundWrongGlState", true, "Workaround for wrong GL state in GlStateManager.\nSome mods directly call GL11 method and don't use GlStateManager properly.\nIf the color of the transparent part changes or the alpha blending is wrong, try this option.");
        this.enablePerPlayerConfigProp = this.config.get("global", "enablePerPlayerConfig", true, "Enable per-player configuration. (Settings in common category)");
        this.externalFontsPathsProp = this.config.get("global", "externalFontsPaths", this.externalFontsPaths, "Paths to font file folder. Default is \"<Minecraft folder>/fontfiles\"");
        this.asyncInitProp = this.config.get("global", "asyncInitialization", true, "(Experimental) Initialize the mod asynchronously. It reduces initialization processing time.");
        this.tweakLoadTextureProp = this.config.get("global", "tweakLoadTexture", true, "Tweak the texture manager in order to make \"Force LERP\" function usable.");
        this.tweakRenderExperienceProp = this.config.get("global", "tweakRenderExperience", true, "Tweak the experience level rendering.");
        this.tweakScaledResolutionProp = this.config.get("global", "tweakScaledResolution", true, "Tweak the scaled resolution in order to make \"Unlock Large GUI\" function usable.");
        this.useGrayscaleImageProp = this.config.get("memory", "useGrayscaleImage", false, "Generate gray-scale glyph images of your platform fonts instead of ABGR images.\nThis reduces memory usage by a quarter.\nsaveMemory:  1(conservative)\nSide effect: There are almost no side effects.\n             When loading texture, it requires a little additional time\n             to convert to ABGR image. After the texture is loaded once,\n             there are no side effect after that.");
        this.compressImageProp = this.config.get("memory", "compressImage", false, "Compress glyph images of your platform fonts.\nThe memory saving effect of this option is very high.(1/10 or less).\nsaveMemory:  1(conservative)\nSide effect: There are almost no side effects.\n             It takes just a little extra time to compress/uncompress glyph images.");
        this.compressImageRequiredCPUsProp = this.config.get("memory", "compressImageRequiredCPUs", 0, "Required number of logical CPUs to use \"compressImage\" function.\nIf number of logical CPUs is below this value, compressing images is canceled\nto avoid taking a long time to generate glyph images.\nWhen 0 is set, there is no limit on the number of CPUs. (Default: 0)");
        this.maxTempMemForGlyphImgGenProp = this.config.get("memory", "maxTempMemForGlyphImgGen", -1, "Max temporary working memory size for generating glyph images. [MB]\nMore larger max temporary memory allows to use more CPU cores for generating glyph images.\nWhen 0 is set, there is no limit on max temporary memory usage.\nWhen -1 is set, a working memory size depends on saveMemory setting. (Default: -1)\nsaveMemory:  0(off):no limit, 1(conservative):32[MB], 2(moderate):16[MB]\nSide effect: Depending on the size of the font, the usage of the multi-core CPU is limited\n             during generation of the glyph images.");
        this.config.setCategoryComment("memory", "The options in this category are related to memory savings.\nBy setting options in this category, you can set the memory saving options\nmore detailed than the \"saveMemory\" option.\nYou can enable each memory saving function regardless of the \"saveMemory\" option setting.\nAlso, even if set to false, memory options equivalent to or less than the saveMemory value are enabled.\nThe saveMemory level of each saving function may be changed with future improvement of functions.");
        this.setValues();
    }

    private void setValues() {
        this.debugLog = this.debugLogProp.getBoolean();
        this.chatMsg = this.chatMsgProp.getBoolean();
        this.debugOption = this.debugOptionProp.getString();
        if (this.debugOption != null && this.debugOption.contains("enableDebug")) {
            debug = true;
        }
        this.highPrecisionClasses = this.highPrecisionClassesProp.getStringList();
        this.vanillaPrecisionClasses = this.vanillaPrecisionClassesProp.getStringList();
        this.unaffectedClasses = this.unaffectedClassesProp.getStringList();
        this.setMcRendererToHighPRC = this.setMcRendererToHighPRCProp.getBoolean();
        this.modsNotUsingHighPRC = this.modsNotUsingHighPRCProp.getStringList();
        this.workaroundKeepOriginalWidthValues = this.workaroundKeepOriginalWidthValuesProp.getBoolean();
        this.workaroundTransparentScoreboard = this.workaroundTransparentScoreboardProp.getBoolean();
        this.workaroundWrongGlState = this.workaroundWrongGlStateProp.getBoolean();
        this.enablePerPlayerConfig = this.enablePerPlayerConfigProp.getBoolean();
        this.tweakLoadTexture = this.tweakLoadTextureProp.getBoolean();
        this.tweakRenderExperience = this.tweakRenderExperienceProp.getBoolean();
        this.tweakScaledResolution = this.tweakScaledResolutionProp.getBoolean();
        this.externalFontsPaths = this.externalFontsPathsProp.getStringList();
        this.asyncInit = this.asyncInitProp.getBoolean();
        this.useGrayscaleImage = this.useGrayscaleImageProp.getBoolean();
        this.compressImage = this.compressImageProp.getBoolean();
        this.compressImageRequiredCPUs = this.compressImageRequiredCPUsProp.getInt();
        this.maxTempMemForGlyphImgGen = this.maxTempMemForGlyphImgGenProp.getInt();
    }

    @Override
    public void saveConfig() {
        this.debugLogProp.setValue(this.debugLog);
        this.chatMsgProp.setValue(this.chatMsg);
        this.debugOptionProp.setValue(this.debugOption);
        this.highPrecisionClassesProp.setValues(this.highPrecisionClasses);
        this.vanillaPrecisionClassesProp.setValues(this.vanillaPrecisionClasses);
        this.unaffectedClassesProp.setValues(this.unaffectedClasses);
        this.setMcRendererToHighPRCProp.setValue(this.setMcRendererToHighPRC);
        this.modsNotUsingHighPRCProp.setValues(this.modsNotUsingHighPRC);
        this.workaroundKeepOriginalWidthValuesProp.setValue(this.workaroundKeepOriginalWidthValues);
        this.workaroundTransparentScoreboardProp.setValue(this.workaroundTransparentScoreboard);
        this.workaroundWrongGlStateProp.setValue(this.workaroundWrongGlState);
        this.enablePerPlayerConfigProp.setValue(this.enablePerPlayerConfig);
        this.tweakLoadTextureProp.setValue(this.tweakLoadTexture);
        this.tweakRenderExperienceProp.setValue(this.tweakRenderExperience);
        this.tweakScaledResolutionProp.setValue(this.tweakScaledResolution);
        this.externalFontsPathsProp.setValues(this.externalFontsPaths);
        this.asyncInitProp.setValue(this.asyncInit);
        this.useGrayscaleImageProp.setValue(this.useGrayscaleImage);
        this.compressImageProp.setValue(this.compressImage);
        this.compressImageRequiredCPUsProp.setValue(this.compressImageRequiredCPUs);
        this.maxTempMemForGlyphImgGenProp.setValue(this.maxTempMemForGlyphImgGen);
        super.saveConfig();
    }

    @Override
    public void resetConfig() {
        super.resetConfig();
    }

    @Override
    protected void preConvertVersion() {
        super.preConvertVersion();
    }

    @Override
    protected void convertVersion() {
        super.convertVersion();
        if (this.getLoadedConfigVersionInt() < Integer.parseInt("6")) {
            this.highPrecisionClasses = ModLib.mergeStringArrays(this.highPrecisionClasses, this.highPrecisionClassesProp.getDefaults());
            this.vanillaPrecisionClasses = ModLib.mergeStringArrays(this.vanillaPrecisionClasses, this.vanillaPrecisionClassesProp.getDefaults());
            this.unaffectedClasses = ModLib.mergeStringArrays(this.unaffectedClasses, this.unaffectedClassesProp.getDefaults());
            this.modsNotUsingHighPRC = ModLib.mergeStringArrays(this.modsNotUsingHighPRC, this.modsNotUsingHighPRCProp.getDefaults());
        }
        if (this.getLoadedConfigVersionInt() <= 2 && this.compressImageRequiredCPUs == 4) {
            this.compressImageRequiredCPUs = 0;
        }
        if (this.getLoadedConfigVersionInt() <= 3 && !this.workaroundKeepOriginalWidthValues) {
            this.workaroundKeepOriginalWidthValues = true;
        }
        this.removeKey("global", "normalPrecisionClasses");
    }

    @Override
    public void takeoverOldConfigValues() {
        super.takeoverOldConfigValues();
        this.debugLog = OldConfig.debugLog;
        this.chatMsg = OldConfig.chatMsg;
        this.vanillaPrecisionClasses = OldConfig.vanillaPrecisionClasses;
        this.unaffectedClasses = OldConfig.unaffectedClasses;
        this.workaroundTransparentScoreboard = OldConfig.workaroundTransparentScoreboard;
        this.workaroundWrongGlState = OldConfig.workaroundWrongGlState;
    }

    public static boolean hasDebugOption(String optStr) {
        if (debug) {
            return GlobalConfig.globalConfig.debugOption.contains(optStr);
        }
        return false;
    }

    static {
        debug = false;
        coreDebug = false;
        multiThread = 2;
        autosizingTgtAscent = 0.85f;
        referenceBaseline = 0.9f;
        configLoaded = false;
    }
}

