/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.asm;

import bre.smoothfont.asm.AsmHelper;
import bre.smoothfont.asm.CorePlugin;
import bre.smoothfont.asm.Transformer;
import bre.smoothfont.config.CommonConfig;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class CustomAdapter {
    static String className;
    static String transformedName;

    public static class GuiIngameForge {

        public static class RenderExperienceAdapter
        extends MethodVisitor {
            static boolean transCond = false;
            static int aload0Num = 0;
            static int popNum = 0;

            public RenderExperienceAdapter(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitIntInsn(int opcode, int var) {
                if (opcode == 16 && var == 31) {
                    transCond = true;
                }
                super.visitIntInsn(opcode, var);
            }

            public void visitVarInsn(int opcode, int var) {
                if (transCond) {
                    if (opcode == 25 && var == 0 && aload0Num < 4) {
                        ++aload0Num;
                    }
                    if (aload0Num == popNum + 1) {
                        return;
                    }
                }
                super.visitVarInsn(opcode, var);
            }

            public void visitInsn(int opcode) {
                if (transCond) {
                    if (opcode == 87 && popNum < 4) {
                        if (++popNum == 4) {
                            transCond = false;
                            super.visitVarInsn(25, 0);
                            super.visitFieldInsn(180, "net/minecraftforge/client/GuiIngameForge", "fontrenderer", "Lnet/minecraft/client/gui/FontRenderer;");
                            super.visitVarInsn(25, 7);
                            super.visitVarInsn(21, 8);
                            super.visitInsn(134);
                            super.visitVarInsn(21, 9);
                            super.visitInsn(134);
                            super.visitMethodInsn(184, "bre/smoothfont/GuiIngameForgeHook", "renderExperienceHook", "(Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;FF)V", false);
                            AsmHelper.logDebug("Modified renderExperience method.");
                            GuiIngameForgeMethods.RENDER_EXPERIENCE.setTransformed();
                        }
                        return;
                    }
                    if (aload0Num == popNum + 1) {
                        return;
                    }
                }
                super.visitInsn(opcode);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (transCond && aload0Num == popNum + 1) {
                    return;
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (transCond && aload0Num == popNum + 1) {
                    return;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    public static class TextureManager {

        public static class LoadTextureAdapter
        extends AdviceAdapter {
            public LoadTextureAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 1);
                super.visitMethodInsn(184, "bre/smoothfont/TextureManagerHook", "loadTextureExitHook", "(Lnet/minecraft/util/ResourceLocation;)V", false);
                AsmHelper.logDebug("Inserted the ExitHook in loadTexture() method.");
                TextureManagerMethods.LOAD_TEXTURE.setTransformed();
            }
        }
    }

    public static class ScaledResolution {

        public static class ConstructorAdapter
        extends MethodVisitor {
            public ConstructorAdapter(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, var);
                if (opcode == 54 && var == 2) {
                    super.visitVarInsn(21, 2);
                    super.visitMethodInsn(184, "bre/smoothfont/ScaledResolutionHook", "modifyFlag", "(Z)Z", false);
                    super.visitVarInsn(54, 2);
                    AsmHelper.logDebug("Inserted the hook in ScaledResolution.<init>.");
                    ScaledResolutionMethods.INIT.setTransformed();
                }
            }
        }
    }

    public static class FontRenderer {

        public static class GetCharWidthFloatAdapter
        extends AdviceAdapter {
            boolean ldcDefaultGlyphChars = false;
            int ldcDefaultGlyphCharsCounter = 0;

            public GetCharWidthFloatAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void visitLdcInsn(Object cst) {
                String str;
                if (cst instanceof String && (str = (String)cst).startsWith("\u00c0\u00c1\u00c2")) {
                    ++this.ldcDefaultGlyphCharsCounter;
                    if (this.ldcDefaultGlyphCharsCounter == 1) {
                        this.ldcDefaultGlyphChars = true;
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        return;
                    }
                }
                super.visitLdcInsn(cst);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.ldcDefaultGlyphChars && opcode == 182 && name.equals("indexOf")) {
                    this.ldcDefaultGlyphChars = false;
                    super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "getCharWidthFloatGetCharIndexHook", "(C)I");
                    AsmHelper.logDebug("Inserted getCharWidthFloatGetCharIndexHook() in getCharWidthFloat().");
                    FontRendererMethods.GET_CHAR_WIDTH_FLOAT.setTransformed();
                    return;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public static class BindTextureAdapter
        extends AdviceAdapter {
            public BindTextureAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "bindTextureEnterHook", "()V", false);
                AsmHelper.logDebug("Inserted the EnterHook in bindTexture method.");
                FontRendererMethods.BIND_TEXTURE.setTransformed();
            }
        }

        public static class SizeStringToWidthAdapter
        extends AdviceAdapter {
            public SizeStringToWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "enableHookSizeStringToWidth", "Z");
                super.visitJumpInsn(153, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(21, 2);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "sizeStringToWidthFloatHook", "(Ljava/lang/String;I)I", false);
                super.visitInsn(172);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in sizeStringToWidth method.");
                FontRendererMethods.SIZE_STRING_TO_WIDTH.setTransformed();
            }
        }

        public static class SetUnicodeFlagAdapter
        extends AdviceAdapter {
            public SetUnicodeFlagAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "setUnicodeFlagHook", "(Z)Z", false);
                super.visitFieldInsn(181, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                AsmHelper.logDebug("Inserted the ExitHook in setUnicodeFlag method.");
                FontRendererMethods.SET_UNICODE_FLAG.setTransformed();
            }
        }

        public static class TrimStringToWidthAdapter
        extends AdviceAdapter {
            public TrimStringToWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "enableHookTrimStringToWidth", "Z");
                super.visitJumpInsn(153, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(21, 2);
                super.visitVarInsn(21, 3);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "trimStringToWidthFloatHook", "(Ljava/lang/String;IZ)Ljava/lang/String;", false);
                super.visitInsn(176);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in trimStringToWidth method.");
                FontRendererMethods.TRIM_STRING_TO_WIDTH.setTransformed();
            }
        }

        public static class GetCharWidthAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;
            private boolean transformed2 = false;
            boolean ldcDefaultGlyphChars = false;
            int ldcDefaultGlyphCharsCounter = 0;

            public GetCharWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "enableHookGetCharWidth", "Z");
                super.visitJumpInsn(153, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "getCharWidthHook", "(C)I", false);
                super.visitInsn(172);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in getCharWidth method.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                if (this.transformed1 && (this.transformed2 || CorePlugin.optifineExist)) {
                    FontRendererMethods.GET_CHAR_WIDTH.setTransformed();
                }
            }

            public void visitLdcInsn(Object cst) {
                String str;
                if (cst instanceof String && (str = (String)cst).startsWith("\u00c0\u00c1\u00c2")) {
                    ++this.ldcDefaultGlyphCharsCounter;
                    if (this.ldcDefaultGlyphCharsCounter == 1) {
                        this.ldcDefaultGlyphChars = true;
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        return;
                    }
                }
                super.visitLdcInsn(cst);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.ldcDefaultGlyphChars && opcode == 182 && name.equals("indexOf")) {
                    this.ldcDefaultGlyphChars = false;
                    super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "getCharWidthGetCharIndexHook", "(C)I");
                    AsmHelper.logDebug("Inserted getCharWidthGetCharIndexHook() in getCharWidth().");
                    this.transformed2 = true;
                    return;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public static class GetStringWidthAdapter
        extends AdviceAdapter {
            public GetStringWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "enableHookGetStringWidth", "Z");
                super.visitJumpInsn(153, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "getStringWidthFloatHook", "(Ljava/lang/String;)I", false);
                super.visitInsn(172);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in getStringWidth method.");
                FontRendererMethods.GET_STRING_WIDTH.setTransformed();
            }
        }

        public static class RenderStringAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;

            public RenderStringAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(21, 4);
                super.visitVarInsn(21, 5);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderStringHook", "(Ljava/lang/String;IZZ)I", false);
                super.visitVarInsn(54, 4);
                AsmHelper.logDebug("Inserted the EnterHook in renderString method.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderStringExitHook", "(Ljava/lang/String;Z)V", false);
                AsmHelper.logDebug("Inserted the ExitHook in renderString method.");
                if (this.transformed1) {
                    FontRendererMethods.RENDER_STRING.setTransformed();
                }
            }
        }

        public static class DoDrawAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;
            boolean targetFound = false;
            boolean skip = false;

            public DoDrawAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "doDrawEnterHook", "()V", false);
                AsmHelper.logDebug("Inserted the EnterHook in doDraw method.");
                this.transformed1 = true;
            }

            public void visitInsn(int opcode) {
                if (opcode == 89) {
                    this.targetFound = true;
                }
                if (this.targetFound && this.skip) {
                    if (opcode == 98) {
                        this.targetFound = false;
                        this.skip = false;
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        super.visitVarInsn(23, 1);
                        super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "doDrawHook", "(F)F", false);
                        super.visitInsn(98);
                        AsmHelper.logDebug("Modified doDraw method.");
                        if (this.transformed1) {
                            FontRendererMethods.DO_DRAW.setTransformed();
                        }
                    }
                    return;
                }
                super.visitInsn(opcode);
            }

            public void visitVarInsn(int opcode, int var) {
                if (this.targetFound && opcode == 23 && var == 1) {
                    this.skip = true;
                    return;
                }
                super.visitVarInsn(opcode, var);
            }
        }

        public static class RenderStringAtPosAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;
            private boolean transformed2 = false;
            private boolean transformed3 = false;
            private boolean transformed4 = false;
            int unicodeFlag = 0;
            boolean flag1 = false;
            int posX = 0;
            boolean ldcDefaultGlyphChars = false;
            int ldcDefaultGlyphCharsCounter = 0;

            public RenderStringAtPosAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitVarInsn(21, 2);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderStringAtPosEnterHook", "(Ljava/lang/String;ZZ)V", false);
                AsmHelper.logDebug("Inserted the EnterHook in renderStringAtPos method.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderStringAtPosExitHook", "(Z)V", false);
                AsmHelper.logDebug("Inserted the ExitHook in renderStringAtPos method.");
                if (this.transformed1 && this.transformed2 && this.transformed3 && this.transformed4) {
                    FontRendererMethods.RENDER_STRING_AT_POS.setTransformed();
                }
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (opcode == 180 && "field_78293_l".equals(AsmHelper.mapFieldName(owner, name, desc))) {
                    super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                    super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "thinFontFlag", "Z");
                    ++this.unicodeFlag;
                    if (this.unicodeFlag == 2) {
                        AsmHelper.logDebug("Replaced unicodeFlag(x2) in renderStringAtPos().");
                        this.transformed3 = true;
                    }
                    return;
                }
                super.visitFieldInsn(opcode, owner, name, desc);
                if (opcode == 180 && "field_78302_t".equals(AsmHelper.mapFieldName(owner, name, desc))) {
                    this.flag1 = true;
                }
                if (this.flag1 && opcode == 181 && "field_78295_j".equals(AsmHelper.mapFieldName(owner, name, desc))) {
                    ++this.posX;
                    if (this.posX == 1) {
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        super.visitInsn(4);
                        super.visitFieldInsn(181, "bre/smoothfont/FontRendererHook", "boldFlag", "Z");
                    }
                    if (this.posX == 3) {
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        super.visitInsn(3);
                        super.visitFieldInsn(181, "bre/smoothfont/FontRendererHook", "boldFlag", "Z");
                        this.flag1 = false;
                        AsmHelper.logDebug("Inserted boldFlag related code in renderStringAtPos().");
                        this.transformed2 = true;
                    }
                }
            }

            public void visitLdcInsn(Object cst) {
                String str;
                if (cst instanceof String && (str = (String)cst).startsWith("\u00c0\u00c1\u00c2")) {
                    ++this.ldcDefaultGlyphCharsCounter;
                    if (this.ldcDefaultGlyphCharsCounter == 1) {
                        this.ldcDefaultGlyphChars = true;
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        return;
                    }
                }
                super.visitLdcInsn(cst);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.ldcDefaultGlyphChars && opcode == 182 && name.equals("indexOf")) {
                    this.ldcDefaultGlyphChars = false;
                    super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderStringAtPosGetCharIndexHook", "(C)I");
                    AsmHelper.logDebug("Inserted renderStringAtPosGetCharIndexHook() in renderStringAtPos().");
                    this.transformed4 = true;
                    return;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public static class RenderUnicodeCharAdapter
        extends AdviceAdapter {
            public RenderUnicodeCharAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitVarInsn(21, 2);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78287_e", "[B");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78295_j", "F");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78296_k", "F");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderUnicodeCharHook", "(CZ[BFF)F", false);
                super.visitInsn(174);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in renderUnicodeChar() method.");
                FontRendererMethods.RENDER_UNICODE_CHAR.setTransformed();
            }
        }

        public static class RenderDefaultCharAdapter
        extends AdviceAdapter {
            public RenderDefaultCharAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitVarInsn(21, 2);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78295_j", "F");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78296_k", "F");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderDefaultCharHook", "(IZFF)F", false);
                super.visitInsn(174);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in renderDefaultChar method.");
                FontRendererMethods.RENDER_DEFAULT_CHAR.setTransformed();
            }
        }

        public static class RenderCharAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;
            private boolean transformed2 = false;
            boolean ldcDefaultGlyphChars = false;
            int ldcDefaultGlyphCharsCounter = 0;

            public RenderCharAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                Label L1 = new Label();
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "enableHookRenderChar", "Z");
                super.visitJumpInsn(153, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitFieldInsn(180, "bre/smoothfont/FontRendererHook", "disableFeatures", "Z");
                super.visitJumpInsn(154, L1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitVarInsn(21, 2);
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderCharHook", "(CZ)F", false);
                super.visitVarInsn(56, 3);
                super.visitVarInsn(23, 3);
                super.visitInsn(11);
                super.visitInsn(149);
                super.visitJumpInsn(155, L1);
                super.visitVarInsn(23, 3);
                super.visitInsn(174);
                super.visitLabel(L1);
                AsmHelper.logDebug("Inserted the EnterHook in renderChar() method.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                if (this.transformed1 && this.transformed2) {
                    FontRendererMethods.RENDER_CHAR.setTransformed();
                }
            }

            public void visitLdcInsn(Object cst) {
                String str;
                if (cst instanceof String && (str = (String)cst).startsWith("\u00c0\u00c1\u00c2")) {
                    ++this.ldcDefaultGlyphCharsCounter;
                    if (this.ldcDefaultGlyphCharsCounter == 1) {
                        this.ldcDefaultGlyphChars = true;
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                        return;
                    }
                }
                super.visitLdcInsn(cst);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.ldcDefaultGlyphChars && opcode == 182 && name.equals("indexOf")) {
                    this.ldcDefaultGlyphChars = false;
                    super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "renderCharGetCharIndexHook", "(C)I");
                    AsmHelper.logDebug("Inserted renderCharGetCharIndexHook() in renderChar().");
                    this.transformed2 = true;
                    return;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public static class ReadGlyphSizesAdapter
        extends AdviceAdapter {
            public ReadGlyphSizesAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "readGlyphSizesExitHook", "()V", false);
                AsmHelper.logDebug("Inserted the ExitHook in readGlyphSizes method.");
                FontRendererMethods.READ_GLYPH_SIZES.setTransformed();
            }
        }

        public static class ReadFontTextureAdapter
        extends AdviceAdapter {
            public ReadFontTextureAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "readFontTextureExitHook", "()V", false);
                AsmHelper.logDebug("Inserted the ExitHook in readFontTexture method.");
                FontRendererMethods.READ_FONT_TEXTURE.setTransformed();
            }
        }

        public static class ConstructorAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;

            public ConstructorAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitTypeInsn(187, "bre/smoothfont/FontRendererHook");
                super.visitInsn(89);
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(183, "bre/smoothfont/FontRendererHook", "<init>", "(Lnet/minecraft/client/gui/FontRenderer;)V", false);
                super.visitFieldInsn(181, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                AsmHelper.logDebug("Inserted the EnterHook in constructor.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/smoothfont/FontRendererHook;");
                super.visitMethodInsn(182, "bre/smoothfont/FontRendererHook", "fontRendererExitHook", "()V", false);
                AsmHelper.logDebug("Inserted the ExitHook in constructor.");
                if (this.transformed1) {
                    FontRendererMethods.INIT.setTransformed();
                }
            }
        }
    }

    public static class ClassAdapter
    extends ClassVisitor {
        public ClassAdapter(ClassVisitor cv) {
            super(262144, cv);
        }

        public ClassAdapter(ClassVisitor cv, String className, String transformedName) {
            this(cv);
            CustomAdapter.className = className;
            CustomAdapter.transformedName = transformedName;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (CorePlugin.optifineExist && transformedName.equals(Transformer.TargetClass.FONT_RENDERER.getClassName()) && "field_78286_d".equals(AsmHelper.mapFieldName(Transformer.TargetClass.FONT_RENDERER.getClassName(), name, desc))) {
                AsmHelper.logInfo("OptiFine (int)charWidth[] was found.");
                CorePlugin.optifineNoCharWidthInt = false;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String targetClassName;
            if (transformedName.equals(Transformer.TargetClass.FONT_RENDERER.getClassName())) {
                targetClassName = Transformer.TargetClass.FONT_RENDERER.getClassName();
                if ("<init>".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.ConstructorAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_111272_d".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.ReadFontTextureAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_98306_d".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.ReadGlyphSizesAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_181559_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.RenderCharAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78266_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.RenderDefaultCharAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78277_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.RenderUnicodeCharAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78255_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.RenderStringAtPosAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("doDraw".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.DoDrawAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_180455_b".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.RenderStringAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78256_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.GetStringWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78263_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.GetCharWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78262_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.TrimStringToWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78264_a".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.SetUnicodeFlagAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78259_e".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.SizeStringToWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("bindTexture".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.BindTextureAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("getCharWidthFloat".equals(AsmHelper.mapMethodName(targetClassName, name, desc))) {
                    return new FontRenderer.GetCharWidthFloatAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
            }
            if (CommonConfig.globalConfig.tweakScaledResolution && transformedName.equals(Transformer.TargetClass.SCALED_RESOLUTION.getClassName()) && "<init>".equals(AsmHelper.mapMethodName(targetClassName = Transformer.TargetClass.SCALED_RESOLUTION.getClassName(), name, desc))) {
                return new ScaledResolution.ConstructorAdapter(super.visitMethod(access, name, desc, signature, exceptions));
            }
            if (CommonConfig.globalConfig.tweakLoadTexture && transformedName.equals(Transformer.TargetClass.TEXTURE_MANAGER.getClassName()) && "func_110579_a".equals(AsmHelper.mapMethodName(targetClassName = Transformer.TargetClass.TEXTURE_MANAGER.getClassName(), name, desc))) {
                return new TextureManager.LoadTextureAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
            }
            if (CommonConfig.globalConfig.tweakRenderExperience && transformedName.equals(Transformer.TargetClass.GUI_INGAME_FORGE.getClassName()) && "renderExperience".equals(AsmHelper.mapMethodName(targetClassName = Transformer.TargetClass.GUI_INGAME_FORGE.getClassName(), name, desc))) {
                return new GuiIngameForge.RenderExperienceAdapter(super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            if (transformedName.equals(Transformer.TargetClass.GL_STATE_MANAGER.getClassName())) {
                MethodVisitor mv1 = super.visitMethod(9, "getBlendState", "()Z", null, null);
                mv1.visitFieldInsn(178, "net/minecraft/client/renderer/GlStateManager", "field_179157_e", "Lnet/minecraft/client/renderer/GlStateManager$BlendState;");
                mv1.visitFieldInsn(180, "net/minecraft/client/renderer/GlStateManager$BlendState", "field_179213_a", "Lnet/minecraft/client/renderer/GlStateManager$BooleanState;");
                mv1.visitFieldInsn(180, "net/minecraft/client/renderer/GlStateManager$BooleanState", "field_179201_b", "Z");
                mv1.visitInsn(172);
                mv1.visitEnd();
                AsmHelper.logDebug("Added getBlendState() to GlStateManager class.");
                GlStateManagerMethods.GET_BLEND_STATE.setTransformed();
                MethodVisitor mv2 = super.visitMethod(9, "getBlendSrcFactor", "()I", null, null);
                mv2.visitFieldInsn(178, "net/minecraft/client/renderer/GlStateManager", "field_179157_e", "Lnet/minecraft/client/renderer/GlStateManager$BlendState;");
                mv2.visitFieldInsn(180, "net/minecraft/client/renderer/GlStateManager$BlendState", "field_179211_b", "I");
                mv2.visitInsn(172);
                mv2.visitEnd();
                AsmHelper.logDebug("Added getBlendSrcFactor() to GlStateManager class.");
                GlStateManagerMethods.GET_BLEND_SRC_FACTOR.setTransformed();
                MethodVisitor mv3 = super.visitMethod(9, "getBlendDstFactor", "()I", null, null);
                mv3.visitFieldInsn(178, "net/minecraft/client/renderer/GlStateManager", "field_179157_e", "Lnet/minecraft/client/renderer/GlStateManager$BlendState;");
                mv3.visitFieldInsn(180, "net/minecraft/client/renderer/GlStateManager$BlendState", "field_179212_c", "I");
                mv3.visitInsn(172);
                mv3.visitEnd();
                AsmHelper.logDebug("Added getBlendDstFactor() to GlStateManager class.");
                GlStateManagerMethods.GET_BLEND_DST_FACTOR.setTransformed();
            }
            super.visitEnd();
            if (transformedName.equals(Transformer.TargetClass.FONT_RENDERER.getClassName())) {
                boolean transformedAll = true;
                for (Enum enum_ : FontRendererMethods.values()) {
                    if (!CorePlugin.optifineExist && enum_.name().equals("GET_CHAR_WIDTH_FLOAT")) continue;
                    AsmHelper.logInfo(enum_.name() + ":" + ((FontRendererMethods)enum_).getTransformed());
                    transformedAll &= ((FontRendererMethods)enum_).getTransformed();
                }
                if (transformedAll) {
                    AsmHelper.logInfo("** FontRenderer was transformed successfully.");
                } else {
                    Transformer.transformingErrorId |= 1;
                }
                assert (transformedAll) : "FontRenderer was not completely transformed.";
            }
            if (transformedName.equals(Transformer.TargetClass.SCALED_RESOLUTION.getClassName())) {
                if (CommonConfig.globalConfig.tweakScaledResolution) {
                    boolean transformedAll = true;
                    for (Enum enum_ : ScaledResolutionMethods.values()) {
                        AsmHelper.logInfo(enum_.name() + ":" + ((ScaledResolutionMethods)enum_).getTransformed());
                        transformedAll &= ((ScaledResolutionMethods)enum_).getTransformed();
                    }
                    if (transformedAll) {
                        AsmHelper.logInfo("** ScaledResolution was transformed successfully.");
                    } else {
                        Transformer.transformingErrorId |= 2;
                    }
                    assert (transformedAll) : "ScaledResolution was not completely transformed.";
                } else {
                    AsmHelper.logInfo("** ScaledResolution transforming is disabled in config.");
                }
            }
            if (transformedName.equals(Transformer.TargetClass.TEXTURE_MANAGER.getClassName())) {
                if (CommonConfig.globalConfig.tweakLoadTexture) {
                    boolean transformedAll = true;
                    for (Enum enum_ : TextureManagerMethods.values()) {
                        AsmHelper.logInfo(enum_.name() + ":" + ((TextureManagerMethods)enum_).getTransformed());
                        transformedAll &= ((TextureManagerMethods)enum_).getTransformed();
                    }
                    if (transformedAll) {
                        AsmHelper.logInfo("** TextureManager was transformed successfully.");
                    } else {
                        Transformer.transformingErrorId |= 4;
                    }
                    assert (transformedAll) : "TextureManager was not completely transformed.";
                } else {
                    AsmHelper.logInfo("** TextureManager transforming is disabled in config.");
                }
            }
            if (transformedName.equals(Transformer.TargetClass.GUI_INGAME_FORGE.getClassName())) {
                if (CommonConfig.globalConfig.tweakRenderExperience) {
                    boolean transformedAll = true;
                    for (Enum enum_ : GuiIngameForgeMethods.values()) {
                        AsmHelper.logInfo(enum_.name() + ":" + ((GuiIngameForgeMethods)enum_).getTransformed());
                        transformedAll &= ((GuiIngameForgeMethods)enum_).getTransformed();
                    }
                    if (transformedAll) {
                        AsmHelper.logInfo("** GuiIngameForge was transformed successfully.");
                    } else {
                        Transformer.transformingErrorId |= 8;
                    }
                    assert (transformedAll) : "GuiIngameForge was not completely transformed.";
                } else {
                    AsmHelper.logInfo("** GuiIngameForge transforming is disabled in config.");
                }
            }
            if (transformedName.equals(Transformer.TargetClass.GL_STATE_MANAGER.getClassName())) {
                boolean transformedAll = true;
                for (Enum enum_ : GlStateManagerMethods.values()) {
                    AsmHelper.logInfo(enum_.name() + ":" + ((GlStateManagerMethods)enum_).getTransformed());
                    transformedAll &= ((GlStateManagerMethods)enum_).getTransformed();
                }
                if (transformedAll) {
                    AsmHelper.logInfo("** GlStateManager was transformed successfully.");
                } else {
                    Transformer.transformingErrorId |= 0x10;
                }
                assert (transformedAll) : "GlStateManager was not completely transformed.";
            }
        }
    }

    private static enum GlStateManagerMethods {
        GET_BLEND_STATE,
        GET_BLEND_SRC_FACTOR,
        GET_BLEND_DST_FACTOR;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum GuiIngameForgeMethods {
        RENDER_EXPERIENCE;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum TextureManagerMethods {
        LOAD_TEXTURE;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum ScaledResolutionMethods {
        INIT;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum FontRendererMethods {
        INIT,
        READ_FONT_TEXTURE,
        READ_GLYPH_SIZES,
        RENDER_CHAR,
        RENDER_DEFAULT_CHAR,
        RENDER_UNICODE_CHAR,
        RENDER_STRING_AT_POS,
        DO_DRAW,
        RENDER_STRING,
        GET_STRING_WIDTH,
        GET_CHAR_WIDTH,
        TRIM_STRING_TO_WIDTH,
        SET_UNICODE_FLAG,
        SIZE_STRING_TO_WIDTH,
        BIND_TEXTURE,
        GET_CHAR_WIDTH_FLOAT;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }
}

