/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.handler.Timer;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class FontShader {
    private static FontShader INSTANCE = new FontShader();
    private int shaderProg;
    private int shaderProgWithLight;
    private boolean lightmap;
    private int prevShaderProg;
    private boolean shaderEnabled = false;
    private boolean shaderParamDefaultStatus = false;
    private boolean shaderParamUnicodeStatus = false;
    private float rgbDefault;
    private float rgbUnicode;
    private float alphaDefault;
    private float alphaUnicode;
    private boolean shaderSupported = false;
    private boolean setupDone = false;
    private int uniformLocTex;
    private int uniformLocTexWithLight1;
    private int uniformLocTexWithLight2;
    private int uniformLocColorWithLight;
    private int uniformLocColor;
    private Timer extShaderCheckTimer = new Timer(0){

        @Override
        public void timeoutProc() {
            Logger.info("No shader detected for " + this.period + " sec. Can use alpha texture.");
            FontTextureManager.getInstance().clearMapTextureObjects();
            FontRendererHook.extShaderWorking = false;
        }
    };

    private FontShader() {
    }

    public static FontShader getInstance() {
        return INSTANCE;
    }

    public boolean isSupported() {
        return this.shaderSupported;
    }

    public boolean setupShader() {
        if (this.setupDone) {
            return true;
        }
        this.setupDone = true;
        this.shaderSupported = GLUtils.shaderSupported;
        if (!this.shaderSupported) {
            return true;
        }
        String vShaderSrc = "#version 110\nvoid main(void){  gl_Position = ftransform();  gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;  gl_FrontColor = gl_Color;}";
        String fShaderSrc = "#version 110\nuniform sampler2D texture;uniform vec4 colorBias;void main(void){  vec4 color = texture2DProj(texture, gl_TexCoord[0]);  color.r = clamp(color.r + colorBias.r , 0.0, 1.0);  color.g = clamp(color.g + colorBias.g , 0.0, 1.0);  color.b = clamp(color.b + colorBias.b , 0.0, 1.0);  color.a = clamp(color.a * colorBias.a , 0.0, 1.0);  gl_FragColor = color * gl_Color;}";
        String vShaderSrc2 = "#version 110\nvoid main(void){  gl_Position = ftransform();  gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;  gl_TexCoord[1] = gl_TextureMatrix[1] * gl_MultiTexCoord1;  gl_FrontColor = gl_Color;}";
        String fShaderSrc2 = "#version 110\nuniform sampler2D texture;uniform sampler2D texture2;uniform vec4 colorBias;void main(void){  vec4 color = texture2DProj(texture, gl_TexCoord[0]);  vec4 color2 = texture2DProj(texture2, gl_TexCoord[1]);  color.r = clamp(color.r + colorBias.r , 0.0, 1.0);  color.g = clamp(color.g + colorBias.g , 0.0, 1.0);  color.b = clamp(color.b + colorBias.b , 0.0, 1.0);  color.a = clamp(color.a * colorBias.a , 0.0, 1.0);  gl_FragColor = color * color2 * gl_Color;}";
        this.shaderProg = this.getShaderProg(vShaderSrc, fShaderSrc);
        this.shaderProgWithLight = this.getShaderProg(vShaderSrc2, fShaderSrc2);
        this.uniformLocTex = GL20.glGetUniformLocation((int)this.shaderProg, (CharSequence)"texture");
        this.uniformLocTexWithLight1 = GL20.glGetUniformLocation((int)this.shaderProgWithLight, (CharSequence)"texture");
        this.uniformLocTexWithLight2 = GL20.glGetUniformLocation((int)this.shaderProgWithLight, (CharSequence)"texture2");
        this.uniformLocColor = GL20.glGetUniformLocation((int)this.shaderProg, (CharSequence)"colorBias");
        this.uniformLocColorWithLight = GL20.glGetUniformLocation((int)this.shaderProgWithLight, (CharSequence)"colorBias");
        return true;
    }

    private int getShaderProg(String vShaderSrc, String fShaderSrc) {
        int shader = GL20.glCreateProgram();
        int vShaderId = GL20.glCreateShader((int)35633);
        int fShaderId = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)vShaderId, (CharSequence)vShaderSrc);
        GL20.glShaderSource((int)fShaderId, (CharSequence)fShaderSrc);
        GL20.glCompileShader((int)vShaderId);
        String verr = GL20.glGetShaderInfoLog((int)vShaderId, (int)512);
        if (!verr.equals("")) {
            Logger.error("Vertex shader compile error: " + verr);
        }
        GL20.glCompileShader((int)fShaderId);
        String ferr = GL20.glGetShaderInfoLog((int)fShaderId, (int)512);
        if (!verr.equals("")) {
            Logger.error("Fragment shader compile error: " + ferr);
        }
        GL20.glAttachShader((int)shader, (int)fShaderId);
        GL20.glLinkProgram((int)shader);
        return shader;
    }

    private void setColorBias(boolean lightmap, float r, float g, float b, float a) {
        if (lightmap) {
            GL20.glUniform4f((int)this.uniformLocColorWithLight, (float)r, (float)g, (float)b, (float)a);
        } else {
            GL20.glUniform4f((int)this.uniformLocColor, (float)r, (float)g, (float)b, (float)a);
        }
    }

    private void useProgram(boolean lightmap) {
        if (lightmap) {
            this.useProgram(this.shaderProgWithLight);
            GL20.glUniform1i((int)this.uniformLocTexWithLight1, (int)(OpenGlHelper.field_77478_a - 33984));
            GL20.glUniform1i((int)this.uniformLocTexWithLight2, (int)(OpenGlHelper.field_77476_b - 33984));
        } else {
            this.useProgram(this.shaderProg);
            GL20.glUniform1i((int)this.uniformLocTex, (int)(OpenGlHelper.field_77478_a - 33984));
        }
    }

    public void useProgram(int prog) {
        if (!this.shaderSupported) {
            return;
        }
        while (GL11.glGetError() != 0) {
        }
        GL20.glUseProgram((int)prog);
        int errno = GL11.glGetError();
        if (errno != 0) {
            Logger.error("glUseProgram Error: " + errno);
        }
    }

    private void disuseProgram() {
        if (!this.shaderSupported) {
            return;
        }
        GL20.glUseProgram((int)0);
        if (GL11.glGetError() != 0) {
            Logger.error("glUseProgram Error.");
        }
    }

    private int getCurProgram() {
        if (!this.shaderSupported) {
            return 0;
        }
        return GL11.glGetInteger((int)35725);
    }

    private boolean checkLightmapTexUnit() {
        GL13.glActiveTexture((int)OpenGlHelper.field_77476_b);
        boolean ret = GL11.glGetBoolean((int)3553);
        GL13.glActiveTexture((int)OpenGlHelper.field_77478_a);
        return ret;
    }

    public void setShaderParams(FontRendererHook frh, boolean unicodeFlag) {
        if (this.shaderEnabled) {
            if (unicodeFlag) {
                if (!this.shaderParamUnicodeStatus) {
                    this.setColorBias(this.lightmap & !frh.orthographic, this.rgbUnicode, this.rgbUnicode, this.rgbUnicode, this.alphaUnicode);
                    this.shaderParamDefaultStatus = false;
                    this.shaderParamUnicodeStatus = true;
                }
            } else if (!this.shaderParamDefaultStatus) {
                this.setColorBias(this.lightmap & !frh.orthographic, this.rgbDefault, this.rgbDefault, this.rgbDefault, this.alphaDefault);
                this.shaderParamDefaultStatus = true;
                this.shaderParamUnicodeStatus = false;
            }
        }
    }

    public void clearShaderParams(FontRendererHook frh) {
        if (this.shaderEnabled) {
            this.setColorBias(this.lightmap & !frh.orthographic, 0.0f, 0.0f, 0.0f, 1.0f);
            this.shaderParamDefaultStatus = false;
            this.shaderParamUnicodeStatus = false;
        }
    }

    public void restoreShaderTemporarily() {
        if (this.shaderEnabled) {
            this.useProgram(this.prevShaderProg);
        }
    }

    public void resetShader(FontRendererHook frh) {
        if (this.shaderEnabled) {
            this.useProgram(this.lightmap & !frh.orthographic);
        }
    }

    public void prepareShader(FontRendererHook frh, boolean glAlphaTexture) {
        if (!this.shaderSupported) {
            return;
        }
        this.prevShaderProg = this.getCurProgram();
        if (this.prevShaderProg == 0) {
            if (CommonConfig.currentConfig.brightness != 0) {
                float brightnessFactorUnicode;
                float brightnessFactorDefault;
                float boundaryScaleFactorUnicode;
                float boundaryScaleFactorDefault;
                int brightnessUnicode;
                int brightnessDefault;
                this.shaderEnabled = true;
                this.alphaDefault = 1.0f;
                this.alphaUnicode = 1.0f;
                if (glAlphaTexture) {
                    this.rgbDefault = 1.0f;
                    this.rgbUnicode = 1.0f;
                } else {
                    this.rgbDefault = 0.0f;
                    this.rgbUnicode = 0.0f;
                }
                if (CommonConfig.currentConfig.autoBrightness && !frh.changeFont) {
                    brightnessDefault = frh.autoBrightnessDefault;
                    brightnessUnicode = frh.autoBrightnessUnicode;
                    boundaryScaleFactorDefault = frh.brightnessBoundaryScaleFactorDefault;
                    boundaryScaleFactorUnicode = frh.brightnessBoundaryScaleFactorUnicode;
                } else {
                    brightnessDefault = CommonConfig.currentConfig.brightness;
                    brightnessUnicode = CommonConfig.currentConfig.brightness;
                    boundaryScaleFactorUnicode = boundaryScaleFactorDefault = FontRasterizer.getInstance().brightnessBoundaryScaleFactor;
                }
                if (frh.roundedFontScale < 1.5f) {
                    brightnessFactorDefault = 7.0f;
                    brightnessFactorUnicode = 7.0f;
                } else {
                    brightnessFactorDefault = frh.roundedFontScale < boundaryScaleFactorDefault ? 20.0f - 13.0f / (boundaryScaleFactorDefault - 1.5f) * (boundaryScaleFactorDefault - frh.roundedFontScale) : 20.0f;
                    brightnessFactorUnicode = frh.roundedFontScale < boundaryScaleFactorUnicode ? 20.0f - 13.0f / (boundaryScaleFactorUnicode - 1.5f) * (boundaryScaleFactorUnicode - frh.roundedFontScale) : 20.0f;
                }
                this.alphaDefault = 1.0f + (float)brightnessDefault / brightnessFactorDefault;
                this.alphaUnicode = 1.0f + (float)brightnessUnicode / brightnessFactorUnicode;
                if (CommonConfig.currentConfig.enablePremultipliedAlpha) {
                    this.rgbDefault = (this.alphaDefault - 1.0f) / 2.0f;
                    this.rgbUnicode = (this.alphaUnicode - 1.0f) / 2.0f;
                }
            }
        } else {
            if (!FontRendererHook.extShaderWorking) {
                Logger.info("Other shader is detected. Use ABGR texture.");
                FontTextureManager.getInstance().clearMapTextureObjects();
                FontRendererHook.extShaderWorking = true;
                this.extShaderCheckTimer.startTimer();
            }
            this.extShaderCheckTimer.resetTimer();
        }
    }

    public void useShader(FontRendererHook frh) {
        if (this.shaderEnabled) {
            this.lightmap = this.checkLightmapTexUnit();
            this.useProgram(this.lightmap & !frh.orthographic);
            this.setColorBias(this.lightmap & !frh.orthographic, 0.0f, 0.0f, 0.0f, 1.0f);
            this.shaderParamDefaultStatus = false;
            this.shaderParamUnicodeStatus = false;
        }
    }

    public void restoreShader() {
        if (this.shaderEnabled) {
            this.useProgram(this.prevShaderProg);
            this.shaderEnabled = false;
        }
    }
}

