/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.BoldChecker;
import bre.smoothfont.ErrorCorrector;
import bre.smoothfont.FontProperty;
import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontShader;
import bre.smoothfont.FontTexture;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.GlStateManagerHelper;
import bre.smoothfont.GlyphImage;
import bre.smoothfont.RenderCharReplacedChecker;
import bre.smoothfont.asm.CorePlugin;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import bre.smoothfont.util.Reflection;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.SimpleModelFontRenderer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class FontRendererHook {
    private float fontScale;
    public float roundedFontScale;
    public int autoBrightnessDefault;
    public int autoBrightnessUnicode;
    public float brightnessBoundaryScaleFactorDefault;
    public float brightnessBoundaryScaleFactorUnicode;
    private boolean overlayScreen;
    private boolean exclusionCondUnicode;
    private boolean exclusionCondDefault;
    private boolean alignToPixelCond;
    public boolean orthographic;
    public boolean rotation;
    private boolean fractionCoord;
    private boolean ignoreAlpha;
    private boolean needToResetTexEnvAndBlend;
    private boolean onRenderString = false;
    private static Minecraft mc = Minecraft.func_71410_x();
    public FontRenderer fontRenderer;
    public int[] mcCharWidth;
    private boolean immutableSpcWidth = false;
    public boolean disableFeatures = true;
    private boolean removed = false;
    public String reasonForDisable = null;
    public boolean changeFont = false;
    public int precisionMode = 1;
    public boolean keepMcFontWidth = false;
    public boolean optimized = true;
    public boolean boldFlag = false;
    public boolean shadowFlag = false;
    public boolean thinFontFlag = false;
    private boolean mcDefaultFontFlag;
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    private static final ResourceLocation[] osFontUnicodePageLocations = new ResourceLocation[256];
    private static ResourceLocation osFontDefaultPageLocation = new ResourceLocation("smoothfont", "osFontDefaultPage");
    private FontShader fontShader;
    private boolean anisotropicFilterEnabled = false;
    private FontTextureManager fontTextureManager;
    private FontRasterizer rasterizer;
    private float optifineOffsetBold = 1.0f;
    public float[] optifineCharWidthFloat = null;
    private RenderCharReplacedChecker renderCharReplacedChecker = new RenderCharReplacedChecker();
    private boolean renderStringAtPosWorked = false;
    private boolean renderStringAtPosInoperative = false;
    private boolean renderCharWorked = false;
    private static FontRendererHook mcDefaultFontRendererHook = null;
    public static boolean modLoaded = false;
    public static List<FontRendererHook> uninitFontRendererHookList = new ArrayList<FontRendererHook>();
    public static float shadowAdjustVal = 0.0f;
    public static int texFilterSettingId = 0;
    public static int guiScaleFactor = 0;
    public static boolean extShaderWorking = false;
    public boolean enableHookRenderChar = false;
    public boolean enableHookGetStringWidth = false;
    public boolean enableHookGetCharWidth = false;
    public boolean enableHookTrimStringToWidth = false;
    public boolean enableHookSizeStringToWidth = false;
    private ErrorCorrector errCorrector;
    private ErrorCorrector errCorrectorShadow;
    private BoldChecker boldChecker;
    private FloatBuffer floatBuf = BufferUtils.createFloatBuffer((int)16);

    public FontRendererHook(FontRenderer renderer) {
        this.mcCharWidth = new int[256];
        this.fontRenderer = renderer;
        this.fontTextureManager = FontTextureManager.getInstance();
        this.rasterizer = FontRasterizer.getInstance();
        FontRendererHookList.add(this);
        this.fontShader = FontShader.getInstance();
        this.errCorrector = new ErrorCorrector();
        this.errCorrectorShadow = new ErrorCorrector();
        this.boldChecker = new BoldChecker();
    }

    public void fontRendererExitHook() {
        if (GlobalConfig.configLoaded) {
            this.initAfterConfigLoaded(false);
        } else {
            uninitFontRendererHookList.add(this);
        }
        String cls = this.fontRenderer.getClass().getName();
        if ("net.minecraft.client.gui.FontRenderer".equals(cls) && this.fontRenderer.field_111273_g != null && ("textures/font/ascii_sga.png".equals(this.fontRenderer.field_111273_g.func_110623_a()) || "mcpatcher/font/ascii_sga.png".equals(this.fontRenderer.field_111273_g.func_110623_a()))) {
            this.removeFontRendererHook();
        }
    }

    public static void initAfterConfigLoaded() {
        for (FontRendererHook fontRendererHook : uninitFontRendererHookList) {
            fontRendererHook.initAfterConfigLoaded(true);
        }
    }

    public void initAfterConfigLoaded(boolean deferredInit) {
        String cls = this.fontRenderer.getClass().getName();
        if ("net.minecraftforge.fml.client.SplashProgress$SplashFontRenderer".equals(cls)) {
            this.removeFontRendererHook();
        } else if (this.fontRenderer instanceof SimpleModelFontRenderer) {
            this.removeFontRendererHook();
        } else if (CommonConfig.currentConfig.runMode == 0) {
            this.disableFeatures = false;
        }
        for (String c : CommonConfig.globalConfig.unaffectedClasses) {
            if (!cls.equals(c)) continue;
            this.removeFontRendererHook();
        }
        for (String c : CommonConfig.globalConfig.highPrecisionClasses) {
            if (!cls.equals(c)) continue;
            this.precisionMode = 0;
        }
        for (String c : CommonConfig.globalConfig.vanillaPrecisionClasses) {
            if (!cls.equals(c)) continue;
            this.precisionMode = 2;
        }
        if ("net.minecraft.client.gui.FontRenderer".equals(cls)) {
            if (CommonConfig.globalConfig.workaroundKeepOriginalWidthValues) {
                this.keepMcFontWidth = true;
            }
            if (CommonConfig.globalConfig.mcStdRendererNotUseHighPRC && this.precisionMode == 0) {
                this.precisionMode = 1;
            }
        }
        this.updateChangeFontFlag();
        switch (CommonConfig.currentConfig.runMode) {
            case 0: {
                if (CommonConfig.currentConfig.useOSFont && this.rasterizer.glyphsGenerationError) {
                    this.changeFont = false;
                }
                this.optimized = true;
                break;
            }
            case 1: {
                this.optimized = false;
                break;
            }
            case 2: {
                this.optimized = true;
                break;
            }
        }
        if (!this.disableFeatures && this.changeFont) {
            this.rasterizer.restoreGlyphWidth(this);
        }
        this.updateHookFlags();
        shadowAdjustVal = FontUtils.getShadowAdjustVal(CommonConfig.currentConfig.shadowLength);
        texFilterSettingId = FontUtils.getTexFilterSettingId();
        FontRendererHook.setUnicodeFlagSuitably(this);
        if (deferredInit) {
            this.readFontTextureExitHook();
            this.readGlyphSizesExitHook();
        }
    }

    public static void setUnicodeFlagSuitably(FontRendererHook frh) {
        if (frh.disableFeatures) {
            return;
        }
        if (CommonConfig.currentConfig.forceUnicode && mc.func_152349_b()) {
            frh.fontRenderer.field_78293_l = true;
        }
    }

    public static FontRendererHook getMcDefaultFontRendererHook() {
        if (mcDefaultFontRendererHook == null || FontRendererHook.mcDefaultFontRendererHook.fontRenderer != FontRendererHook.mc.field_71466_p) {
            mcDefaultFontRendererHook = FontRendererHookList.getFontRendererHook(FontRendererHook.mc.field_71466_p);
        }
        return mcDefaultFontRendererHook;
    }

    private void setLodBias() {
        if (this.orthographic) {
            if (this.fractionCoord) {
                GlStateManagerHelper.setTexLodBias(CommonConfig.currentConfig.mipmapLodBiasFloat);
            } else {
                GlStateManagerHelper.setTexLodBias(CommonConfig.currentConfig.overlayLodBiasFloat);
            }
        } else {
            GlStateManagerHelper.setTexLodBias(CommonConfig.currentConfig.mipmapLodBiasFloat);
        }
    }

    private void setLodBiasPerformance() {
        GlStateManagerHelper.setTexLodBias(CommonConfig.currentConfig.overlayLodBiasFloat);
    }

    public float renderCharHook(char ch, boolean italic) {
        this.renderCharWorked = true;
        if (ch == ' ' || ch == '\u00a0') {
            return this.getSpaceWidth();
        }
        return -1.0f;
    }

    public int renderCharGetCharIndexHook(char ch) {
        if (!this.optimized) {
            return "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        }
        return FontUtils.getDefaultGlyphIndex(ch);
    }

    public float renderDefaultCharHook(int id, boolean italic, float posX, float posY) {
        float texWidthPx;
        float width;
        this.renderCharReplacedChecker.renderDefaultCharWorked = true;
        ResourceLocation curResLoc = this.changeFont ? osFontDefaultPageLocation : this.fontRenderer.field_111273_g;
        FontTexture texture = this.fontTextureManager.bindTexture(curResLoc);
        char ch = FontUtils.asciiSheetChars[id];
        float factor = texture.actualFontRes / 16.0f;
        if (this.changeFont) {
            this.mcDefaultFontFlag = false;
            if (this.renderStringAtPosInoperative) {
                this.boldFlag = this.boldChecker.isBold(posX, id, this.shadowFlag, false);
                if (this.boldFlag) {
                    posX -= 0.5f;
                }
                if (this.shadowFlag) {
                    posX -= 0.5f;
                    posY -= 0.5f;
                }
            }
            GlyphImage gi = this.rasterizer.getGlyphImage(256);
            switch (this.precisionMode) {
                default: {
                    width = this.rasterizer.charWidthFloat[id];
                    if (!CommonConfig.currentConfig.widthErrorCorrection) break;
                    if (this.shadowFlag) {
                        posX = this.errCorrectorShadow.getCorrectedPosX(posX, posY, width, gi.fontRes, this.boldFlag, false);
                        break;
                    }
                    posX = this.errCorrector.getCorrectedPosX(posX, posY, width, gi.fontRes, this.boldFlag, false);
                    break;
                }
                case 0: {
                    width = this.rasterizer.charWidthFloat[id];
                    break;
                }
                case 2: {
                    width = this.optifineCharWidthFloat != null ? this.rasterizer.charWidthFloat[id] : (float)this.rasterizer.charWidthInt[id];
                }
            }
            if (CommonConfig.currentConfig.fontAlignBaseline) {
                posY += gi.baselineGap + this.rasterizer.sizeAdjPosY;
            } else {
                int fontId = this.rasterizer.fontId[ch];
                FontProperty fontProp = this.rasterizer.fontProp[0][fontId];
                posY += gi.baselineGap + fontProp.ascentGap;
            }
            texWidthPx = gi.drawingChWidth[id] * texture.scaleFactor;
            posX -= gi.fontOriginPosX;
        } else {
            this.mcDefaultFontFlag = true;
            width = this.optifineCharWidthFloat != null ? this.optifineCharWidthFloat[id] : (float)this.mcCharWidth[id];
            texWidthPx = (width - 0.01f) * 2.0f * factor;
        }
        this.resetTexEnvAndBlend();
        if (!CommonConfig.currentConfig.performanceMode) {
            this.fontTextureManager.setAnisotropicFilter(curResLoc, this.anisotropicFilterEnabled);
            if (!this.exclusionCondDefault) {
                this.fontShader.setShaderParams(this, false);
                this.fontTextureManager.setTexParams(curResLoc, texFilterSettingId);
            } else {
                this.fontTextureManager.setTexParamsNearest(curResLoc);
            }
        } else {
            this.fontTextureManager.setTexParams(curResLoc, texFilterSettingId);
        }
        this.renderCharCommon(id, italic, posX, posY, 0.0f, texWidthPx, factor, texture);
        return width;
    }

    public float renderUnicodeCharHook(char ch, boolean italic, byte[] glyphWidth, float posX, float posY) {
        float texWidthPx;
        float left;
        float width;
        this.renderCharReplacedChecker.renderUnicodeCharWorked = true;
        this.mcDefaultFontFlag = false;
        if (!CommonConfig.currentConfig.performanceMode && CommonConfig.currentConfig.disableSmallItalic && this.fontScale < 1.05f) {
            italic = false;
        }
        int page = ch / 256;
        ResourceLocation unicodePageLocation = this.changeFont ? this.getOsFontUnicodePageLocation(page) : this.getUnicodePageLocation(page);
        FontTexture texture = this.fontTextureManager.bindTexture(unicodePageLocation);
        float factor = texture.actualFontRes / 16.0f;
        if (this.changeFont) {
            width = this.rasterizer.glyphWidthFloat8[ch];
            if (width == 0.0f) {
                return 0.0f;
            }
            if (this.renderStringAtPosInoperative) {
                this.boldFlag = this.boldChecker.isBold(posX, ch, this.shadowFlag, true);
            }
            left = 0.0f;
            GlyphImage gi = this.rasterizer.getGlyphImage(page);
            switch (this.precisionMode) {
                default: {
                    if (!CommonConfig.currentConfig.widthErrorCorrection) break;
                    if (this.shadowFlag) {
                        posX = this.errCorrectorShadow.getCorrectedPosX(posX, posY, width, gi.fontRes, this.boldFlag, true);
                        break;
                    }
                    posX = this.errCorrector.getCorrectedPosX(posX, posY, width, gi.fontRes, this.boldFlag, true);
                    break;
                }
                case 0: {
                    break;
                }
                case 2: {
                    float right = (this.rasterizer.glyphWidthByte[ch] & 0xF) + 1;
                    width = (right - left) / 2.0f;
                }
            }
            if (CommonConfig.currentConfig.fontAlignBaseline) {
                posY += gi.baselineGap + this.rasterizer.sizeAdjPosY;
            } else {
                int fontId = this.rasterizer.fontId[ch];
                FontProperty fontProp = this.rasterizer.fontProp[1][fontId];
                posY += gi.baselineGap + fontProp.ascentGap;
            }
            texWidthPx = gi.drawingChWidth[ch % 256] * texture.scaleFactor;
            posX -= gi.fontOriginPosX;
        } else {
            if (glyphWidth[ch] == 0) {
                return 0.0f;
            }
            left = (glyphWidth[ch] & 0xF0) >>> 4;
            float right = (glyphWidth[ch] & 0xF) + 1;
            width = (right - left) / 2.0f + 1.0f;
            texWidthPx = (right - left - 0.02f) * factor;
        }
        float leftPx = left * factor;
        this.resetTexEnvAndBlend();
        if (!CommonConfig.currentConfig.performanceMode) {
            this.fontTextureManager.setAnisotropicFilter(unicodePageLocation, this.anisotropicFilterEnabled);
            if (!this.exclusionCondUnicode) {
                this.fontShader.setShaderParams(this, true);
                this.fontTextureManager.setTexParams(unicodePageLocation, texFilterSettingId);
            } else {
                this.fontTextureManager.setTexParamsNearest(unicodePageLocation);
            }
        } else {
            this.fontTextureManager.setTexParams(unicodePageLocation, texFilterSettingId);
        }
        this.renderCharCommon(ch, italic, posX, posY, leftPx, texWidthPx, factor, texture);
        return width;
    }

    private void renderCharCommon(int ch, boolean italic, float posX, float posY, float leftPx, float texWidthPx, float factor, FontTexture texture) {
        int scaleFactor;
        float it;
        float chImageSize = texture.chImageSizePx;
        float borderWidth = texture.borderWidthPx;
        int texSize = texture.texSizePx;
        float boxSize = chImageSize + borderWidth * 2.0f;
        float texX = (float)(ch % 16) * boxSize + borderWidth + leftPx;
        float texY = (float)((ch & 0xFF) / 16) * boxSize + borderWidth;
        float f = it = italic ? 1.0f : 0.0f;
        if (!CommonConfig.currentConfig.performanceMode) {
            if (this.alignToPixelCond) {
                if (this.shadowFlag && this.fontScale == 1.0f && !this.mcDefaultFontFlag) {
                    posY += 0.5f;
                }
                posY = this.alignToPixel(posY);
            }
            if (this.boldFlag && this.roundedFontScale >= 3.0f) {
                this.renderChar(posX - 0.25f, posY, texX, texY, texWidthPx, it, texSize, chImageSize, borderWidth, factor);
            }
        } else if (this.boldFlag && (scaleFactor = this.getScaleFactor()) >= 3) {
            this.renderChar(posX - 0.25f, posY, texX, texY, texWidthPx, it, texSize, chImageSize, borderWidth, factor);
        }
        this.renderChar(posX, posY, texX, texY, texWidthPx, it, texSize, chImageSize, borderWidth, factor);
        if (GlobalConfig.hasDebugOption("errorCorrection")) {
            GLUtils.restoreColor();
        }
    }

    private void renderChar(float posX, float posY, float texX, float texY, float width, float italic, int texSize, float chImageSize, float borderWidth, float factor) {
        if (this.shadowFlag) {
            posX += shadowAdjustVal;
            posY += shadowAdjustVal;
        }
        borderWidth = 1.0f;
        float posL = posX - borderWidth / (factor *= 2.0f);
        float posR = posX + (width + borderWidth) / factor;
        float posT = posY - borderWidth / factor;
        float posB = posY + (chImageSize + borderWidth) / factor;
        float texL = (texX - borderWidth) / (float)texSize;
        float texR = (texX + width + borderWidth) / (float)texSize;
        float texT = (texY - borderWidth) / (float)texSize;
        float texB = (texY + chImageSize + borderWidth) / (float)texSize;
        GlStateManager.func_187447_r((int)5);
        GlStateManager.func_187426_b((float)texL, (float)texT);
        GlStateManager.func_187435_e((float)(posL + italic), (float)posT, (float)0.0f);
        GlStateManager.func_187426_b((float)texL, (float)texB);
        GlStateManager.func_187435_e((float)(posL - italic), (float)posB, (float)0.0f);
        GlStateManager.func_187426_b((float)texR, (float)texT);
        GlStateManager.func_187435_e((float)(posR + italic), (float)posT, (float)0.0f);
        GlStateManager.func_187426_b((float)texR, (float)texB);
        GlStateManager.func_187435_e((float)(posR - italic), (float)posB, (float)0.0f);
        GlStateManager.func_187437_J();
    }

    public void renderStringAtPosEnterHook(String text, boolean unicodeFlag, boolean shadow) {
        this.renderStringAtPosWorked = true;
        this.thinFontFlag = unicodeFlag;
        if (this.disableFeatures) {
            return;
        }
        if (this.renderCharReplacedChecker.needToCheck() && this.renderCharReplacedChecker.isReplaced(this.fontRenderer, text)) {
            this.disableFeatures("renderChar methods might be replaced.");
            return;
        }
        this.thinFontFlag = unicodeFlag || this.changeFont;
        this.shadowFlag = shadow;
        if (!CommonConfig.currentConfig.performanceMode) {
            Matrix4f mtxMod;
            Matrix4f mtxPrj;
            try {
                this.floatBuf.clear();
                GlStateManager.func_179111_a((int)2983, (FloatBuffer)this.floatBuf);
                this.floatBuf.rewind();
                mtxPrj = new Matrix4f();
                mtxPrj.load(this.floatBuf);
                this.floatBuf.clear();
                GlStateManager.func_179111_a((int)2982, (FloatBuffer)this.floatBuf);
                this.floatBuf.rewind();
                mtxMod = new Matrix4f();
                mtxMod.load(this.floatBuf);
            }
            catch (Exception e) {
                if (CommonConfig.globalConfig.debugLog) {
                    e.printStackTrace();
                }
                this.disableFeatures(e.getMessage());
                return;
            }
            float fontScaleX = ModLib.roundIf(Math.abs((float)FontRendererHook.mc.field_71443_c * mtxPrj.m00 * mtxMod.m00), 1.0E-6f);
            float fontScaleY = ModLib.roundIf(Math.abs((float)FontRendererHook.mc.field_71440_d * mtxPrj.m11 * mtxMod.m11), 1.0E-6f);
            this.fontScale = (fontScaleX + fontScaleY) / 4.0f;
            this.rotation = mtxMod.m01 != 0.0f || mtxMod.m10 != 0.0f;
            if (mtxPrj.m22 == -0.001f && mtxPrj.m32 == -2.0f && mtxMod.m32 == -2000.0f) {
                this.overlayScreen = true;
                this.orthographic = true;
            } else {
                this.overlayScreen = false;
                if (mtxPrj.m33 == 0.0f) {
                    this.orthographic = false;
                    this.fontScale /= Math.abs(mtxMod.m32);
                } else {
                    this.orthographic = true;
                }
            }
            float fontResUnicode = this.fontTextureManager.getUnicodeFontRes(this.changeFont);
            float fontResDefault = this.fontTextureManager.getDefaultFontRes(this.fontRenderer.field_111273_g, this.changeFont);
            if (this.orthographic) {
                this.fractionCoord = false;
                if (mtxMod.m30 * 10.0f % 5.0f != 0.0f || mtxMod.m31 * 10.0f % 5.0f != 0.0f) {
                    this.fractionCoord = true;
                }
            } else {
                this.fractionCoord = true;
            }
            this.roundedFontScale = ModLib.roundIf(this.fontScale, this.fontScale * CommonConfig.currentConfig.fontScaleRoundingToleranceRate);
            this.exclusionCondDefault = !shadow || !(fontResDefault >= (float)CommonConfig.currentConfig.smoothShadowThreshold);
            this.exclusionCondUnicode = !shadow || !(fontResUnicode >= (float)CommonConfig.currentConfig.smoothShadowThreshold);
            this.exclusionCondDefault &= this.orthographic && CommonConfig.currentConfig.excludeIntMultiple && this.roundedFontScale % (fontResDefault / 8.0f) == 0.0f || CommonConfig.currentConfig.excludeHighMag && (double)(this.roundedFontScale * 8.0f) >= (double)fontResDefault * CommonConfig.currentConfig.limitMagnification;
            this.exclusionCondUnicode &= this.orthographic && CommonConfig.currentConfig.excludeIntMultiple && this.roundedFontScale % (fontResUnicode / 8.0f) == 0.0f || CommonConfig.currentConfig.excludeHighMag && (double)(this.roundedFontScale * 8.0f) >= (double)fontResUnicode * CommonConfig.currentConfig.limitMagnification;
            boolean bl = this.alignToPixelCond = this.changeFont && this.orthographic && !this.rotation && this.roundedFontScale * 2.0f == fontResDefault / 8.0f;
            if (!(!CommonConfig.currentConfig.enableInterpolation || this.exclusionCondDefault && this.exclusionCondUnicode)) {
                this.fontShader.prepareShader(this, this.changeFont && this.rasterizer.grayScale);
                this.fontShader.useShader(this);
            }
            if (CommonConfig.currentConfig.enableMipmap) {
                this.setLodBias();
            }
            this.anisotropicFilterEnabled = !this.orthographic && CommonConfig.currentConfig.enableAnisotropicFilter;
        } else if (GlobalConfig.currentConfig.enableMipmap) {
            this.setLodBiasPerformance();
        }
        this.setAlphaBlend(false);
        this.setTexEnv(false);
        this.onRenderString = true;
    }

    public void renderStringAtPosExitHook(boolean unicodeFlag) {
        if (this.disableFeatures) {
            return;
        }
        this.onRenderString = false;
        GlStateManagerHelper.restoreGlTexEnvMode();
        GlStateManagerHelper.restoreBlendFunc(false);
        GlStateManagerHelper.restoreBlendEx(false);
        GlStateManagerHelper.restoreTexLodBias();
        this.fontShader.restoreShader();
        GlStateManager.func_179144_i((int)0);
    }

    public int renderStringAtPosGetCharIndexHook(char ch) {
        if (!this.optimized) {
            return "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        }
        return FontUtils.getDefaultGlyphIndex(ch);
    }

    public ResourceLocation getUnicodePageLocation(int page) {
        if (unicodePageLocations[page] == null) {
            FontRendererHook.unicodePageLocations[page] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
        }
        return unicodePageLocations[page];
    }

    private ResourceLocation getOsFontUnicodePageLocation(int page) {
        if (osFontUnicodePageLocations[page] == null) {
            FontRendererHook.osFontUnicodePageLocations[page] = new ResourceLocation("smoothfont", String.format("osFontUnicodePage_%02x", page));
        }
        return osFontUnicodePageLocations[page];
    }

    public void readFontTextureExitHook() {
        if (CorePlugin.optifineExist) {
            try {
                this.optifineOffsetBold = ((Float)Reflection.getField(this.fontRenderer, "offsetBold")).floatValue();
            }
            catch (Exception e) {
                Logger.error("Cannot get OptiFine offsetBold value. Use default value.");
                e.printStackTrace();
                this.optifineOffsetBold = 1.0f;
            }
            if (CorePlugin.optifineNoCharWidthInt) {
                try {
                    this.optifineCharWidthFloat = (float[])Reflection.getPrivateField(this.fontRenderer, "d");
                    Logger.info("Detected (float)charWidth[] of OptiFine.");
                }
                catch (Exception e) {
                    Logger.error("Failed to refer (float)charWidth[] of OptiFine.");
                    e.printStackTrace();
                    this.optifineCharWidthFloat = null;
                }
                if (this.optifineCharWidthFloat != null) {
                    for (int i = 0; i < this.mcCharWidth.length; ++i) {
                        this.mcCharWidth[i] = ModLib.round(this.optifineCharWidthFloat[i]);
                    }
                }
            } else {
                try {
                    this.optifineCharWidthFloat = (float[])Reflection.getPrivateField(this.fontRenderer, "charWidthFloat");
                    Logger.info("Detected charWidthFloat[] of OptiFine.");
                }
                catch (Exception e) {
                    Logger.error("Failed to refer charWidthFloat[] of OptiFine.");
                    e.printStackTrace();
                    this.optifineCharWidthFloat = null;
                }
            }
        }
        if (!CorePlugin.optifineNoCharWidthInt) {
            this.mcCharWidth = this.fontRenderer.field_78286_d;
        }
        this.rasterizer.saveCharWidthOrig(this.mcCharWidth);
        if (this.disableFeatures) {
            return;
        }
        if (this.changeFont) {
            this.rasterizer.restoreCharWidth(this);
            if (this.optifineCharWidthFloat != null) {
                this.rasterizer.restoreCharWidthFloat(this);
            }
        }
    }

    public void readGlyphSizesExitHook() {
        this.rasterizer.saveGlyphWidthOrig(this.fontRenderer.field_78287_e);
        if (this.disableFeatures) {
            return;
        }
        if (this.changeFont) {
            this.rasterizer.restoreGlyphWidth(this);
        }
        if (!this.disableFeatures) {
            char[] sampleChars = new char[]{'1', '/', 'I'};
            this.autoBrightnessDefault = 0;
            this.autoBrightnessUnicode = 0;
            this.brightnessBoundaryScaleFactorDefault = 0.0f;
            this.brightnessBoundaryScaleFactorUnicode = 0.0f;
            int counterDefault = 0;
            int counterUnicode = 0;
            for (char ch : sampleChars) {
                int opacity;
                BufferedImage bufImg = this.getDefaultCharImage(ch);
                if (bufImg != null && (opacity = FontUtils.getTotalOpacityPosY(bufImg, bufImg.getHeight() / 2)) != 0) {
                    this.autoBrightnessDefault += FontUtils.getEstimatedBrightness(bufImg.getWidth(), opacity);
                    this.brightnessBoundaryScaleFactorDefault += FontUtils.getEstimatedBrightnessBoundaryScaleFactor(bufImg.getWidth(), opacity);
                    ++counterDefault;
                }
                if ((bufImg = this.getUnicodeCharImage(ch)) == null || (opacity = FontUtils.getTotalOpacityPosY(bufImg, bufImg.getHeight() / 2)) == 0) continue;
                this.autoBrightnessUnicode += FontUtils.getEstimatedBrightness(bufImg.getWidth(), opacity);
                this.brightnessBoundaryScaleFactorUnicode += FontUtils.getEstimatedBrightnessBoundaryScaleFactor(bufImg.getWidth(), opacity);
                ++counterUnicode;
            }
            if (counterDefault != 0) {
                this.autoBrightnessDefault /= counterDefault;
                this.brightnessBoundaryScaleFactorDefault /= (float)counterDefault;
            } else {
                this.autoBrightnessDefault = 0;
                this.brightnessBoundaryScaleFactorDefault = 0.0f;
            }
            if (counterUnicode != 0) {
                this.autoBrightnessUnicode /= counterUnicode;
                this.brightnessBoundaryScaleFactorUnicode /= (float)counterUnicode;
            } else {
                this.autoBrightnessUnicode = 0;
                this.brightnessBoundaryScaleFactorUnicode = 0.0f;
            }
            Logger.debug("Auto-brightness for Default font = ", this.autoBrightnessDefault, ", Boundary scaleFactor = ", Float.valueOf(this.brightnessBoundaryScaleFactorDefault));
            Logger.debug("Auto-brightness for Unicode font = ", this.autoBrightnessUnicode, ", Boundary scaleFactor = ", Float.valueOf(this.brightnessBoundaryScaleFactorUnicode));
        }
    }

    public boolean setUnicodeFlagHook(boolean unicodeFlag) {
        if (this.disableFeatures) {
            return unicodeFlag;
        }
        if (CommonConfig.currentConfig.forceUnicode && mc.func_152349_b()) {
            return true;
        }
        return unicodeFlag;
    }

    public float getCharWidthFloatTest(char ch) {
        return this.getCharWidthFloat(ch);
    }

    private float getCharWidthFloat(char character) {
        switch (character) {
            case '\u00a7': {
                return -1.0f;
            }
            case ' ': 
            case '\u00a0': {
                return this.getSpaceWidth();
            }
        }
        int i = FontUtils.getDefaultGlyphIndex(character);
        if (character > '\u0000' && i != -1 && !this.fontRenderer.field_78293_l) {
            if (this.changeFont) {
                switch (this.precisionMode) {
                    default: {
                        return this.rasterizer.charWidthFloat[i];
                    }
                    case 1: {
                        return FontUtils.toNormalWidth(this.rasterizer.charWidthFloat[i]);
                    }
                    case 2: 
                }
                return this.rasterizer.charWidthInt[i];
            }
            if (CorePlugin.optifineExist && this.optifineCharWidthFloat != null) {
                return this.optifineCharWidthFloat[i];
            }
            return this.mcCharWidth[i];
        }
        if (this.fontRenderer.field_78287_e[character] != 0) {
            if (this.changeFont) {
                switch (this.precisionMode) {
                    default: {
                        return this.rasterizer.glyphWidthFloat8[character];
                    }
                    case 1: {
                        return FontUtils.toNormalWidth(this.rasterizer.glyphWidthFloat8[character]);
                    }
                    case 2: 
                }
                int j = this.rasterizer.glyphWidthByte[character] & 0xFF;
                int k = j >>> 4;
                int l = j & 0xF;
                return (++l - k) / 2;
            }
            int j = this.fontRenderer.field_78287_e[character] & 0xFF;
            int k = j >>> 4;
            int l = j & 0xF;
            ++l;
            if (CorePlugin.optifineExist) {
                return (float)(l - k) / 2.0f + 1.0f;
            }
            return (l - k) / 2 + 1;
        }
        return 0.0f;
    }

    public int renderStringHook(String text, int color, boolean dropShadow, boolean unicodeFlag) {
        if (this.disableFeatures) {
            return color;
        }
        int specifiedAlpha = color >>> 24;
        if (specifiedAlpha == 255 || (specifiedAlpha & 0xFC) == 0) {
            this.ignoreAlpha = true;
        } else {
            float curAlphaTestRef;
            int alphaTestBoundary;
            int curAlphaTestFunc;
            boolean blendEnabled;
            this.ignoreAlpha = false;
            try {
                blendEnabled = GL11.glIsEnabled((int)3042);
            }
            catch (Exception e) {
                if (CommonConfig.globalConfig.debugLog) {
                    e.printStackTrace();
                }
                this.disableFeatures(e.getMessage());
                return color;
            }
            if (!blendEnabled && CommonConfig.globalConfig.workaroundTransparentScoreboard && (curAlphaTestFunc = GlStateManager.func_187397_v((int)3009)) == 516 && specifiedAlpha > (alphaTestBoundary = (int)((curAlphaTestRef = GL11.glGetFloat((int)3010)) * 255.0f))) {
                color = 0xFF000000 | color;
                this.ignoreAlpha = true;
            }
        }
        if (this.renderStringAtPosInoperative) {
            this.renderStringAtPosEnterHook(text, unicodeFlag, dropShadow);
        }
        return color;
    }

    public void renderStringExitHook(String text, boolean unicodeFlag) {
        int textLen;
        if (this.renderStringAtPosInoperative) {
            this.renderStringAtPosExitHook(unicodeFlag);
        }
        if (this.disableFeatures) {
            return;
        }
        if (text == null) {
            return;
        }
        if (!this.renderStringAtPosWorked && !this.renderStringAtPosInoperative && (textLen = this.fontRenderer.func_78256_a(text)) > 0) {
            Logger.warn("renderStringAtPos method might be replaced.");
            this.renderStringAtPosInoperative = true;
        }
        if (!this.renderCharWorked && !this.immutableSpcWidth && (textLen = this.fontRenderer.func_78256_a(text)) > 0) {
            Logger.warn("renderChar method might be replaced. Fix the space width to 4 (MC default).");
            this.immutableSpcWidth = true;
        }
    }

    public int getStringWidthFloatHook(String text) {
        if (text == null) {
            return 0;
        }
        float width = 0.0f;
        boolean bold = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            float chWidth = this.changeFont && this.precisionMode == 0 ? this.getCharWidthFloat(ch) : (float)this.fontRenderer.func_78263_a(ch);
            if (chWidth < 0.0f && i < text.length() - 1) {
                ch = text.charAt(++i);
                chWidth = 0.0f;
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        bold = false;
                        break;
                    }
                }
            }
            width += chWidth;
            if (!bold || !(chWidth > 0.0f)) continue;
            if (CorePlugin.optifineExist) {
                int defaultGlyph = FontUtils.getDefaultGlyphIndex(ch);
                width += defaultGlyph == -1 || this.thinFontFlag ? 0.5f : this.optifineOffsetBold;
                continue;
            }
            width += 1.0f;
        }
        return (int)width;
    }

    public int getCharWidthHook(char ch) {
        float chWidth = this.getCharWidthFloat(ch);
        return ModLib.roundAny(chWidth, CommonConfig.currentConfig.charWidthFractionToRoundUpFloat);
    }

    public int getCharWidthGetCharIndexHook(char ch) {
        if (!this.optimized) {
            return "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        }
        return FontUtils.getDefaultGlyphIndex(ch);
    }

    public int getCharWidthFloatGetCharIndexHook(char ch) {
        if (!this.optimized) {
            return "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        }
        return FontUtils.getDefaultGlyphIndex(ch);
    }

    public String trimStringToWidthFloatHook(String text, int width, boolean reverse) {
        StringBuilder stringbuilder = new StringBuilder();
        float totalWidth = 0.0f;
        int length = text.length();
        int start = reverse ? length - 1 : 0;
        int step = reverse ? -1 : 1;
        boolean deco = false;
        boolean bold = false;
        for (int cur = start; cur >= 0 && cur < length && (int)totalWidth < width; cur += step) {
            char ch = text.charAt(cur);
            if (deco) {
                deco = false;
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        bold = false;
                        break;
                    }
                }
            } else if (ch == '\u00a7') {
                deco = true;
            } else {
                totalWidth = this.changeFont && this.precisionMode == 0 ? (totalWidth += this.getCharWidthFloat(ch)) : (totalWidth += (float)this.fontRenderer.func_78263_a(ch));
                if (bold) {
                    int defaultGlyph;
                    totalWidth = CorePlugin.optifineExist ? (totalWidth += (defaultGlyph = FontUtils.getDefaultGlyphIndex(ch)) == -1 || this.thinFontFlag ? 0.5f : this.optifineOffsetBold) : (totalWidth += 1.0f);
                }
            }
            if ((int)totalWidth > width) break;
            if (reverse) {
                stringbuilder.insert(0, ch);
                continue;
            }
            stringbuilder.append(ch);
        }
        return stringbuilder.toString();
    }

    public int sizeStringToWidthFloatHook(String str, int wrapWidth) {
        int pos;
        int len = str.length();
        float width = 0.0f;
        int breakPos = -1;
        boolean bold = false;
        block9: for (pos = 0; pos < len; ++pos) {
            char ch = str.charAt(pos);
            block0 : switch (ch) {
                case '\n': {
                    breakPos = pos;
                    break block9;
                }
                case '\u00a7': {
                    if (pos >= len - 1) break;
                    char decoCode = str.charAt(++pos);
                    switch (decoCode) {
                        case 'L': 
                        case 'l': {
                            bold = true;
                            break block0;
                        }
                        case 'R': 
                        case 'r': {
                            bold = false;
                            break block0;
                        }
                    }
                    if (!this.isFormatColor(decoCode)) break;
                    bold = false;
                    break;
                }
                case ' ': {
                    breakPos = pos;
                }
                default: {
                    width = this.changeFont && this.precisionMode == 0 ? (width += this.getCharWidthFloat(ch)) : (width += (float)this.fontRenderer.func_78263_a(ch));
                    if (!bold) break;
                    if (CorePlugin.optifineExist) {
                        int defaultGlyph = FontUtils.getDefaultGlyphIndex(ch);
                        width += defaultGlyph == -1 || this.thinFontFlag ? 0.5f : this.optifineOffsetBold;
                        break;
                    }
                    width += 1.0f;
                }
            }
            if ((int)width > wrapWidth) break;
        }
        return pos != len && breakPos != -1 && breakPos < pos ? breakPos : pos;
    }

    public void doDrawEnterHook() {
        if (!this.disableFeatures && (this.fontRenderer.field_78299_w || this.fontRenderer.field_78300_v)) {
            this.fontShader.restoreShaderTemporarily();
        }
    }

    public float doDrawHook(float f) {
        if (!this.disableFeatures) {
            if (this.fontRenderer.field_78299_w || this.fontRenderer.field_78300_v) {
                this.fontShader.resetShader(this);
            }
            if (this.changeFont) {
                switch (this.precisionMode) {
                    case 0: {
                        return f;
                    }
                    case 1: {
                        return FontUtils.toNormalWidth(f);
                    }
                    case 2: {
                        return (int)f;
                    }
                }
            }
        }
        if (CorePlugin.optifineExist) {
            return f;
        }
        return (int)f;
    }

    private boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }

    public void bindTextureEnterHook() {
        if (this.disableFeatures || !this.onRenderString) {
            return;
        }
        this.fontShader.restoreShaderTemporarily();
        GlStateManagerHelper.restoreGlTexEnvMode();
        this.needToResetTexEnvAndBlend = true;
    }

    private void resetTexEnvAndBlend() {
        if (!this.needToResetTexEnvAndBlend) {
            return;
        }
        this.setAlphaBlend(true);
        this.setTexEnv(true);
        this.fontShader.resetShader(this);
        this.needToResetTexEnvAndBlend = false;
    }

    private void setAlphaBlend(boolean reset) {
        if (CommonConfig.currentConfig.enableAlphaBlend) {
            GlStateManagerHelper.setBlendEx(reset);
            if (CommonConfig.currentConfig.enablePremultipliedAlpha) {
                GlStateManagerHelper.setBlendFunc(1, 771, reset);
            } else {
                GlStateManagerHelper.setBlendFunc(770, 771, reset);
            }
        }
    }

    private void setTexEnv(boolean reset) {
        if (extShaderWorking) {
            return;
        }
        if (this.changeFont && this.rasterizer.grayScale) {
            if (this.ignoreAlpha) {
                GlStateManagerHelper.setGlTexEnvMode(7681, reset);
            } else {
                GlStateManagerHelper.setGlTexEnvModeCombine(reset);
            }
        }
    }

    public void reloadResources() {
        boolean registered = false;
        for (IResourceManagerReloadListener listener : ((SimpleReloadableResourceManager)FontRendererHook.mc.func_110442_L()).field_110546_b) {
            if (listener != this.fontRenderer) continue;
            registered = true;
        }
        if (registered) {
            this.fontRenderer.func_110549_a(mc.func_110442_L());
            Logger.debug("onResourceManagerReload was executed: ", this.fontRenderer.toString());
        } else {
            try {
                this.fontRenderer.func_111272_d();
            }
            catch (Exception e) {
                Logger.info("Exception from readFontTexture(). The font texture file may not exist.");
            }
            try {
                this.fontRenderer.func_98306_d();
            }
            catch (Exception e) {
                Logger.info("Exception from readGlyphSizes(). The glyph_sizes.bin may not exist.");
            }
            Logger.debug("onResourceManagerReload is not registered: ", this.fontRenderer.toString());
        }
    }

    private void disableFeatures(String reason) {
        Logger.info("Disabled smoothfont functions.(reason:" + reason + "):" + this.fontRenderer.toString());
        this.disableFeatures = true;
        this.reasonForDisable = reason;
        this.reloadResources();
    }

    public static void disableAllFeatures(final boolean optimized) {
        Logger.info("Disabled all smoothfont features.");
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.disableFeatures = true;
                frh.optimized = optimized;
                return true;
            }
        };
        hookList.executeAll();
        FontTextureManager.getInstance().func_110549_a(mc.func_110442_L());
    }

    public static void enableAllFeatures() {
        Logger.info("Enabled all smoothfont features.");
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.disableFeatures = false;
                frh.optimized = true;
                return true;
            }
        };
        hookList.executeAll();
        FontTextureManager.getInstance().func_110549_a(mc.func_110442_L());
    }

    public static void updateRunMode() {
        switch (CommonConfig.currentConfig.runMode) {
            case 0: {
                boolean result;
                FontRendererHook.enableAllFeatures();
                if (!CommonConfig.currentConfig.useOSFont || (result = FontRasterizer.getInstance().initFontCache(false))) break;
                FontRendererHook.disableAllFeatures(true);
                break;
            }
            case 1: {
                FontRendererHook.disableAllFeatures(false);
                break;
            }
            case 2: {
                FontRendererHook.disableAllFeatures(true);
                break;
            }
        }
    }

    private BufferedImage getDefaultCharImage(char ch) {
        int id = FontUtils.getDefaultGlyphIndex(ch);
        if (id == -1) {
            return null;
        }
        BufferedImage fontImg = FontUtils.getMCFontImage(this.fontRenderer.field_111273_g);
        if (fontImg == null) {
            return null;
        }
        int chSize = fontImg.getWidth() / 16;
        int posX = id % 16 * chSize;
        int posY = (id & 0xFF) / 16 * chSize;
        BufferedImage chImg = fontImg.getSubimage(posX, posY, chSize, chSize);
        return chImg;
    }

    private BufferedImage getUnicodeCharImage(char ch) {
        int page = ch / 256;
        BufferedImage fontImg = FontUtils.getMCFontImage(this.getUnicodePageLocation(page));
        if (fontImg == null) {
            return null;
        }
        int chSize = fontImg.getWidth() / 16;
        int posX = ch % 16 * chSize;
        int posY = (ch & 0xFF) / 16 * chSize;
        BufferedImage chImg = fontImg.getSubimage(posX, posY, chSize, chSize);
        return chImg;
    }

    public void updateHookFlags() {
        this.enableHookRenderChar = this.changeFont || !CorePlugin.optifineExist;
        this.enableHookGetStringWidth = this.changeFont || !CorePlugin.optifineExist;
        this.enableHookGetCharWidth = this.changeFont || !CorePlugin.optifineExist;
        this.enableHookTrimStringToWidth = this.changeFont || !CorePlugin.optifineExist;
        this.enableHookSizeStringToWidth = this.changeFont || !CorePlugin.optifineExist;
    }

    public static void updateHookFlagsAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.updateHookFlags();
                return true;
            }
        };
        hookList.executeAll();
    }

    public void updateChangeFontFlag() {
        switch (CommonConfig.currentConfig.fontTargetToReplace) {
            default: {
                if (this.fontRenderer.field_111273_g != null && "minecraft".equals(this.fontRenderer.field_111273_g.func_110624_b()) && ("textures/font/ascii.png".equals(this.fontRenderer.field_111273_g.func_110623_a()) || "mcpatcher/font/ascii.png".equals(this.fontRenderer.field_111273_g.func_110623_a()))) {
                    this.changeFont = CommonConfig.currentConfig.useOSFont;
                    break;
                }
                this.changeFont = false;
                break;
            }
            case 1: {
                this.changeFont = CommonConfig.currentConfig.useOSFont;
            }
        }
    }

    public static void updateChangeFontFlagAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.updateChangeFontFlag();
                return true;
            }
        };
        hookList.executeAll();
    }

    public static void clearChangeFontFlagAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.changeFont = false;
                return true;
            }
        };
        hookList.executeAll();
    }

    private float getSpaceWidth() {
        if (!this.immutableSpcWidth && this.changeFont) {
            if (CommonConfig.currentConfig.fontSpaceWidth == 0) {
                switch (this.precisionMode) {
                    case 0: {
                        if (this.fontRenderer.func_82883_a()) {
                            return this.rasterizer.glyphWidthFloat8[32];
                        }
                        return this.rasterizer.charWidthFloat[32];
                    }
                    case 1: {
                        if (CommonConfig.currentConfig.widthErrorCorrection) {
                            return ErrorCorrector.getCorrectedSpaceWidth(this.fontRenderer.func_82883_a());
                        }
                    }
                    case 2: {
                        if (this.fontRenderer.func_82883_a()) {
                            return MathHelper.func_76123_f((float)this.rasterizer.glyphWidthFloat8[32]);
                        }
                        return MathHelper.func_76123_f((float)this.rasterizer.charWidthFloat[32]);
                    }
                }
            } else {
                return CommonConfig.currentConfig.fontSpaceWidth;
            }
        }
        if (CorePlugin.optifineExist && !this.fontRenderer.field_78293_l) {
            return this.optifineCharWidthFloat != null ? this.optifineCharWidthFloat[32] : 4.0f;
        }
        return 4.0f;
    }

    private void removeFontRendererHook() {
        this.disableFeatures = true;
        FontRendererHookList.remove(this);
        this.removed = true;
    }

    private float alignToPixel(float pos) {
        float scaleFactor = this.fontScale;
        return (float)ModLib.round(pos * scaleFactor) / scaleFactor;
    }

    private int getScaleFactor() {
        if (guiScaleFactor == 0) {
            ScaledResolution resolution = new ScaledResolution(mc);
            return resolution.func_78325_e();
        }
        return guiScaleFactor;
    }
}

