/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.ErrorCorrector;
import bre.smoothfont.FontMeasure;
import bre.smoothfont.FontProperty;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.GlyphImage;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.common.ProgressManager;

public class FontRasterizer {
    private static FontRasterizer INSTANCE = new FontRasterizer();
    private int fontRes;
    private int fontGap;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private int fontDouble;
    public FontProperty[][] fontProp = new FontProperty[2][3];
    public boolean glyphsGenerationError = false;
    public String glyphsGenerationErrorMessage;
    public int[] charWidthInt = new int[256];
    public byte[] glyphWidthByte = new byte[65536];
    private int[] charWidthOrig = null;
    private byte[] glyphWidthOrig = null;
    public float[] charWidthFloat = new float[256];
    public float[] glyphWidthFloat = new float[65536];
    public float[] glyphWidthFloat8 = new float[65536];
    public int[] fontId = new int[65536];
    public float fontGapAdjWidth;
    public float sizeAdjPosY;
    private float maxFontHeight;
    private GlyphImage[] glyphImageCache = new GlyphImage[257];
    private boolean allFontCacheAvailable = false;
    public boolean grayScale = false;
    private boolean compressImage = false;
    public long totalImageSize;
    public int autoBrightnessValue = 3;
    public float brightnessBoundaryScaleFactor = 2.0f;

    public FontRasterizer() {
        try {
            if (CommonConfig.currentConfig.fontResIndex > FontUtils.getMaxFontSizeIndex()) {
                CommonConfig.currentConfig.fontResIndex = FontUtils.getMaxFontSizeIndex();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean initFontCache(boolean async) {
        if (this.glyphsGenerationError) {
            return false;
        }
        boolean result = true;
        if (CommonConfig.currentConfig.useOSFont && !this.allFontCacheAvailable) {
            result = this.setFontSafely(CommonConfig.currentConfig.fontName, CommonConfig.currentConfig.secondaryFontName, CommonConfig.currentConfig.primaryFontStyle, CommonConfig.currentConfig.secondaryFontStyle, FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex), CommonConfig.currentConfig.fontGap, CommonConfig.currentConfig.fontSizeScaleFactor, CommonConfig.currentConfig.fontAntiAlias, CommonConfig.currentConfig.fontEmphasis, CommonConfig.currentConfig.widthFactorDefaultCharset, CommonConfig.currentConfig.widthFactorUnicodeCharset, async);
        }
        return result;
    }

    public boolean setFontSafely(String fontName, String secondaryFontName, int primaryFontStyle, int secondaryFontStyle, int fontRes, int fontGap, double fontSizeAdjustment, int antiAlias, int fontDouble, double widthFactorDefFont, double widthFactorUniFont, boolean async) {
        try {
            this.glyphsGenerationError = false;
            this.glyphsGenerationErrorMessage = "";
            this.setFont(fontName, secondaryFontName, primaryFontStyle, secondaryFontStyle, fontRes, fontGap, fontSizeAdjustment, antiAlias, fontDouble, widthFactorDefFont, widthFactorUniFont, async);
        }
        catch (Throwable throwable) {
            this.glyphsGenerationError = true;
            this.glyphsGenerationErrorMessage = throwable.toString();
            Logger.error("***** Caught the exception during setFont(). Abort changing fonts. *****");
            throwable.printStackTrace();
            this.clearFontCache();
            return false;
        }
        return true;
    }

    public void setFont(String fontName, String secondaryFontName, int primaryFontStyle, int secondaryFontStyle, int fontRes, int fontGap, double fontSizeAdjustment, int antiAlias, int fontDouble, double widthFactorDefFont, double widthFactorUniFont, boolean async) {
        int CPU_NUM;
        this.compressImage = CommonConfig.globalConfig.compressImage | CommonConfig.currentConfig.saveMemory >= 1;
        if (this.compressImage && CommonConfig.globalConfig.compressImageRequiredCPUs >= 1 && CommonConfig.globalConfig.compressImageRequiredCPUs > (CPU_NUM = Runtime.getRuntime().availableProcessors())) {
            this.compressImage = false;
        }
        this.grayScale = CommonConfig.globalConfig.useGrayscaleImage | CommonConfig.currentConfig.saveMemory >= 1;
        if (this.grayScale) {
            CommonConfig.currentConfig.enablePremultipliedAlpha = false;
            CommonConfig.saveCurrentConfig();
        }
        this.antiAlias = antiAlias >= 1;
        this.fractionalMetrics = antiAlias >= 2;
        this.fontDouble = fontDouble;
        this.fontGap = fontGap;
        this.fontRes = fontRes;
        this.fontGapAdjWidth = (float)(-this.fontGap) * (float)this.fontRes / 16.0f;
        this.fontProp[0][0] = new FontProperty(fontName, primaryFontStyle, fontRes, fontSizeAdjustment, this.antiAlias, this.fractionalMetrics, widthFactorDefFont);
        this.fontProp[0][1] = new FontProperty(secondaryFontName, secondaryFontStyle, fontRes, fontSizeAdjustment, this.antiAlias, this.fractionalMetrics, widthFactorDefFont);
        this.fontProp[0][2] = new FontProperty("SansSerif", primaryFontStyle, fontRes, fontSizeAdjustment, this.antiAlias, this.fractionalMetrics, widthFactorDefFont);
        this.fontProp[1][0] = new FontProperty(fontName, primaryFontStyle, fontRes, fontSizeAdjustment, this.antiAlias, this.fractionalMetrics, widthFactorUniFont);
        this.fontProp[1][1] = new FontProperty(secondaryFontName, secondaryFontStyle, fontRes, fontSizeAdjustment, this.antiAlias, this.fractionalMetrics, widthFactorUniFont);
        this.fontProp[1][2] = new FontProperty("SansSerif", primaryFontStyle, fontRes, fontSizeAdjustment, this.antiAlias, this.fractionalMetrics, widthFactorUniFont);
        float mcFontBaseline = this.getMcFontBaseline(fontRes);
        String typicalChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        FontMeasure basicFm = this.fontProp[0][0].font.canDisplayUpTo("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz") == -1 ? new FontMeasure(this.fontProp[0][0].font, this.antiAlias, this.fractionalMetrics, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz") : (this.fontProp[0][1].font.canDisplayUpTo("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz") == -1 ? new FontMeasure(this.fontProp[0][1].font, this.antiAlias, this.fractionalMetrics, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz") : new FontMeasure(this.fontProp[0][2].font, this.antiAlias, this.fractionalMetrics, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"));
        float apparentBaseline = basicFm.getAscentProxy() + basicFm.getLeadingProxy();
        this.sizeAdjPosY = (float)ModLib.round((apparentBaseline - mcFontBaseline * (float)fontRes / 8.0f) / 2.0f) * (8.0f / (float)fontRes);
        for (FontProperty fntProp : this.fontProp[0]) {
            this.maxFontHeight = Math.max(this.maxFontHeight, fntProp.fm.getHeightProxy());
        }
        this.fontProp[0][0].ascentGap = this.fontProp[0][0].baseline * (8.0f / (float)fontRes) - mcFontBaseline;
        this.fontProp[0][1].ascentGap = this.fontProp[0][1].baseline * (8.0f / (float)fontRes) - mcFontBaseline;
        this.fontProp[0][2].ascentGap = this.fontProp[0][2].baseline * (8.0f / (float)fontRes) - mcFontBaseline;
        this.fontProp[1][0].ascentGap = this.fontProp[0][0].ascentGap;
        this.fontProp[1][1].ascentGap = this.fontProp[0][1].ascentGap;
        this.fontProp[1][2].ascentGap = this.fontProp[0][2].ascentGap;
        this.autoBrightnessValue = 255;
        this.brightnessBoundaryScaleFactor = 2.0f;
        this.clearFontCache();
        if (!async || FontRendererHook.modLoaded) {
            FontTextureManager.getInstance().clearMapTextureObjects();
        }
        this.createFontCacheAll(async);
        if (this.autoBrightnessValue == 255) {
            CommonConfig.currentConfig.brightness = this.autoBrightnessValue = 0;
            Logger.warn("Failed to detect auto-brightness value. Use the default value.");
        }
        Logger.debug("Auto-brightness for system font = ", this.autoBrightnessValue, ", Boundary scaleFactor = ", Float.valueOf(this.brightnessBoundaryScaleFactor));
        ErrorCorrector.calcErrorAverage(fontRes);
    }

    public void clearFontCache() {
        for (int i = 0; i < 257; ++i) {
            this.glyphImageCache[i] = null;
        }
        this.totalImageSize = 0L;
        this.allFontCacheAvailable = false;
    }

    public void createFontCacheAll(boolean async) {
        int i;
        this.clearFontCache();
        ModLib.startCounter("All images generation time");
        ProgressManager.ProgressBar bar = null;
        if (!async) {
            bar = ProgressManager.push((String)"Generating Glyph Images", (int)257, (boolean)true);
        }
        switch (GlobalConfig.multiThread) {
            case 0: {
                for (i = 0; i < 257; ++i) {
                    if (bar != null) {
                        bar.step("Page-" + i);
                    }
                    this.generateGlyphImage(i);
                }
                break;
            }
            case 1: {
                int i2;
                CreateFontImageThread[] thread = new CreateFontImageThread[257];
                for (i2 = 0; i2 < 256; ++i2) {
                    thread[i2] = new CreateFontImageThread(i2, null);
                    thread[i2].start();
                }
                for (i2 = 0; i2 < 256; ++i2) {
                    try {
                        thread[i2].join();
                        if (bar == null) continue;
                        bar.step("Page-" + i2);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (bar != null) {
                    bar.step("Page-256");
                }
                this.generateGlyphImage(256);
                break;
            }
            default: {
                int workingThreadNum = this.getSuitableThreadNum();
                Logger.info("Number of threads used for generating font images: " + workingThreadNum);
                ExecutorService threadPool = Executors.newFixedThreadPool(workingThreadNum);
                for (int i3 = 0; i3 < 256; ++i3) {
                    threadPool.submit(new CreateFontImageThread(i3, bar));
                }
                threadPool.shutdown();
                try {
                    threadPool.awaitTermination(10L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (bar != null) {
                    bar.step("Page-256");
                }
                this.generateGlyphImage(256);
            }
        }
        if (bar != null) {
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
        }
        ModLib.stopCounterMs("All images generation time");
        this.totalImageSize = 0L;
        for (i = 0; i < 257; ++i) {
            this.totalImageSize += (long)this.glyphImageCache[i].dataSize;
        }
        if (!this.compressImage) {
            this.totalImageSize += (long)FontUtils.getBytesFromImage(GlyphImage.blankImage).length;
        }
        Logger.info("Total memory used for the current platform font images: " + this.totalImageSize / 1024L / 1024L + "MB");
        this.allFontCacheAvailable = true;
    }

    public static FontRasterizer getInstance() {
        return INSTANCE;
    }

    public GlyphImage generateGlyphImage(int page) {
        int fontSet = page == 256 ? 0 : 1;
        this.glyphImageCache[page] = new GlyphImage(this, this.fontProp[fontSet], page, this.fontRes, this.antiAlias, this.fractionalMetrics, this.fontDouble, this.grayScale, this.compressImage);
        return this.glyphImageCache[page];
    }

    public GlyphImage getGlyphImage(int page) {
        return this.glyphImageCache[page];
    }

    public void saveCharWidthOrig(int[] cw) {
        if (this.charWidthOrig == null) {
            int i;
            int totalCharWidth = 0;
            for (i = 0; i < cw.length; ++i) {
                totalCharWidth += cw[i];
            }
            if (totalCharWidth > 0) {
                this.charWidthOrig = new int[256];
                for (i = 0; i < cw.length; ++i) {
                    this.charWidthOrig[i] = cw[i];
                }
            }
        }
    }

    public void saveGlyphWidthOrig(byte[] gw) {
        if (this.glyphWidthOrig == null) {
            this.glyphWidthOrig = new byte[65536];
            for (int i = 0; i < gw.length; ++i) {
                this.glyphWidthOrig[i] = gw[i];
            }
        }
    }

    public void restoreGlyphWidthAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                if (!frh.disableFeatures && frh.changeFont) {
                    FontRasterizer.this.restoreCharWidth(frh);
                    FontRasterizer.this.restoreGlyphWidth(frh);
                    if (frh.optifineCharWidthFloat != null) {
                        FontRasterizer.this.restoreCharWidthFloat(frh);
                    }
                }
                return true;
            }
        };
        hookList.executeAll();
    }

    public void restoreCharWidth(FontRendererHook frh) {
        int i;
        if (this.charWidthOrig != null) {
            for (i = 0; i < 256; ++i) {
                if (this.charWidthOrig[i] != 0) continue;
                this.charWidthInt[i] = 0;
            }
        }
        if (frh.keepMcFontWidth) {
            return;
        }
        if (this.charWidthInt != null) {
            for (i = 0; i < 256; ++i) {
                frh.mcCharWidth[i] = this.charWidthInt[i];
            }
        }
    }

    public void restoreCharWidthFloat(FontRendererHook frh) {
        int i;
        if (this.charWidthOrig != null) {
            for (i = 0; i < 256; ++i) {
                if (this.charWidthOrig[i] != 0) continue;
                this.charWidthFloat[i] = 0.0f;
            }
        }
        if (frh.keepMcFontWidth) {
            return;
        }
        if (this.charWidthFloat != null) {
            for (i = 0; i < 256; ++i) {
                frh.optifineCharWidthFloat[i] = this.charWidthFloat[i];
            }
        }
    }

    public void restoreGlyphWidth(FontRendererHook frh) {
        int i;
        if (this.glyphWidthOrig != null) {
            for (i = 0; i < 65536; ++i) {
                if (this.glyphWidthOrig[i] != 0) continue;
                this.glyphWidthByte[i] = 0;
            }
        }
        if (frh.keepMcFontWidth) {
            return;
        }
        if (this.glyphWidthByte != null) {
            for (i = 0; i < 65536; ++i) {
                frh.fontRenderer.field_78287_e[i] = this.glyphWidthByte[i];
            }
        }
    }

    private int getWorkingImagesTotalSize() {
        int resolution = (int)((float)this.fontRes * 1.5f);
        int borderWidth = FontUtils.getBorderWidth(resolution, true);
        int imageWidth = (resolution + borderWidth * 2) * 16;
        int imageSize = imageWidth * imageWidth;
        int glyphSize = resolution * resolution;
        int totalSize = imageSize + glyphSize;
        if (!this.grayScale) {
            totalSize *= 4;
        }
        return totalSize;
    }

    private int getSuitableThreadNum() {
        int maxWorkingMem;
        if (CommonConfig.globalConfig.maxTempMemForGlyphImgGen == -1) {
            switch (CommonConfig.currentConfig.saveMemory) {
                case 0: {
                    maxWorkingMem = 0;
                    break;
                }
                case 1: {
                    maxWorkingMem = 0x2000000;
                    break;
                }
                default: {
                    maxWorkingMem = 0x1000000;
                    break;
                }
            }
        } else {
            maxWorkingMem = CommonConfig.globalConfig.maxTempMemForGlyphImgGen * 1024 * 1024;
        }
        int cpuNum = Runtime.getRuntime().availableProcessors();
        int workingImageSize = this.getWorkingImagesTotalSize();
        int threadNum = maxWorkingMem / workingImageSize;
        threadNum = Math.max(1, threadNum);
        if (maxWorkingMem > 0) {
            return Math.min(cpuNum, threadNum);
        }
        return cpuNum;
    }

    public FontMeasure[] getCurrentFps() {
        FontMeasure[] fms = new FontMeasure[]{this.fontProp[0][0].fm, this.fontProp[0][1].fm, this.fontProp[0][2].fm};
        return fms;
    }

    public float getMcFontBaseline(int fontRes) {
        float mcBaseline = GlobalConfig.referenceBaseline * 8.0f;
        float scaleFactor = (float)fontRes / 8.0f;
        mcBaseline = (float)ModLib.round(mcBaseline * scaleFactor) / scaleFactor;
        return mcBaseline;
    }

    private float getOptimizedPosY(float posY, int fontRes) {
        return (float)ModLib.round(posY * (float)(fontRes / 8)) / (float)(fontRes / 8);
    }

    class CreateFontImageThread
    extends Thread {
        int page;
        ProgressManager.ProgressBar progressBar;

        private CreateFontImageThread(int page, ProgressManager.ProgressBar bar) {
            this.page = page;
            this.progressBar = bar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.progressBar != null) {
                ProgressManager.ProgressBar progressBar = this.progressBar;
                synchronized (progressBar) {
                    this.progressBar.step("Page-" + this.page);
                }
            }
            FontRasterizer.this.generateGlyphImage(this.page);
        }
    }
}

