/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class ExternalFontManager {
    private static ExternalFontManager INSTANCE = new ExternalFontManager();
    private HashSet<String> exFontList = new HashSet();

    private ExternalFontManager() {
    }

    public static ExternalFontManager getInstance() {
        return INSTANCE;
    }

    private String[] getExternalFontFilenames(String path) {
        File dir = new File(path);
        String[] files = dir.list();
        return files;
    }

    public void registerExternalFonts() {
        for (String path : CommonConfig.globalConfig.externalFontsPaths) {
            path = ModLib.correctFileSeparator(path);
            Logger.info("Search font files in \"" + path + "\" folder.");
            this.registerExternalFontsInPath(path);
        }
    }

    private void registerExternalFontsInPath(String path) {
        String[] files = this.getExternalFontFilenames(path);
        if (files == null) {
            Logger.warn("Fonts folder \"" + path + "\" does not exist.");
            return;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int num = 0;
        for (String filename : files) {
            boolean tryType1 = false;
            boolean isFontFile = false;
            Font font = null;
            File fontfile = new File(path + File.separator + filename);
            try {
                font = Font.createFont(0, fontfile);
                isFontFile = true;
            }
            catch (FontFormatException e1) {
                tryType1 = true;
            }
            catch (IOException e2) {
                Logger.error("Cannot read font file.");
                e2.printStackTrace();
            }
            if (tryType1) {
                try {
                    font = Font.createFont(1, fontfile);
                    isFontFile = true;
                }
                catch (FontFormatException e1) {
                    isFontFile = false;
                }
                catch (IOException e2) {
                    Logger.error("Cannot read font file.");
                    e2.printStackTrace();
                }
            }
            if (isFontFile) {
                if (this.exFontList.contains(font.getFontName())) continue;
                boolean result = ge.registerFont(font);
                if (result) {
                    ++num;
                    this.exFontList.add(font.getFontName());
                    Logger.debug("  Registered the external font: ", font.getFontName(), tryType1 ? " (Type1)" : " (TrueType)");
                    continue;
                }
                Logger.debug("  Already exists in the system: ", font.getFontName(), tryType1 ? " (Type1)" : " (TrueType)");
                continue;
            }
            Logger.debug("  Skipped ", fontfile.getName(), ". Could not recognize it as a font file.");
        }
        Logger.info("  Found " + num + " new font(s).");
    }
}

