/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.util.ItemNBTUtils;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.items.tools.WyvernBow;
import com.brandon3055.draconicevolution.utils.DETextures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DraconicBow
extends WyvernBow {
    @Override
    public double getBaseAttackSpeedConfig() {
        return 0.0;
    }

    @Override
    public double getBaseAttackDamageConfig() {
        return 1.0;
    }

    @Override
    public void loadEnergyStats() {
        this.setEnergyStats(ToolStats.DRACONIC_BASE_CAPACITY, 8000000, 0);
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        registry.register(stack, new BooleanConfigField("bowFireArrow", false, "config.field.bowFireArrow.description"));
        registry.register(stack, new DoubleConfigField("bowShockPower", 0.0, 0.0, 4.0, "config.field.bowShockPower.description", IItemConfigField.EnumControlType.SLIDER));
        return super.getFields(stack, registry);
    }

    @Override
    public float getMaxZoomModifier(ItemStack stack) {
        return 6.0f;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 1;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return 2;
    }

    @Override
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        byte pull = ItemNBTUtils.getByte((ItemStack)stack, (String)"render:bow_pull");
        return new PairKV((Object)DETextures.DRACONIC_BOW[pull], (Object)new ResourceLocation("draconicevolution", String.format("models/item/tools/draconic_bow0%s.obj", pull)));
    }
}

