/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NullHelper;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleArrays
implements IHandler<Object> {
    @Nullable
    private final Type componentType;
    private final List<IHandler> componentHandlers;

    public HandleArrays() {
        this(Registry.GLOBAL_REGISTRY, null);
    }

    protected HandleArrays(Registry registry, @Nullable Type componentType) {
        this.componentType = componentType;
        List<Object> handlers = NullHelper.notnullJ(Collections.emptyList(), "Collections.emptyList()");
        if (componentType != null) {
            try {
                handlers = registry.findHandlers(componentType);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        this.componentHandlers = handlers;
    }

    @Override
    @Nullable
    public IHandler<?> getHandler(Registry registry, Type type) {
        Class<?> clazz = TypeUtil.toClass(type);
        if (clazz.isArray()) {
            return new HandleArrays(registry, clazz.getComponentType());
        }
        return null;
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, Object object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        int size = Array.getLength(object);
        tag.func_74768_a("size", size);
        for (int i = 0; i < size; ++i) {
            Object elem = Array.get(object, i);
            if (elem == null) continue;
            for (IHandler handler : this.componentHandlers) {
                if (handler.store(registry, phase, tag, type, i + "", elem)) break;
            }
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    @Nullable
    public Object read(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, @Nullable Object object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Type compType = this.componentType;
        if (compType == null) {
            return null;
        }
        if (nbt.func_74764_b(name)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            int size = tag.func_74762_e("size");
            if (object == null) {
                object = Array.newInstance(TypeUtil.toClass(compType), size);
            }
            block0: for (int i = 0; i < size; ++i) {
                if (!tag.func_74764_b(i + "")) continue;
                for (IHandler handler : this.componentHandlers) {
                    Object result = handler.read(registry, phase, tag, compType, i + "", null);
                    if (result == null) continue;
                    Array.set(object, i, result);
                    continue block0;
                }
            }
        }
        return object;
    }
}

