/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer {
    final Book book;
    final GuiBook gui;
    final FontRenderer font;
    final String text;
    final int x;
    final int y;
    final int width;
    final int spaceWidth;
    final int lineHeight;
    final boolean defaultUnicode;
    final int baseColor;
    List<Word> words;

    public BookTextRenderer(GuiBook gui, String text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, String text, int x, int y, int width, int lineHeight, int baseColor) {
        this.book = gui.book;
        this.gui = gui;
        this.font = gui.field_146297_k.field_71466_p;
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.spaceWidth = this.font.func_78256_a(" ");
        this.lineHeight = lineHeight;
        this.defaultUnicode = this.font.func_82883_a();
        this.baseColor = baseColor;
        this.build();
    }

    private void build() {
        BookTextParser parser = new BookTextParser(this.gui, this.book, this.x, this.y, this.width, this.lineHeight, this.baseColor);
        this.words = parser.parse(this.text);
    }

    public void render(int mouseX, int mouseY) {
        this.font.func_78264_a(true);
        this.words.forEach(word -> word.render(mouseX, mouseY));
        this.font.func_78264_a(this.defaultUnicode);
    }

    public void click(int mouseX, int mouseY, int mouseButton) {
        this.words.forEach(word -> word.click(mouseX, mouseY, mouseButton));
    }
}

