/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.ImmutableList;
import elec332.core.api.network.INetworkHandler;
import elec332.core.util.PlayerHelper;
import elec332.core.world.WorldHelper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerHelper {
    public static List<EntityPlayerMP> getOnlinePlayers() {
        return ServerHelper.getMinecraftServer().func_184103_al().func_181057_v();
    }

    public static boolean isPlayerOnline(UUID uuid) {
        return ServerHelper.getOnlinePlayers().stream().anyMatch(player -> PlayerHelper.getPlayerUUID((EntityPlayer)player).equals(uuid));
    }

    @Nullable
    public static EntityPlayerMP getPlayer(UUID uuid) {
        return ServerHelper.getOnlinePlayers().stream().filter(player -> PlayerHelper.getPlayerUUID((EntityPlayer)player).equals(uuid)).findFirst().orElse(null);
    }

    public static List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, BlockPos pos) {
        return ServerHelper.getAllPlayersWatchingBlock(world, pos.func_177958_n(), pos.func_177952_p());
    }

    public static List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, int x, int z) {
        if (world instanceof WorldServer) {
            PlayerChunkMap playerManager = ((WorldServer)world).func_184164_w();
            return ServerHelper.getOnlinePlayers().stream().filter(player -> playerManager.func_72694_a(player, x >> 4, z >> 4)).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    public static void sendMessageToAllPlayersWatchingBlock(World world, BlockPos pos, IMessage message, INetworkHandler networkHandler) {
        ServerHelper.getAllPlayersWatchingBlock(world, pos).forEach(player -> networkHandler.sendTo(message, (EntityPlayerMP)player));
    }

    public static List<EntityPlayerMP> getAllPlayersInDimension(int dimension) {
        return ServerHelper.getOnlinePlayers().stream().filter(player -> WorldHelper.getDimID(player.func_130014_f_()) == dimension).collect(Collectors.toList());
    }

    public static void sendMessageToAllPlayersInDimension(int dimension, IMessage message, INetworkHandler networkHandler) {
        ServerHelper.getAllPlayersInDimension(dimension).forEach(playerMP -> networkHandler.sendTo(message, (EntityPlayerMP)playerMP));
    }

    public static MinecraftServer getMinecraftServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }
}

