/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory;

import elec332.core.api.util.IClearable;
import elec332.core.util.ItemStackHelper;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SafeWrappedIItemHandler
implements IItemHandlerModifiable,
IClearable {
    private IItemHandlerModifiable itemHandler;

    public static SafeWrappedIItemHandler of(IItemHandlerModifiable i) {
        return new SafeWrappedIItemHandler(i);
    }

    private SafeWrappedIItemHandler(IItemHandlerModifiable itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public void clear() {
        this.itemHandler = null;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.itemHandler == null) {
            return;
        }
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.itemHandler == null ? 0 : this.itemHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler == null ? ItemStackHelper.NULL_STACK : this.itemHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.itemHandler == null ? stack : this.itemHandler.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.itemHandler == null ? ItemStackHelper.NULL_STACK : this.itemHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler == null ? 0 : this.itemHandler.getSlotLimit(slot);
    }
}

