/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2.power;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.ExternalPowerHandler;
import reborncore.api.power.ExternalPowerManager;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.compatmod.ic2.power.IC2EnergyDelegate;
import techreborn.compatmod.ic2.power.IC2ItemCharger;
import techreborn.compatmod.ic2.power.TRBackupElectricItemManager;

@RebornRegistry(modOnly="ic2", modID="techreborn")
public class IC2PowerManager
implements ExternalPowerManager {
    @ConfigRegistry(config="ic2", comment="Should ic2 power support be enabled? (Requires restart)")
    public static boolean ic2Power = true;

    public IC2PowerManager() {
        if (ic2Power) {
            ElectricItem.registerBackupManager((IBackupElectricItemManager)new TRBackupElectricItemManager(this));
        }
    }

    public ExternalPowerHandler createPowerHandler(TilePowerAcceptor acceptor) {
        if (!ic2Power) {
            return null;
        }
        return new IC2EnergyDelegate(acceptor);
    }

    public boolean isPoweredTile(TileEntity tileEntity, EnumFacing facing) {
        if (!ic2Power) {
            return false;
        }
        return tileEntity instanceof IEnergyTile || EnergyNet.instance.getTile(tileEntity.func_145831_w(), tileEntity.func_174877_v()) != null;
    }

    public boolean isPoweredItem(ItemStack stack) {
        if (!ic2Power) {
            return false;
        }
        return IC2ItemCharger.isIC2PoweredItem(stack);
    }

    public void dischargeItem(TilePowerAcceptor tilePowerAcceptor, ItemStack stack) {
        if (!ic2Power) {
            return;
        }
        IC2ItemCharger.dischargeIc2Item(tilePowerAcceptor, stack);
    }

    public void chargeItem(TilePowerAcceptor tilePowerAcceptor, ItemStack stack) {
        if (!ic2Power) {
            return;
        }
        IC2ItemCharger.chargeIc2Item(tilePowerAcceptor, stack);
    }

    public void chargeItem(ForgePowerItemManager powerAcceptor, ItemStack stack) {
        if (!ic2Power) {
            return;
        }
        IC2ItemCharger.chargeIc2Item(powerAcceptor, stack);
    }

    public void requestEnergyFromArmor(ForgePowerItemManager powerAcceptor, EntityLivingBase entity) {
        if (!ic2Power) {
            return;
        }
        IC2ItemCharger.requestEnergyFromIc2Armor(powerAcceptor, entity);
    }
}

