/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.blocks;

import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.blocks.GenericCellBakedModel;
import mcjty.rftoolspower.blocks.ModBlocks;
import mcjty.rftoolspower.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.blocks.SideType;
import mcjty.rftoolspower.blocks.Tier;
import mcjty.rftoolspower.blocks.UnlistedPropertySideTier;
import mcjty.rftoolspower.blocks.UnlistedPropertySideType;
import mcjty.rftoolspower.config.Config;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class PowerCellBlock
extends GenericBlock<PowerCellTileEntity, EmptyContainer>
implements INBTPreservingIngredient {
    public static final UnlistedPropertySideType NORTH = new UnlistedPropertySideType("north");
    public static final UnlistedPropertySideType SOUTH = new UnlistedPropertySideType("south");
    public static final UnlistedPropertySideType WEST = new UnlistedPropertySideType("west");
    public static final UnlistedPropertySideType EAST = new UnlistedPropertySideType("east");
    public static final UnlistedPropertySideType UP = new UnlistedPropertySideType("up");
    public static final UnlistedPropertySideType DOWN = new UnlistedPropertySideType("down");
    public static final UnlistedPropertySideTier TIER = new UnlistedPropertySideTier("tier");
    public static PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    public static PropertyBool LOWER = PropertyBool.func_177716_a((String)"lower");

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public PowerCellBlock(String name, Class<? extends PowerCellTileEntity> clazz) {
        super((ModBase)RFToolsPower.instance, Material.field_151573_f, clazz, EmptyContainer::new, name, false);
        this.func_149647_a(RFToolsPower.tabRfToolsPower);
    }

    public int getGuiID() {
        return -1;
    }

    public void initModel() {
        ResourceLocation name = this.getRegistryName();
        McJtyLib.proxy.initCustomItemModel(Item.func_150898_a((Block)this), 0, new ModelResourceLocation(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "item"), "inventory"));
        McJtyLib.proxy.initStateMapper((Block)this, GenericCellBakedModel.modelCell);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag flag) {
        super.func_190948_a(itemStack, player, list, flag);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.BLUE + "Energy: " + TextFormatting.YELLOW + tagCompound.func_74763_f("energy"));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            long totpower = 0L;
            if (itemStack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.cell1Block)) {
                totpower = Config.TIER1_MAXRF;
            } else if (itemStack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.cell2Block)) {
                totpower = Config.TIER2_MAXRF;
            } else if (itemStack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.cell3Block)) {
                totpower = Config.TIER3_MAXRF;
            }
            list.add(TextFormatting.WHITE + "This block can store power (" + totpower + " RF)");
            list.add(TextFormatting.WHITE + "and can be combined with other cells to form a");
            list.add(TextFormatting.WHITE + "big multiblock");
            list.add(TextFormatting.WHITE + "Right click with a wrench to toggle");
            list.add(TextFormatting.WHITE + "input/output mode for a side");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            long rfPerTick = powercell.getRfPerTickReal();
            if (powercell.getNetwork().isValid()) {
                probeInfo.text(TextFormatting.GREEN + "Input/Output: " + rfPerTick + " RF/t");
                PowerCellTileEntity.Mode powermode = powercell.getMode(data.getSideHit());
                if (powermode == PowerCellTileEntity.Mode.MODE_INPUT) {
                    probeInfo.text(TextFormatting.YELLOW + "Side: input");
                } else if (powermode == PowerCellTileEntity.Mode.MODE_OUTPUT) {
                    probeInfo.text(TextFormatting.YELLOW + "Side: output");
                }
            } else {
                probeInfo.text(TextStyleClass.ERROR + "Too many blocks in network (max " + Config.NETWORK_MAX + ")!");
            }
            int networkId = powercell.getNetwork().getNetworkId();
            if (mode == ProbeMode.DEBUG) {
                probeInfo.text(TextStyleClass.LABEL + "Network ID: " + TextStyleClass.INFO + networkId);
            }
            if (mode == ProbeMode.EXTENDED) {
                probeInfo.text(TextStyleClass.LABEL + "Local Energy: " + TextStyleClass.INFO + powercell.getLocalEnergy());
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            long energy = stack.func_77942_o() ? stack.func_77978_p().func_74763_f("energy") : 0L;
            powercell.setLocalEnergy(energy);
            powercell.getNetwork();
            powercell.markDirtyQuick();
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess access, BlockPos pos, IBlockState metadata, int fortune) {
        super.getDrops(drops, access, pos, metadata, fortune);
        TileEntity te = access.func_175625_s(pos);
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            powercell.redistributeNetwork();
            long energy = powercell.getLocalEnergy();
            if (!drops.isEmpty()) {
                NBTTagCompound tagCompound = ((ItemStack)drops.get(0)).func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    ((ItemStack)drops.get(0)).func_77982_d(tagCompound);
                }
                tagCompound.func_74772_a("energy", energy);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        PowerCellTileEntity powercell;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity && (powercell = (PowerCellTileEntity)te).getNetwork() != null) {
            powercell.dismantleNetwork(powercell.getNetwork());
        }
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K) {
            IBlockState stateDown;
            IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
            if (stateUp.func_177230_c() == ModBlocks.cell1Block) {
                world.func_184138_a(pos.func_177984_a(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.func_180495_p(pos.func_177977_b())).func_177230_c() == ModBlocks.cell1Block) {
                world.func_184138_a(pos.func_177977_b(), stateDown, stateDown, 3);
            }
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            powerCellTileEntity.toggleMode(side);
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177984_a()).func_177230_c() == this)).func_177226_a((IProperty)LOWER, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_177230_c() == this));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{UPPER, LOWER};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN, TIER};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getStateInternal(state, world, pos);
    }

    public IBlockState getStateInternal(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        boolean upper = Boolean.TRUE.equals(state.func_177229_b((IProperty)UPPER));
        boolean lower = Boolean.TRUE.equals(state.func_177229_b((IProperty)LOWER));
        SideType north = this.getSideType(world, pos, EnumFacing.NORTH, upper, lower);
        SideType south = this.getSideType(world, pos, EnumFacing.SOUTH, upper, lower);
        SideType west = this.getSideType(world, pos, EnumFacing.WEST, upper, lower);
        SideType east = this.getSideType(world, pos, EnumFacing.EAST, upper, lower);
        SideType up = this.getSideType(world, pos, EnumFacing.UP, upper, lower);
        SideType down = this.getSideType(world, pos, EnumFacing.DOWN, upper, lower);
        Tier tier = Tier.TIER1;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PowerCellTileEntity) {
            tier = ((PowerCellTileEntity)te).getTier();
        }
        return extendedBlockState.withProperty((IUnlistedProperty)NORTH, (Object)north).withProperty((IUnlistedProperty)SOUTH, (Object)south).withProperty((IUnlistedProperty)WEST, (Object)west).withProperty((IUnlistedProperty)EAST, (Object)east).withProperty((IUnlistedProperty)UP, (Object)up).withProperty((IUnlistedProperty)DOWN, (Object)down).withProperty((IUnlistedProperty)TIER, (Object)tier);
    }

    protected SideType getSideType(IBlockAccess world, BlockPos pos, EnumFacing facing, boolean upper, boolean lower) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity.Mode mode = ((PowerCellTileEntity)te).getMode(facing);
            switch (mode) {
                case MODE_NONE: {
                    if (upper && lower) {
                        return SideType.MIDDLE_NONE;
                    }
                    if (upper) {
                        return SideType.LOWER_NONE;
                    }
                    if (lower) {
                        return SideType.UPPER_NONE;
                    }
                    return SideType.BOTH_NONE;
                }
                case MODE_INPUT: {
                    if (upper && lower) {
                        return SideType.MIDDLE_INPUT;
                    }
                    if (upper) {
                        return SideType.LOWER_INPUT;
                    }
                    if (lower) {
                        return SideType.UPPER_INPUT;
                    }
                    return SideType.BOTH_INPUT;
                }
                case MODE_OUTPUT: {
                    if (upper && lower) {
                        return SideType.MIDDLE_OUTPUT;
                    }
                    if (upper) {
                        return SideType.LOWER_OUTPUT;
                    }
                    if (lower) {
                        return SideType.UPPER_OUTPUT;
                    }
                    return SideType.BOTH_OUTPUT;
                }
            }
            return SideType.BOTH_NONE;
        }
        if (upper && lower) {
            return SideType.MIDDLE_NONE;
        }
        if (upper) {
            return SideType.LOWER_NONE;
        }
        if (lower) {
            return SideType.UPPER_NONE;
        }
        return SideType.BOTH_NONE;
    }
}

