/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.processor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.storage.IStorageScanner;
import mcjty.rftoolscontrol.api.code.Function;
import mcjty.rftoolscontrol.api.code.ICompiledOpcode;
import mcjty.rftoolscontrol.api.code.IOpcodeRunnable;
import mcjty.rftoolscontrol.api.machines.IProcessor;
import mcjty.rftoolscontrol.api.machines.IProgram;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.api.parameters.Tuple;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingStationTileEntity;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankFluidProperties;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankTileEntity;
import mcjty.rftoolscontrol.blocks.node.NodeTileEntity;
import mcjty.rftoolscontrol.blocks.processor.CardInfo;
import mcjty.rftoolscontrol.blocks.processor.Commands;
import mcjty.rftoolscontrol.blocks.processor.GuiProcessor;
import mcjty.rftoolscontrol.blocks.processor.ProcessorContainer;
import mcjty.rftoolscontrol.blocks.processor.QueuedEvent;
import mcjty.rftoolscontrol.blocks.processor.WaitForItem;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOp;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOpText;
import mcjty.rftoolscontrol.blocks.workbench.WorkbenchTileEntity;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.items.CPUCoreItem;
import mcjty.rftoolscontrol.items.GraphicsCardItem;
import mcjty.rftoolscontrol.items.ModItems;
import mcjty.rftoolscontrol.items.NetworkCardItem;
import mcjty.rftoolscontrol.items.NetworkIdentifierItem;
import mcjty.rftoolscontrol.items.RAMChipItem;
import mcjty.rftoolscontrol.items.TokenItem;
import mcjty.rftoolscontrol.items.craftingcard.CraftingCardItem;
import mcjty.rftoolscontrol.logic.InventoryTools;
import mcjty.rftoolscontrol.logic.ParameterTools;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.logic.registry.InventoryUtil;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import mcjty.rftoolscontrol.logic.running.CpuCore;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import mcjty.rftoolscontrol.logic.running.RunningProgram;
import mcjty.rftoolscontrol.network.PacketGetFluids;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessorTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
IProcessor {
    public static final int CARD_SLOTS = 6;
    public static final int ITEM_SLOTS = 24;
    public static final int EXPANSION_SLOTS = 16;
    public static final int MAXVARS = 32;
    public static final int MAXFLUIDVARS = 24;
    public static final String CMD_ALLOCATE = "allocate";
    public static final String CMD_EXECUTE = "execute";
    public static final String CMD_GETLOG = "getLog";
    public static final String CMD_GETDEBUGLOG = "getDebugLog";
    public static final String CMD_SETEXCLUSIVE = "setExclusive";
    public static final String CMD_SETHUDMODE = "setHudMode";
    public static final String CLIENTCMD_GETLOG = "getLog";
    public static final String CLIENTCMD_GETDEBUGLOG = "getDebugLog";
    public static final String CMD_GETVARS = "getVars";
    public static final String CLIENTCMD_GETVARS = "getVars";
    public static final String CMD_GETFLUIDS = "getFluids";
    public static final String CLIENTCMD_GETFLUIDS = "getFluids";
    public static final Key<Integer> PARAM_CARD = new Key("card", Type.INTEGER);
    public static final Key<Integer> PARAM_ITEMS = new Key("items", Type.INTEGER);
    public static final Key<Integer> PARAM_VARS = new Key("vars", Type.INTEGER);
    public static final Key<Integer> PARAM_FLUID = new Key("fluids", Type.INTEGER);
    public static final Key<String> PARAM_CMD = new Key("cmd", Type.STRING);
    public static final Key<Boolean> PARAM_EXCLUSIVE = new Key("exclusive", Type.BOOLEAN);
    public static final Key<Integer> PARAM_HUDMODE = new Key("hudmode", Type.INTEGER);
    private static final BiFunction<ParameterType, Object, ItemStack> CONVERTOR_ITEM = (type, value) -> TypeConverters.convertToItem(type, value);
    private static final BiFunction<ParameterType, Object, FluidStack> CONVERTOR_FLUID = (type, value) -> TypeConverters.convertToFluid(type, value);
    private static final BiFunction<ParameterType, Object, BlockSide> CONVERTOR_SIDE = (type, value) -> TypeConverters.convertToSide(type, value);
    private static final BiFunction<ParameterType, Object, Inventory> CONVERTOR_INVENTORY = (type, value) -> TypeConverters.convertToInventory(type, value);
    private static final BiFunction<ParameterType, Object, Tuple> CONVERTOR_TUPLE = (type, value) -> TypeConverters.convertToTuple(type, value);
    private static final BiFunction<ParameterType, Object, List<Parameter>> CONVERTOR_VECTOR = (type, value) -> TypeConverters.convertToVector(type, value);
    private static final BiFunction<ParameterType, Object, Integer> CONVERTOR_INTEGER = (type, value) -> TypeConverters.convertToInteger(type, value);
    private static final BiFunction<ParameterType, Object, Long> CONVERTOR_LONG = (type, value) -> TypeConverters.convertToLong(type, value);
    private static final BiFunction<ParameterType, Object, String> CONVERTOR_STRING = (type, value) -> TypeConverters.convertToString(type, value);
    private static final BiFunction<ParameterType, Object, Boolean> CONVERTOR_BOOL = (type, value) -> TypeConverters.convertToBool(type, value);
    private static final BiFunction<ParameterType, Object, Number> CONVERTOR_NUMBER = (type, value) -> TypeConverters.convertToNumber(type, value);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ProcessorContainer.factory, 46);
    private List<CpuCore> cpuCores = new ArrayList<CpuCore>();
    public static final int HUD_OFF = 0;
    public static final int HUD_LOG = 1;
    public static final int HUD_DB = 2;
    public static final int HUD_GFX = 3;
    private int showHud = 0;
    private boolean cardsDirty = true;
    private boolean coresDirty = true;
    private int maxVars = -1;
    private int hasNetworkCard = -1;
    private int storageCard = -2;
    private boolean hasGraphicsCard = false;
    private Map<String, GfxOp> gfxOps = new HashMap<String, GfxOp>();
    private List<String> orderedOps = null;
    private List<GfxOp> clientGfxOps = new ArrayList<GfxOp>();
    private boolean exclusive = false;
    private String lastException = null;
    private long lastExceptionTime = 0L;
    private String channel = "";
    private Map<String, BlockPos> networkNodes = new HashMap<String, BlockPos>();
    private Set<BlockPos> craftingStations = new HashSet<BlockPos>();
    private int prevIn = 0;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private int tickCount = 0;
    private Parameter[] variables = new Parameter[32];
    private int fluidSlotsAvailable = -1;
    private CardInfo[] cardInfo = new CardInfo[6];
    private Queue<QueuedEvent> eventQueue = new ArrayDeque<QueuedEvent>();
    private List<WaitForItem> waitingForItems = new ArrayList<WaitForItem>();
    private Queue<String> logMessages = new ArrayDeque<String>();
    public long clientTime = 0L;
    private List<String> clientLog = new ArrayList<String>();
    private List<String> clientDebugLog = new ArrayList<String>();
    private Set<Pair<Integer, Integer>> runningEvents = new HashSet<Pair<Integer, Integer>>();
    private Set<String> locks = new HashSet<String>();
    private static int[] slots = null;

    public ProcessorTileEntity() {
        super((long)GeneralConfiguration.processorMaxenergy, (long)GeneralConfiguration.processorReceivepertick);
        int i;
        for (i = 0; i < this.cardInfo.length; ++i) {
            this.cardInfo[i] = new CardInfo();
        }
        for (i = 0; i < 32; ++i) {
            this.variables[i] = null;
        }
        this.fluidSlotsAvailable = -1;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        this.func_70296_d();
    }

    public Parameter getParameter(int idx) {
        return this.variables[idx];
    }

    public boolean isFluidSlotAvailable(int idx) {
        int sideIndex = idx / 4;
        return (this.getFluidSlotsAvailable() & 1 << sideIndex) != 0;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private BlockPos getAdjacentPosition(@Nonnull BlockSide side) {
        BlockPos p;
        if (side.getNodeName() != null && !side.getNodeName().isEmpty()) {
            p = this.networkNodes.get(side.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof NodeTileEntity)) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        } else {
            p = this.field_174879_c;
        }
        return p;
    }

    @Override
    public int readRedstoneIn(@Nonnull BlockSide side) {
        EnumFacing facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return 0;
        }
        return this.func_145831_w().func_175651_c(p.func_177972_a(facing), facing);
    }

    @Override
    public void setPowerOut(@Nonnull BlockSide side, int level) {
        EnumFacing facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return;
        }
        if (level < 0) {
            level = 0;
        } else if (level > 15) {
            level = 15;
        }
        if (p.equals((Object)this.field_174879_c)) {
            this.powerOut[facing.ordinal()] = level;
            this.func_70296_d();
            this.func_145831_w().func_190524_a(this.field_174879_c.func_177972_a(facing), this.func_145838_q(), this.field_174879_c);
        } else {
            NodeTileEntity te = (NodeTileEntity)this.func_145831_w().func_175625_s(p);
            te.setPowerOut(facing, level);
        }
    }

    public int getPowerOut(EnumFacing side) {
        return this.powerOut[side.ordinal()];
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (slots == null) {
            slots = new int[24];
            for (int i = 0; i < 24; ++i) {
                ProcessorTileEntity.slots[i] = 22 + i;
            }
        }
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index >= 22 && index < 46;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 22 && index < 46;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        Item item = stack.func_77973_b();
        if (this.isExpansionSlot(index)) {
            Item storageCardItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftools", "storage_control_module"));
            return item == ModItems.graphicsCardItem || item == ModItems.networkCardItem || item == ModItems.advancedNetworkCardItem || item == ModItems.cpuCoreB500Item || item == ModItems.cpuCoreS1000Item || item == ModItems.cpuCoreEX2000Item || item == ModItems.ramChipItem || item == storageCardItem;
        }
        if (this.isCardSlot(index)) {
            return item == ModItems.programCardItem;
        }
        return true;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.process();
            this.prevIn = this.powerLevel;
        }
    }

    private void process() {
        ++this.tickCount;
        this.func_70296_d();
        this.updateCores();
        this.compileCards();
        this.processEventQueue();
        try {
            this.handleEvents();
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
        this.run();
    }

    private void processEventQueue() {
        QueuedEvent queuedEvent = this.eventQueue.peek();
        if (queuedEvent != null) {
            CompiledEvent compiledEvent = queuedEvent.getCompiledEvent();
            if (compiledEvent.isSingle() && this.runningEvents.contains(Pair.of((Object)queuedEvent.getCardIndex(), (Object)compiledEvent.getIndex()))) {
                return;
            }
            CpuCore core = this.findAvailableCore(queuedEvent.getCardIndex());
            if (core != null) {
                this.eventQueue.remove();
                RunningProgram program = new RunningProgram(queuedEvent.getCardIndex());
                program.startFromEvent(compiledEvent);
                program.setCraftTicket(queuedEvent.getTicket());
                program.setLastValue(queuedEvent.getParameter());
                core.startProgram(program);
                if (compiledEvent.isSingle()) {
                    this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)queuedEvent.getCardIndex(), (Object)compiledEvent.getIndex()));
                }
            }
        }
    }

    public void getCraftableItems(List<ItemStack> stacks) {
        try {
            for (CardInfo info : this.cardInfo) {
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                    int index = event.getIndex();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                    Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                    if (!stack.func_190926_b() && inv != null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (stack.func_190926_b() && inv == null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (!stack.func_190926_b()) {
                        stacks.add(stack);
                        continue;
                    }
                    IItemHandler handler = this.getItemHandlerAt(inv);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack result;
                        ItemStack s = handler.getStackInSlot(i);
                        if (s.func_190926_b() || s.func_77973_b() != ModItems.craftingCardItem || (result = CraftingCardItem.getResult(s)).func_190926_b()) continue;
                        stacks.add(result);
                    }
                }
            }
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
    }

    public void craftOk(IProgram program, @Nullable Integer slot) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        Integer realSlot = info.getRealSlot(slot);
        ItemStack craftedItem = ItemStack.field_190927_a;
        if (realSlot != null) {
            craftedItem = this.getItemHandler().getStackInSlot(realSlot.intValue());
        }
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftedItem = craftingStation.craftOk(this, ticket, craftedItem);
        }
        if (realSlot != null) {
            this.getInventoryHelper().setStackInSlot(realSlot.intValue(), craftedItem);
        }
    }

    public void craftFail(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftingStation.craftFail(ticket);
        }
    }

    public boolean pushItemsWorkbench(IProgram program, @Nonnull BlockSide workbench, ItemStack item, int slot1, int slot2) {
        if (item.func_190926_b()) {
            item = this.getCraftResult(program);
        }
        if (item.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        TileEntity te = this.getTileEntityAt(workbench);
        if (!(te instanceof WorkbenchTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAWORKBENCH);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(te, EnumFacing.EAST);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        if (!CraftingCardItem.fitsGrid(card)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAGRID);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        IItemHandler gridHandler = this.getItemHandlerAt(te, EnumFacing.UP);
        List<ItemStack> ingredients = CraftingCardItem.getIngredientsGrid(card);
        boolean success = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack stackInWorkbench = gridHandler.getStackInSlot(i);
            ItemStack stackInIngredient = ingredients.get(i);
            if (!stackInWorkbench.func_190926_b() && stackInIngredient.func_190926_b()) {
                success = false;
                continue;
            }
            if (stackInWorkbench.func_190926_b() && !stackInIngredient.func_190926_b()) {
                boolean found = false;
                for (int slot = slot1; slot <= slot2; ++slot) {
                    int realSlot = info.getRealSlot(slot);
                    ItemStack localStack = itemHandler.getStackInSlot(realSlot);
                    if (!stackInIngredient.func_77969_a(localStack)) continue;
                    localStack = itemHandler.extractItem(realSlot, stackInIngredient.func_190916_E(), false);
                    gridHandler.insertItem(i, localStack, false);
                    found = true;
                    break;
                }
                if (found) continue;
                success = false;
                continue;
            }
            if (stackInWorkbench.func_190926_b() || stackInIngredient.func_190926_b()) continue;
            if (!stackInIngredient.func_77969_a(stackInWorkbench)) {
                success = false;
                continue;
            }
            if (stackInIngredient.func_190916_E() <= stackInWorkbench.func_190916_E()) continue;
            success = false;
        }
        return success;
    }

    public int pushItemsMulti(IProgram program, @Nullable Inventory inv, int slot1, int slot2, @Nullable Integer extSlot) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        int e = 0;
        if (extSlot != null) {
            e = extSlot;
        }
        int failed = 0;
        for (int slot = slot1; slot <= slot2; ++slot) {
            int realSlot = info.getRealSlot(slot);
            ItemStack stack = itemHandler.getStackInSlot(realSlot);
            if (!stack.func_190926_b()) {
                ItemStack remaining = InventoryTools.insertItem(handler, scanner, stack, extSlot == null ? null : Integer.valueOf(e));
                if (!remaining.func_190926_b()) {
                    ++failed;
                }
                this.inventoryHelper.setStackInSlot(realSlot, remaining);
            }
            ++e;
        }
        return failed;
    }

    public boolean checkIngredients(IProgram program, @Nonnull Inventory cardInv, ItemStack item, int slot1, int slot2) {
        if (item.func_190926_b()) {
            item = this.getCraftResult(program);
        }
        if (item.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(cardInv);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        int slot = slot1;
        List<ItemStack> ingredients = CraftingCardItem.fitsGrid(card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid(card) : CraftingCardItem.getIngredients(card);
        boolean failed = false;
        for (ItemStack ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            ItemStack localStack = itemHandler.getStackInSlot(realSlot);
            if (!ingredient.func_190926_b()) {
                if (!ingredient.func_77969_a(localStack)) {
                    return false;
                }
                if (ingredient.func_190916_E() != localStack.func_190916_E()) {
                    return false;
                }
            } else if (!localStack.func_190926_b()) {
                return false;
            }
            ++slot;
        }
        return true;
    }

    public int getIngredientsSmart(IProgram program, Inventory inv, @Nonnull Inventory cardInv, ItemStack item, int slot1, int slot2, @Nonnull Inventory destInv) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        if (item.func_190926_b()) {
            item = this.getCraftResult(program);
        }
        if (item.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        IItemHandler destHandler = this.getHandlerForInv(destInv);
        if (destHandler == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(cardInv);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        List<ItemStack> ingredients = CraftingCardItem.fitsGrid(card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid(card) : CraftingCardItem.getIngredients(card);
        boolean strictnbt = CraftingCardItem.isStrictNBT(card);
        List<ItemStack> needed = this.combineIngredients(ingredients);
        int requested = this.checkAvailableItemsAndRequestMissing(destInv, scanner, handler, needed);
        if (requested != 0) {
            return requested;
        }
        IItemHandler itemHandler = this.getItemHandler();
        int slot = slot1;
        for (ItemStack ingredient : ingredients) {
            ItemStack stack;
            int realSlot = info.getRealSlot(slot);
            if (!ingredient.func_190926_b() && !(stack = InventoryTools.extractItem(handler, scanner, ingredient.func_190916_E(), true, false, strictnbt, ingredient, null)).func_190926_b()) {
                itemHandler.insertItem(realSlot, stack, false);
            }
            ++slot;
        }
        return 0;
    }

    private int checkAvailableItemsAndRequestMissing(Inventory destInv, IStorageScanner scanner, IItemHandler handler, List<ItemStack> needed) {
        int requested = 0;
        for (ItemStack ingredient : needed) {
            int cnt;
            if (ingredient.func_190926_b() || (cnt = InventoryTools.countItem(handler, scanner, ingredient, false, ingredient.func_190916_E())) >= ingredient.func_190916_E()) continue;
            ++requested;
            ItemStack requestedItem = ingredient.func_77946_l();
            int amount = ingredient.func_190916_E() - cnt;
            if (amount <= 0) {
                requestedItem.func_190920_e(0);
            } else {
                requestedItem.func_190920_e(amount);
            }
            if (this.isRequested(requestedItem) || this.requestCraft(requestedItem, destInv)) continue;
            return -1;
        }
        return requested;
    }

    private List<ItemStack> combineIngredients(List<ItemStack> ingredients) {
        ArrayList<ItemStack> needed = new ArrayList<ItemStack>();
        for (ItemStack ingredient : ingredients) {
            if (ingredient.func_190926_b()) continue;
            boolean found = false;
            for (ItemStack neededStack : needed) {
                if (!neededStack.func_77969_a(ingredient)) continue;
                neededStack.func_190917_f(ingredient.func_190916_E());
                found = true;
                break;
            }
            if (found) continue;
            needed.add(ingredient.func_77946_l());
        }
        return needed;
    }

    public int getIngredients(IProgram program, Inventory inv, Inventory cardInv, ItemStack item, int slot1, int slot2) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        if (item.func_190926_b()) {
            item = this.getCraftResult(program);
        }
        if (item.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(cardInv);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        int slot = slot1;
        List<ItemStack> ingredients = CraftingCardItem.fitsGrid(card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid(card) : CraftingCardItem.getIngredients(card);
        boolean strictnbt = CraftingCardItem.isStrictNBT(card);
        int failed = 0;
        for (ItemStack ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            if (!ingredient.func_190926_b()) {
                ItemStack stack = InventoryTools.extractItem(handler, scanner, ingredient.func_190916_E(), true, false, strictnbt, ingredient, null);
                if (!stack.func_190926_b()) {
                    ItemStack remainder = itemHandler.insertItem(realSlot, stack, false);
                    if (!remainder.func_190926_b()) {
                        InventoryTools.insertItem(handler, scanner, remainder, null);
                    }
                } else {
                    ++failed;
                }
            }
            ++slot;
        }
        return failed;
    }

    private IItemHandler getItemHandler() {
        return (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public void craftWait(IProgram program, @Nonnull Inventory inv, ItemStack stack) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        if (stack.func_190926_b() && (stack = this.getCraftResult(program)).func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), stack, inv);
        this.waitingForItems.add(waitForItem);
        this.func_70296_d();
    }

    public void craftWaitTimed(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), ItemStack.field_190927_a, null);
        this.waitingForItems.add(waitForItem);
        this.func_70296_d();
    }

    public boolean isRequested(ItemStack stack) {
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.isRequested(stack);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    @Override
    public boolean requestCraft(@Nonnull ItemStack stack, @Nullable Inventory inventory) {
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.request(stack, inventory);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public void setCraftTicket(IProgram program, String ticket) {
        ((RunningProgram)program).setCraftTicket(ticket);
    }

    public ItemStack getItemFromCard(IProgram program) {
        Parameter lastValue = program.getLastValue();
        if (lastValue == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGLASTVALUE);
        }
        ItemStack itemStack = TypeConverters.convertToItem(lastValue);
        if (itemStack.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANITEM);
        }
        if (itemStack.func_77973_b() instanceof CraftingCardItem) {
            return CraftingCardItem.getResult(itemStack);
        }
        if (itemStack.func_77973_b() instanceof TokenItem && itemStack.func_77942_o()) {
            NBTTagCompound tag = itemStack.func_77978_p().func_74775_l("parameter");
            if (tag.func_82582_d()) {
                return ItemStack.field_190927_a;
            }
            Parameter parameter = ParameterTools.readFromNBT(tag);
            if (parameter == null || !parameter.isSet()) {
                return ItemStack.field_190927_a;
            }
            return TypeConverters.convertToItem(parameter);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getCraftResult(IProgram program) {
        if (!program.hasCraftTicket()) {
            return ItemStack.field_190927_a;
        }
        for (BlockPos p : this.craftingStations) {
            CraftingStationTileEntity craftingStation;
            ItemStack stack;
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity) || (stack = (craftingStation = (CraftingStationTileEntity)te).getCraftResult(program.getCraftTicket())).func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack findCraftingCard(IItemHandler handler, ItemStack craftResult) {
        String resultNBT = "";
        if (craftResult.func_77942_o()) {
            resultNBT = craftResult.serializeNBT().toString();
        }
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack result;
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b() || s.func_77973_b() != ModItems.craftingCardItem || (result = CraftingCardItem.getResult(s)).func_190926_b() || !result.func_77969_a(craftResult)) continue;
            if (craftResult.func_77942_o()) {
                if (!resultNBT.equalsIgnoreCase(result.serializeNBT().toString())) continue;
                return s;
            }
            return s;
        }
        return ItemStack.field_190927_a;
    }

    public void fireCraftEvent(String ticket, ItemStack stackToCraft) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                IItemHandler handler;
                ItemStack craftingCard;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                if (!stack.func_190926_b()) {
                    if (!stack.func_77969_a(stackToCraft)) continue;
                    this.runOrQueueEvent(i, event, ticket, null);
                    return;
                }
                if (inv == null || (craftingCard = this.findCraftingCard(handler = this.getItemHandlerAt(inv), stackToCraft)).func_190926_b()) continue;
                this.runOrQueueEvent(i, event, ticket, null);
                return;
            }
        }
    }

    private void handleEvents() {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard);
            this.handleEventsRedstoneOff(i, compiledCard);
            this.handleEventsTimer(i, compiledCard);
            this.handleEventsCraftResume(i, compiledCard);
        }
    }

    private void handleEventsCraftResume(int cardIndex, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFTRESUME)) {
            int index = event.getIndex();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0 || this.waitingForItems.isEmpty()) continue;
            WaitForItem found = null;
            int foundIdx = -1;
            for (int i = 0; i < this.waitingForItems.size(); ++i) {
                WaitForItem wfi = this.waitingForItems.get(i);
                if (wfi.getInventory() == null || wfi.getItemStack().func_190926_b()) {
                    foundIdx = i;
                    found = wfi;
                    break;
                }
                IItemHandler handler = this.getItemHandlerAt(wfi.getInventory());
                int cnt = this.countItemInHandler(wfi.getItemStack(), handler);
                if (cnt < wfi.getItemStack().func_190916_E()) continue;
                foundIdx = i;
                found = wfi;
                break;
            }
            if (found == null) continue;
            this.waitingForItems.remove(foundIdx);
            this.runOrQueueEvent(cardIndex, event, found.getTicket(), null);
        }
    }

    private void handleEventsTimer(int i, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_TIMER)) {
            int index = event.getIndex();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0) continue;
            this.runOrDropEvent(i, event, null, null);
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard) {
        int redstoneOffMask = this.prevIn & ~this.powerLevel;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                EnumFacing enumFacing = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard) {
        int redstoneOnMask = this.powerLevel & ~this.prevIn;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                EnumFacing enumFacing = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOffMask = prevMask & ~newMask;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOnMask = newMask & ~prevMask;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    public void clearRunningEvent(int cardIndex, int eventIndex) {
        this.runningEvents.remove(Pair.of((Object)cardIndex, (Object)eventIndex));
    }

    private void runOrDropEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.isSingle() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.getIndex()))) {
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            for (QueuedEvent q : this.eventQueue) {
                if (q.getCardIndex() != cardIndex || !q.getCompiledEvent().equals(event)) continue;
                return;
            }
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue(parameter);
            core.startProgram(program);
            if (event.isSingle()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.getIndex()));
            }
        }
    }

    private void runOrQueueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.isSingle() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.getIndex()))) {
            this.queueEvent(cardIndex, event, ticket, parameter);
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue(parameter);
            core.startProgram(program);
            if (event.isSingle()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.getIndex()));
            }
        }
    }

    private void queueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (this.eventQueue.size() >= GeneralConfiguration.maxEventQueueSize) {
            throw new ProgException(ExceptionType.EXCEPT_TOOMANYEVENTS);
        }
        this.eventQueue.add(new QueuedEvent(cardIndex, event, ticket, parameter));
    }

    @Override
    public int signal(String signal) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                this.runOrQueueEvent(i, event, null, null);
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public int signal(Tuple location) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_GFX_SELECT)) {
                int index = event.getIndex();
                this.runOrQueueEvent(i, event, null, Parameter.builder().type(ParameterType.PAR_TUPLE).value(ParameterValue.constant(location)).build());
                ++cnt;
            }
        }
        return cnt;
    }

    public void receiveMessage(String name, @Nullable Parameter value) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_MESSAGE)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String messageName = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!name.equals(messageName)) continue;
                this.runOrQueueEvent(i, event, null, value);
            }
        }
    }

    private String getStatus(int c) {
        String db;
        CpuCore core = this.cpuCores.get(c);
        String string = db = core.isDebug() ? "[DB] " : "";
        if (core.hasProgram()) {
            RunningProgram program = core.getProgram();
            if (program.getDelay() > 0) {
                return db + "<delayed: " + program.getDelay() + ">";
            }
            if (program.getLock() != null) {
                return db + "<locked: " + program.getLock() + ">";
            }
            return db + "<busy>";
        }
        return db + "<idle>";
    }

    public void listStatus() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            this.log("Core: " + n + " -> " + this.getStatus(n));
            ++n;
        }
        this.log("Event queue: " + this.eventQueue.size());
        this.log("Waiting items: " + this.waitingForItems.size());
        this.log("Locks: " + this.locks.size());
        if (this.lastException != null) {
            long dt = System.currentTimeMillis() - this.lastExceptionTime;
            this.log("Last: " + TextFormatting.RED + this.lastException);
            if (dt > 3600000L) {
                this.log("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                this.log("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                this.log("(" + dt / 1000L + "sec ago)");
            } else {
                this.log("(" + dt + "ms ago)");
            }
        }
    }

    public int stopPrograms() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            if (!core.hasProgram()) continue;
            ++n;
            core.stopProgram();
        }
        this.locks.clear();
        this.runningEvents.clear();
        return n;
    }

    public void reset() {
        this.waitingForItems.clear();
        this.eventQueue.clear();
        this.stopPrograms();
        for (EnumFacing facing : EnumFacing.values()) {
            this.powerOut[facing.ordinal()] = 0;
        }
        for (BlockPos np : this.networkNodes.values()) {
            TileEntity te = this.func_145831_w().func_175625_s(np);
            if (!(te instanceof NodeTileEntity)) continue;
            NodeTileEntity tileEntity = (NodeTileEntity)te;
            for (EnumFacing facing : EnumFacing.values()) {
                tileEntity.setPowerOut(facing, 0);
            }
        }
        this.gfxOps.clear();
        this.orderedOps.clear();
        for (CpuCore core : this.cpuCores) {
            core.setDebug(false);
        }
        this.func_70296_d();
    }

    @Override
    public IOpcodeRunnable.OpcodeResult placeLock(String name) {
        if (this.testLock(name)) {
            return IOpcodeRunnable.OpcodeResult.HOLD;
        }
        this.locks.add(name);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    @Override
    public void releaseLock(String name) {
        this.locks.remove(name);
    }

    @Override
    public boolean testLock(String name) {
        return this.locks.contains(name);
    }

    public void clearLog() {
        this.logMessages.clear();
        this.lastException = null;
        this.func_70296_d();
    }

    public void exception(ExceptionType exception, @Nullable RunningProgram program) {
        String message;
        if (exception != ExceptionType.EXCEPT_TOOMANYEVENTS) {
            for (int i = 0; i < this.cardInfo.length; ++i) {
                CardInfo info = this.cardInfo[i];
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_EXCEPTION)) {
                    int index = event.getIndex();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    String code = this.evaluateStringParameter(compiledOpcode, null, 0);
                    if (!exception.getCode().equals(code)) continue;
                    this.runOrQueueEvent(i, event, program == null ? null : program.getCraftTicket(), null);
                    return;
                }
            }
        }
        if (program != null) {
            CompiledCard card = this.getCompiledCard(program.getCardIndex());
            if (card == null) {
                message = TextFormatting.RED + "INTERNAL: " + exception.getDescription();
            } else {
                CompiledOpcode opcode = program.getCurrentOpcode(this);
                int gridX = opcode.getGridX();
                int gridY = opcode.getGridY();
                message = TextFormatting.RED + "[" + gridX + "," + gridY + "] " + exception.getDescription();
            }
        } else {
            message = TextFormatting.RED + exception.getDescription();
        }
        this.lastException = message;
        this.lastExceptionTime = System.currentTimeMillis();
        this.log(message);
    }

    @Override
    public void log(String message) {
        if (message == null) {
            return;
        }
        this.logMessages.add(message);
        while (this.logMessages.size() > GeneralConfiguration.processorMaxloglines) {
            this.logMessages.remove();
        }
    }

    private List<String> getDebugLog() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, this.cpuCores.size()); ++i) {
            result.add(TextFormatting.BLUE + "Core " + i + " " + TextFormatting.WHITE + this.getStatus(i));
        }
        this.showWithWarn("Event queue: ", this.eventQueue.size(), 20, result);
        this.showWithWarn("Waiting items: ", this.waitingForItems.size(), 20, result);
        this.showWithWarn("Locks: ", this.locks.size(), 10, result);
        if (this.lastException != null) {
            long dt = System.currentTimeMillis() - this.lastExceptionTime;
            result.add(TextFormatting.RED + this.lastException);
            if (dt > 3600000L) {
                result.add("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                result.add("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                result.add("(" + dt / 1000L + "sec ago)");
            } else {
                result.add("(" + dt + "ms ago)");
            }
        }
        return result;
    }

    private void showWithWarn(String label, int size, int max, List<String> result) {
        if (size >= max) {
            result.add(label + TextFormatting.RED + size);
        } else {
            result.add(label + TextFormatting.GREEN + size);
        }
    }

    private List<String> getLog() {
        return this.logMessages.stream().collect(Collectors.toList());
    }

    public List<String> getClientLog() {
        return this.clientLog;
    }

    public List<String> getClientDebugLog() {
        return this.clientDebugLog;
    }

    public List<String> getLastMessages(int n) {
        ArrayList<String> rc = new ArrayList<String>();
        int i = 0;
        for (String s : this.logMessages) {
            if (i >= this.logMessages.size() - n) {
                rc.add(s);
            }
            ++i;
        }
        return rc;
    }

    public int getFluidSlotsAvailable() {
        if (this.fluidSlotsAvailable == -1) {
            this.updateFluidSlotsAvailability();
        }
        return this.fluidSlotsAvailable;
    }

    public Parameter[] getVariableArray() {
        return this.variables;
    }

    public List<Parameter> getVariables() {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        Collections.addAll(pars, this.variables);
        return pars;
    }

    public List<PacketGetFluids.FluidEntry> getFluids() {
        ArrayList<PacketGetFluids.FluidEntry> pars = new ArrayList<PacketGetFluids.FluidEntry>();
        for (int i = 0; i < 24; ++i) {
            if (this.isFluidSlotAvailable(i)) {
                EnumFacing side = EnumFacing.values()[i / 4];
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
                if (te instanceof MultiTankTileEntity) {
                    MultiTankTileEntity mtank = (MultiTankTileEntity)te;
                    MultiTankFluidProperties[] propertyList = mtank.getProperties();
                    MultiTankFluidProperties properties = propertyList[i % 4];
                    FluidStack fluidStack = properties == null ? null : properties.getContents();
                    pars.add(new PacketGetFluids.FluidEntry(fluidStack, true));
                    continue;
                }
                pars.add(new PacketGetFluids.FluidEntry(null, true));
                continue;
            }
            pars.add(new PacketGetFluids.FluidEntry(null, false));
        }
        return pars;
    }

    public List<CpuCore> getCpuCores() {
        return this.cpuCores;
    }

    private CpuCore findAvailableCore(int cardIndex) {
        if (this.exclusive) {
            CpuCore core;
            if (cardIndex < this.cpuCores.size() && !(core = this.cpuCores.get(cardIndex)).hasProgram()) {
                return core;
            }
        } else {
            for (CpuCore core : this.cpuCores) {
                if (core.hasProgram()) continue;
                return core;
            }
        }
        return null;
    }

    private void run() {
        long rf = this.getStoredPower();
        for (CpuCore core : this.cpuCores) {
            int rft;
            if (!core.hasProgram() || (long)(rft = GeneralConfiguration.coreRFPerTick[core.getTier()]) >= rf) continue;
            core.run(this);
            this.consumeEnergy(rft);
            rf -= (long)rft;
        }
    }

    private void updateCores() {
        if (this.coresDirty) {
            this.coresDirty = false;
            this.cpuCores.clear();
            for (int i = 0; i < 16; ++i) {
                ItemStack expansionStack = this.inventoryHelper.getStackInSlot(i);
                if (expansionStack.func_190926_b() || !(expansionStack.func_77973_b() instanceof CPUCoreItem)) continue;
                CPUCoreItem coreItem = (CPUCoreItem)expansionStack.func_77973_b();
                CpuCore core = new CpuCore();
                core.setTier(coreItem.getTier());
                this.cpuCores.add(core);
            }
        }
    }

    private void compileCards() {
        if (this.cardsDirty) {
            this.cardsDirty = false;
            for (int i = 16; i < 22; ++i) {
                int cardIndex;
                ItemStack cardStack = this.inventoryHelper.getStackInSlot(i);
                if (cardStack.func_190926_b() || this.cardInfo[cardIndex = i - 16].getCompiledCard() != null) continue;
                CompiledCard compiled = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
                this.cardInfo[cardIndex].setCompiledCard(compiled);
            }
        }
    }

    public String getMachineInfo(Inventory side, int idx) {
        TileEntity te = this.getTileEntityAt(side);
        if (te instanceof MachineInformation) {
            MachineInformation info = (MachineInformation)te;
            if (idx < 0 || idx >= info.getTagCount()) {
                throw new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE_INDEX);
            }
            return info.getData(idx, 0L);
        }
        throw new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE);
    }

    @Override
    public int getEnergy(Inventory side) {
        TileEntity te = this.getTileEntityAt(side);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, side.getIntSide())) {
            IEnergyStorage energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.getIntSide());
            return energy.getEnergyStored();
        }
        throw new ProgException(ExceptionType.EXCEPT_NORF);
    }

    @Override
    public int getMaxEnergy(Inventory side) {
        TileEntity te = this.getTileEntityAt(side);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, side.getIntSide())) {
            IEnergyStorage energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.getIntSide());
            return energy.getMaxEnergyStored();
        }
        throw new ProgException(ExceptionType.EXCEPT_NORF);
    }

    @Override
    public long getEnergyLong(Inventory side) {
        TileEntity te = this.getTileEntityAt(side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((TileEntity)te, null);
        if (level.getMaxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.getEnergy();
    }

    @Override
    public long getMaxEnergyLong(Inventory side) {
        TileEntity te = this.getTileEntityAt(side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((TileEntity)te, null);
        if (level.getMaxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.getMaxEnergy();
    }

    @Override
    public int getLiquid(@Nonnull Inventory side) {
        FluidStack contents;
        IFluidHandler handler = this.getFluidHandlerAt(side);
        IFluidTankProperties[] properties = handler.getTankProperties();
        if (properties != null && properties.length > 0 && (contents = properties[0].getContents()) != null) {
            return contents.amount;
        }
        return 0;
    }

    @Override
    public int getMaxLiquid(@Nonnull Inventory side) {
        IFluidHandler handler = this.getFluidHandlerAt(side);
        IFluidTankProperties[] properties = handler.getTankProperties();
        if (properties != null && properties.length > 0) {
            return properties[0].getCapacity();
        }
        return 0;
    }

    private IStorageScanner getScannerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return this.getStorageScanner();
        }
        return null;
    }

    private IItemHandler getHandlerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return null;
        }
        return this.getItemHandlerAt(inv);
    }

    public boolean compareNBTTag(@Nonnull ItemStack v1, @Nonnull ItemStack v2, @Nonnull String tag) {
        NBTBase tag2;
        if (!v1.func_77942_o() || !v2.func_77942_o()) {
            return v1.func_77942_o() == v2.func_77942_o();
        }
        NBTBase tag1 = v1.func_77978_p().func_74781_a(tag);
        if (tag1 == (tag2 = v2.func_77978_p().func_74781_a(tag))) {
            return true;
        }
        if (tag1 != null) {
            return tag1.equals((Object)tag2);
        }
        return false;
    }

    private MultiTankFluidProperties getFluidPropertiesFromMultiTank(EnumFacing side, int idx) {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
        if (te instanceof MultiTankTileEntity) {
            MultiTankTileEntity mtank = (MultiTankTileEntity)te;
            return mtank.getProperties()[idx];
        }
        return null;
    }

    @Nullable
    public FluidStack examineLiquid(@Nonnull Inventory inv, @Nullable Integer slot) {
        IFluidTankProperties[] properties;
        IFluidHandler handler = this.getFluidHandlerAt(inv);
        if (slot == null) {
            slot = 0;
        }
        if ((properties = handler.getTankProperties()) != null && slot < properties.length) {
            return properties[slot].getContents();
        }
        return null;
    }

    @Nullable
    public FluidStack examineLiquidInternal(IProgram program, int virtualSlot) {
        int idx;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealFluidSlot(virtualSlot);
        EnumFacing side = EnumFacing.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return null;
        }
        return properties.getContents();
    }

    public int pushLiquid(IProgram program, @Nonnull Inventory inv, int amount, int virtualSlot) {
        int idx;
        IFluidHandler handler = this.getFluidHandlerAt(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealFluidSlot(virtualSlot);
        EnumFacing side = EnumFacing.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return 0;
        }
        if (!properties.hasContents()) {
            return 0;
        }
        amount = Math.min(amount, properties.getContentsInternal().amount);
        FluidStack topush = properties.getContents();
        topush.amount = amount;
        int filled = handler.fill(topush, true);
        properties.drain(filled);
        return filled;
    }

    public int fetchLiquid(IProgram program, @Nonnull Inventory inv, int amount, @Nullable FluidStack fluidStack, int virtualSlot) {
        int idx;
        IFluidHandler handler = this.getFluidHandlerAt(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealFluidSlot(virtualSlot);
        EnumFacing side = EnumFacing.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return 0;
        }
        int internalAmount = 0;
        if (properties.hasContents()) {
            if (fluidStack != null && !fluidStack.isFluidEqual(properties.getContentsInternal())) {
                return 0;
            }
            internalAmount = properties.getContentsInternal().amount;
        }
        if (internalAmount + amount > 10000) {
            amount = 10000 - internalAmount;
        }
        if (amount <= 0) {
            return 0;
        }
        if (fluidStack == null) {
            FluidStack drained = handler.drain(amount, false);
            if (drained != null) {
                if (!properties.hasContents() || properties.getContentsInternal().isFluidEqual(drained)) {
                    drained = handler.drain(amount, true);
                    properties.fill(drained);
                    return drained.amount;
                }
                return 0;
            }
        } else {
            FluidStack todrain = fluidStack.copy();
            todrain.amount = amount;
            FluidStack drained = handler.drain(todrain, true);
            if (drained != null) {
                int drainedAmount = drained.amount;
                if (properties.hasContents()) {
                    drained.amount += properties.getContentsInternal().amount;
                }
                properties.fill(drained);
                return drainedAmount;
            }
        }
        return 0;
    }

    public int fetchItems(IProgram program, Inventory inv, Integer slot, ItemStack itemMatcher, boolean routable, boolean oredict, @Nullable Integer amount, int virtualSlot) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack stack = InventoryTools.tryExtractItem(handler, scanner, amount, routable, oredict, itemMatcher, slot);
        if (stack.func_190926_b()) {
            return 0;
        }
        IItemHandler capability = this.getItemHandler();
        if (!capability.insertItem(realSlot, stack, true).func_190926_b()) {
            return 0;
        }
        stack = InventoryTools.extractItem(handler, scanner, amount, routable, oredict, false, itemMatcher, slot);
        capability.insertItem(realSlot, stack, false);
        return stack.func_190916_E();
    }

    @Override
    @Nullable
    public ItemStack getItemInternal(IProgram program, int virtualSlot) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        IItemHandler capability = this.getItemHandler();
        return capability.getStackInSlot(realSlot);
    }

    public int pushItems(IProgram program, Inventory inv, Integer slot, @Nullable Integer amount, int virtualSlot) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        IItemHandler itemHandler = this.getItemHandler();
        ItemStack extracted = itemHandler.extractItem(realSlot, amount == null ? 64 : amount, false);
        if (extracted.func_190926_b()) {
            return 0;
        }
        ItemStack remaining = InventoryTools.insertItem(handler, scanner, extracted, slot);
        if (!remaining.func_190926_b()) {
            itemHandler.insertItem(realSlot, remaining, false);
            return extracted.func_190916_E() - remaining.func_190916_E();
        }
        return extracted.func_190916_E();
    }

    @Override
    public void sendMessage(IProgram program, int idSlot, String messageName, @Nullable Integer variableSlot) {
        BlockPos dest;
        if (!this.hasNetworkCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
        }
        if (this.hasNetworkCard != 1) {
            throw new ProgException(ExceptionType.EXCEPT_NEEDSADVANCEDNETWORK);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realIdSlot = info.getRealSlot(idSlot);
        Integer realVariable = info.getRealVar(variableSlot);
        IItemHandler handler = this.getItemHandler();
        ItemStack idCard = handler.getStackInSlot(realIdSlot);
        if (idCard.func_190926_b() || !(idCard.func_77973_b() instanceof NetworkIdentifierItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANIDENTIFIER);
        }
        NBTTagCompound tagCompound = idCard.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("monitorx")) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        int monitordim = tagCompound.func_74762_e("monitordim");
        int monitorx = tagCompound.func_74762_e("monitorx");
        int monitory = tagCompound.func_74762_e("monitory");
        int monitorz = tagCompound.func_74762_e("monitorz");
        WorldServer world = DimensionManager.getWorld((int)monitordim);
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)(dest = new BlockPos(monitorx, monitory, monitorz)))) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        TileEntity te = world.func_175625_s(dest);
        if (!(te instanceof ProcessorTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        ProcessorTileEntity destTE = (ProcessorTileEntity)te;
        destTE.receiveMessage(messageName, realVariable == null ? null : this.getVariableArray()[realVariable]);
    }

    private void setOp(String id, GfxOp op) {
        if (!this.hasGraphicsCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGGRAPHICSCARD);
        }
        if (!this.gfxOps.containsKey(id)) {
            if (this.gfxOps.size() >= GeneralConfiguration.maxGraphicsOpcodes) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            this.orderedOps = null;
        }
        this.gfxOps.put(id, op);
        this.func_70296_d();
    }

    private void sortOps() {
        this.orderedOps = new ArrayList<String>(this.gfxOps.keySet());
        this.orderedOps.sort(new Comparator<String>(){

            @Override
            public int compare(String s, String t1) {
                return s.compareTo(t1);
            }
        });
    }

    @Override
    public void gfxDrawBox(IProgram program, String id, int x, int y, int w, int h, int color) {
        this.setOp(id, new GfxOpBox(x, y, w, h, color));
    }

    @Override
    public void gfxDrawLine(IProgram program, String id, int x1, int y1, int x2, int y2, int color) {
        this.setOp(id, new GfxOpLine(x1, y1, x2, y2, color));
    }

    @Override
    public void gfxDrawText(IProgram program, String id, int x, int y, String text, int color) {
        this.setOp(id, new GfxOpText(x, y, text, color));
    }

    @Override
    public void gfxDrawBox(IProgram program, String id, @Nonnull Tuple loc, @Nonnull Tuple size, int color) {
        this.setOp(id, new GfxOpBox(loc.getX(), loc.getY(), size.getX(), size.getY(), color));
    }

    @Override
    public void gfxDrawLine(IProgram program, String id, @Nonnull Tuple pos1, @Nonnull Tuple pos2, int color) {
        this.setOp(id, new GfxOpLine(pos1.getX(), pos1.getY(), pos2.getX(), pos2.getY(), color));
    }

    @Override
    public void gfxDrawText(IProgram program, String id, @Nonnull Tuple pos, String text, int color) {
        this.setOp(id, new GfxOpText(pos.getX(), pos.getY(), text, color));
    }

    @Override
    public void gfxClear(IProgram program, @Nullable String id) {
        if (id == null || id.isEmpty()) {
            this.gfxOps.clear();
            this.orderedOps = null;
        } else {
            this.gfxOps.remove(id);
            this.orderedOps = null;
        }
        this.func_70296_d();
    }

    public Map<String, GfxOp> getGfxOps() {
        return this.gfxOps;
    }

    public List<String> getOrderedOps() {
        if (this.orderedOps == null) {
            this.sortOps();
        }
        return this.orderedOps;
    }

    public void setClientOrderedGfx(Map<String, GfxOp> gfxOps, List<String> orderedOps) {
        this.clientGfxOps.clear();
        for (String key : orderedOps) {
            this.clientGfxOps.add(gfxOps.get(key));
        }
    }

    public List<GfxOp> getClientGfxOps() {
        return this.clientGfxOps;
    }

    public int getMaxvars() {
        if (this.maxVars == -1) {
            this.maxVars = 0;
            this.hasNetworkCard = -1;
            this.hasGraphicsCard = false;
            this.storageCard = -1;
            Item storageCardItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftools", "storage_control_module"));
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof NetworkCardItem) {
                    this.hasNetworkCard = ((NetworkCardItem)stack.func_77973_b()).getTier();
                    continue;
                }
                if (stack.func_77973_b() instanceof RAMChipItem) {
                    this.maxVars += 8;
                    continue;
                }
                if (stack.func_77973_b() instanceof GraphicsCardItem) {
                    this.hasGraphicsCard = true;
                    continue;
                }
                if (stack.func_77973_b() != storageCardItem) continue;
                this.storageCard = i;
            }
            if (this.maxVars >= 32) {
                this.maxVars = 32;
            }
            this.updateFluidSlotsAvailability();
        }
        return this.maxVars;
    }

    public void markFluidSlotsDirty() {
        this.fluidSlotsAvailable = -1;
    }

    private void updateFluidSlotsAvailability() {
        this.fluidSlotsAvailable = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (!(te instanceof MultiTankTileEntity)) continue;
            this.fluidSlotsAvailable |= 1 << facing.ordinal();
        }
        this.fixCardInfoForSlotAvailability();
        this.func_70296_d();
    }

    private void fixCardInfoForSlotAvailability() {
        for (CardInfo info : this.cardInfo) {
            int alloc = info.getFluidAllocation();
            for (int i = 0; i < 24; ++i) {
                if ((this.fluidSlotsAvailable & 1 << i / 4) != 0) continue;
                alloc &= ~(1 << i);
            }
            info.setFluidAllocation(alloc);
        }
    }

    public boolean hasGraphicsCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasGraphicsCard;
    }

    public boolean hasNetworkCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasNetworkCard != -1;
    }

    public int getStorageCard() {
        if (this.storageCard == -2) {
            this.getMaxvars();
        }
        return this.storageCard;
    }

    public String getChannelName() {
        return this.channel;
    }

    public int getNodeCount() {
        return this.networkNodes.size();
    }

    public void stopOrResume(IProgram program) {
        ((RunningProgram)program).popLoopStack(this);
    }

    public boolean testGreater(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = program.getLastValue();
        Parameter varValue = this.variables[realVar];
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        return ParameterTools.compare(lastValue, varValue) > 0;
    }

    public boolean testEquality(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = program.getLastValue();
        Parameter varValue = this.variables[realVar];
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        Object v1 = lastValue.getParameterValue().getValue();
        Object v2 = varValue.getParameterValue().getValue();
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        if (varValue.getParameterType() == ParameterType.PAR_ITEM) {
            return ((ItemStack)v1).func_77969_a((ItemStack)v2);
        }
        if (varValue.getParameterType() == ParameterType.PAR_FLUID) {
            return ((FluidStack)v1).isFluidEqual((FluidStack)v2);
        }
        if (varValue.getParameterType() == ParameterType.PAR_VECTOR) {
            return ParameterTools.compare(lastValue, varValue) == 0;
        }
        return v1.equals(v2);
    }

    private int getRealVarSafe(int var, CardInfo info) {
        int realVar = info.getRealVar(var);
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        return realVar;
    }

    public void handleCall(IProgram program, String signal) {
        RunningProgram p = (RunningProgram)program;
        CardInfo info = this.cardInfo[p.getCardIndex()];
        CompiledCard compiledCard = info.getCompiledCard();
        if (compiledCard != null) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                p.pushCall(p.getCurrentOpcode(this).getPrimaryIndex());
                p.setCurrent(event.getIndex());
                return;
            }
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGSIGNAL);
    }

    public IOpcodeRunnable.OpcodeResult handleLoop(IProgram program, int varIdx, int end) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(varIdx, info);
        Parameter parameter = this.getVariableArray()[realVar];
        int i = TypeConverters.convertToInt(parameter);
        if (i > end) {
            return IOpcodeRunnable.OpcodeResult.NEGATIVE;
        }
        ((RunningProgram)program).pushLoopStack(realVar);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void setValueInToken(IProgram program, int slot) {
        Parameter lastValue;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.getItemHandler().getStackInSlot(realSlot);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((lastValue = program.getLastValue()) == null) {
            stack.func_77978_p().func_82580_o("parameter");
        } else {
            NBTTagCompound tag = ParameterTools.writeToNBT(lastValue);
            stack.func_77978_p().func_74782_a("parameter", (NBTBase)tag);
        }
    }

    @Nullable
    public Parameter getParameterFromToken(IProgram program, int slot) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.getItemHandler().getStackInSlot(realSlot);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p().func_74775_l("parameter");
        if (tag.func_82582_d()) {
            return null;
        }
        return ParameterTools.readFromNBT(tag);
    }

    @Override
    public void setVariable(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        this.variables[realVar] = program.getLastValue();
    }

    @Override
    public Parameter getVariable(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        return this.variables[realVar];
    }

    @Nullable
    public <T> T evaluateGenericParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        List<Parameter> parameters = compiledOpcode.getParameters();
        if (parIndex >= parameters.size()) {
            return null;
        }
        Parameter parameter = parameters.get(parIndex);
        ParameterValue value = parameter.getParameterValue();
        if (value.isConstant()) {
            return convertor.apply(parameter.getParameterType(), value.getValue());
        }
        if (value.isFunction()) {
            Function function = value.getFunction();
            Object v = function.getFunctionRunnable().run(this, program);
            return convertor.apply(function.getReturnType(), v);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(value.getVariableIndex(), info);
        Parameter par = this.variables[realVar];
        if (par == null || par.getParameterValue() == null) {
            return null;
        }
        return convertor.apply(par.getParameterType(), par.getParameterValue().getValue());
    }

    @Nonnull
    public <T> T evaluateGenericParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        T rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, convertor);
        if (rc == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return rc;
    }

    @Override
    @Nonnull
    public <T> T evaluateParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Override
    @Nullable
    public <T> T evaluateParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameter(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Override
    @Nullable
    public Tuple evaluateTupleParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Override
    @Nonnull
    public Tuple evaluateTupleParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Override
    @Nullable
    public List<Parameter> evaluateVectorParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
    }

    @Override
    @Nonnull
    public List<Parameter> evaluateVectorParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
    }

    @Override
    @Nullable
    public ItemStack evaluateItemParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack evaluateItemParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return stack;
    }

    @Override
    @Nullable
    public FluidStack evaluateFluidParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Override
    @Nonnull
    public FluidStack evaluateFluidParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Override
    @Nullable
    public BlockSide evaluateSideParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Override
    @Nonnull
    public BlockSide evaluateSideParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Override
    @Nullable
    public Inventory evaluateInventoryParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    @Override
    @Nonnull
    public Inventory evaluateInventoryParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    @Override
    public int evaluateIntParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Integer value = this.evaluateIntegerParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public long evaluateLngParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Long value = this.evaluateLongParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Override
    @Nullable
    public Integer evaluateIntegerParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INTEGER);
    }

    @Override
    @Nullable
    public Long evaluateLongParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_LONG);
    }

    @Override
    @Nullable
    public Number evaluateNumberParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_NUMBER);
    }

    @Override
    @Nullable
    public String evaluateStringParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    @Override
    @Nonnull
    public String evaluateStringParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    @Override
    public boolean evaluateBoolParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Boolean rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_BOOL);
        if (rc == null) {
            return false;
        }
        return rc;
    }

    public int countItemStorage(ItemStack stack, boolean routable, boolean oredict) {
        IStorageScanner scanner = this.getStorageScanner();
        if (scanner == null) {
            return 0;
        }
        return scanner.countItems(stack, routable, oredict);
    }

    private IStorageScanner getStorageScanner() {
        int card = this.getStorageCard();
        if (card == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        ItemStack storageStack = this.func_70301_a(card);
        if (!storageStack.func_77942_o()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        NBTTagCompound tagCompound = storageStack.func_77978_p();
        BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
        int dim = tagCompound.func_74762_e("monitordim");
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)c)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        TileEntity te = world.func_175625_s(c);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!(te instanceof IStorageScanner)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        return (IStorageScanner)te;
    }

    public int countSlots(Inventory inv, IProgram program) {
        IItemHandler handler = this.getItemHandlerAt(inv);
        return handler.getSlots();
    }

    public int countItem(Inventory inv, Integer slot, ItemStack itemMatcher, boolean oredict, boolean routable, IProgram program) {
        if (inv == null) {
            return this.countItemStorage(itemMatcher, routable, oredict);
        }
        IItemHandler handler = this.getItemHandlerAt(inv);
        if (slot != null) {
            ItemStack stackInSlot = handler.getStackInSlot(slot.intValue());
            if (stackInSlot.func_190926_b()) {
                return 0;
            }
            if (!itemMatcher.func_190926_b() && !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)itemMatcher)) {
                return 0;
            }
            return stackInSlot.func_190916_E();
        }
        if (!itemMatcher.func_190926_b()) {
            return this.countItemInHandler(itemMatcher, handler);
        }
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            cnt += stack.func_190916_E();
        }
        return cnt;
    }

    private int countItemInHandler(ItemStack itemMatcher, IItemHandler handler) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) continue;
            cnt += stack.func_190916_E();
        }
        return cnt;
    }

    @Override
    @Nullable
    public TileEntity getTileEntityAt(@Nullable BlockSide inv) {
        BlockPos np = this.getPositionAt(inv);
        if (np == null) {
            return null;
        }
        return this.func_145831_w().func_175625_s(np);
    }

    @Override
    @Nullable
    public BlockPos getPositionAt(@Nullable BlockSide inv) {
        if (inv == null) {
            return null;
        }
        BlockPos p = this.field_174879_c;
        if (inv.hasNodeName()) {
            if (!this.hasNetworkCard()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            p = this.networkNodes.get(inv.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        }
        if (inv.getSide() == null) {
            return p;
        }
        return p.func_177972_a(inv.getSide());
    }

    @Override
    @Nonnull
    public IFluidHandler getFluidHandlerAt(@Nonnull Inventory inv) {
        IFluidHandler handler;
        TileEntity te = this.getTileEntityAt(inv);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, inv.getIntSide()) && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, inv.getIntSide())) != null) {
            return handler;
        }
        throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
    }

    @Override
    @Nonnull
    public IItemHandler getItemHandlerAt(@Nonnull Inventory inv) {
        EnumFacing intSide = inv.getIntSide();
        TileEntity te = this.getTileEntityAt(inv);
        return this.getItemHandlerAt(te, intSide);
    }

    private IItemHandler getItemHandlerAt(@Nonnull TileEntity te, EnumFacing intSide) {
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
            if (handler != null) {
                return handler;
            }
        } else {
            if (te instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)te;
                return new SidedInvWrapper(sidedInventory, intSide);
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                return new InvWrapper(inventory);
            }
        }
        throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
    }

    private boolean isExpansionSlot(int index) {
        return index >= 0 && index < 16;
    }

    private boolean isCardSlot(int index) {
        return index >= 16 && index < 22;
    }

    private void removeCard(int index) {
        this.cardInfo[index].setCompiledCard(null);
        this.stopPrograms(index);
        ArrayDeque<QueuedEvent> newQueue = new ArrayDeque<QueuedEvent>();
        for (QueuedEvent event : this.eventQueue) {
            if (event.getCardIndex() == index) continue;
            newQueue.add(event);
        }
        this.eventQueue = newQueue;
    }

    private void stopPrograms(int cardIndex) {
        for (CpuCore core : this.cpuCores) {
            if (!core.hasProgram() || core.getProgram().getCardIndex() != cardIndex) continue;
            core.stopProgram();
        }
        HashSet<Pair<Integer, Integer>> newRunningEvents = new HashSet<Pair<Integer, Integer>>();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            if ((Integer)pair.getLeft() == cardIndex) continue;
            newRunningEvents.add(pair);
        }
        this.runningEvents = newRunningEvents;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.coresDirty = true;
            this.maxVars = -1;
        }
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.coresDirty = true;
            this.maxVars = -1;
        }
        return this.getInventoryHelper().decrStackSize(index, count);
    }

    public int getShowHud() {
        return this.showHud;
    }

    public void setShowHud(int showHud) {
        this.showHud = showHud;
        this.markDirtyClient();
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.exclusive = tagCompound.func_74767_n("exclusive");
        this.showHud = tagCompound.func_74771_c("hud");
        this.readCardInfo(tagCompound);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("exclusive", this.exclusive);
        tagCompound.func_74774_a("hud", (byte)this.showHud);
        this.writeCardInfo(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74762_e("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.tickCount = tagCompound.func_74762_e("tickCount");
        this.channel = tagCompound.func_74779_i("channel");
        this.exclusive = tagCompound.func_74767_n("exclusive");
        this.showHud = tagCompound.func_74771_c("hud");
        if (tagCompound.func_74764_b("lastExc")) {
            this.lastException = tagCompound.func_74779_i("lastExc");
            this.lastExceptionTime = tagCompound.func_74763_f("lastExcT");
        } else {
            this.lastException = null;
            this.lastExceptionTime = 0L;
        }
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.readCardInfo(tagCompound);
        this.readCores(tagCompound);
        this.readEventQueue(tagCompound);
        this.readLog(tagCompound);
        this.readVariables(tagCompound);
        this.readNetworkNodes(tagCompound);
        this.readCraftingStations(tagCompound);
        this.readWaitingForItems(tagCompound);
        this.readLocks(tagCompound);
        this.readRunningEvents(tagCompound);
        this.readGraphicsOperations(tagCompound);
    }

    private void readGraphicsOperations(NBTTagCompound tagCompound) {
        this.gfxOps.clear();
        NBTTagCompound opTag = tagCompound.func_74775_l("gfxop");
        for (String key : opTag.func_150296_c()) {
            this.gfxOps.put(key, GfxOp.readFromNBT(opTag.func_74775_l(key)));
        }
        this.sortOps();
    }

    private void readRunningEvents(NBTTagCompound tagCompound) {
        this.runningEvents.clear();
        NBTTagList evList = tagCompound.func_150295_c("singev", 10);
        for (int i = 0; i < evList.func_74745_c(); ++i) {
            NBTTagCompound tag = evList.func_150305_b(i);
            int cardIndex = tag.func_74762_e("card");
            int eventIndex = tag.func_74762_e("event");
            this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)eventIndex));
        }
    }

    private void readLocks(NBTTagCompound tagCompound) {
        this.locks.clear();
        NBTTagList lockList = tagCompound.func_150295_c("locks", 8);
        for (int i = 0; i < lockList.func_74745_c(); ++i) {
            String name = lockList.func_150307_f(i);
            this.locks.add(name);
        }
    }

    private void readWaitingForItems(NBTTagCompound tagCompound) {
        this.waitingForItems.clear();
        NBTTagList waitingList = tagCompound.func_150295_c("waiting", 10);
        for (int i = 0; i < waitingList.func_74745_c(); ++i) {
            NBTTagCompound tag = waitingList.func_150305_b(i);
            String ticket = tag.func_74779_i("ticket");
            ItemStack stack = tag.func_74764_b("item") ? new ItemStack(tag.func_74775_l("item")) : ItemStack.field_190927_a;
            Inventory inventory = tag.func_74764_b("inv") ? InventoryUtil.readFromNBT(tag.func_74775_l("inv")) : null;
            WaitForItem waitForItem = new WaitForItem(ticket, stack, inventory);
            this.waitingForItems.add(waitForItem);
        }
    }

    private void readCraftingStations(NBTTagCompound tagCompound) {
        this.craftingStations.clear();
        NBTTagList stationList = tagCompound.func_150295_c("stations", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            NBTTagCompound tag = stationList.func_150305_b(i);
            BlockPos nodePos = new BlockPos(tag.func_74762_e("nodex"), tag.func_74762_e("nodey"), tag.func_74762_e("nodez"));
            this.craftingStations.add(nodePos);
        }
    }

    private void readNetworkNodes(NBTTagCompound tagCompound) {
        this.networkNodes.clear();
        NBTTagList networkList = tagCompound.func_150295_c("nodes", 10);
        for (int i = 0; i < networkList.func_74745_c(); ++i) {
            NBTTagCompound tag = networkList.func_150305_b(i);
            String name = tag.func_74779_i("name");
            BlockPos nodePos = new BlockPos(tag.func_74762_e("nodex"), tag.func_74762_e("nodey"), tag.func_74762_e("nodez"));
            this.networkNodes.put(name, nodePos);
        }
    }

    private void readVariables(NBTTagCompound tagCompound) {
        for (int i = 0; i < 32; ++i) {
            this.variables[i] = null;
        }
        NBTTagList varList = tagCompound.func_150295_c("vars", 10);
        for (int i = 0; i < varList.func_74745_c(); ++i) {
            NBTTagCompound var = varList.func_150305_b(i);
            int index = var.func_74762_e("varidx");
            this.variables[index] = ParameterTools.readFromNBT(var);
        }
    }

    private void readLog(NBTTagCompound tagCompound) {
        this.logMessages.clear();
        NBTTagList logList = tagCompound.func_150295_c("log", 8);
        for (int i = 0; i < logList.func_74745_c(); ++i) {
            this.logMessages.add(logList.func_150307_f(i));
        }
    }

    private void readCores(NBTTagCompound tagCompound) {
        NBTTagList coreList = tagCompound.func_150295_c("cores", 10);
        this.cpuCores.clear();
        this.coresDirty = false;
        for (int i = 0; i < coreList.func_74745_c(); ++i) {
            CpuCore core = new CpuCore();
            core.readFromNBT(coreList.func_150305_b(i));
            this.cpuCores.add(core);
        }
        if (this.cpuCores.isEmpty()) {
            this.coresDirty = true;
        }
    }

    private void readEventQueue(NBTTagCompound tagCompound) {
        this.eventQueue.clear();
        NBTTagList eventQueueList = tagCompound.func_150295_c("events", 10);
        for (int i = 0; i < eventQueueList.func_74745_c(); ++i) {
            NBTTagCompound tag = eventQueueList.func_150305_b(i);
            int card = tag.func_74762_e("card");
            int index = tag.func_74762_e("index");
            boolean single = tag.func_74767_n("single");
            String ticket = tag.func_74764_b("ticket") ? tag.func_74779_i("ticket") : null;
            Parameter parameter = null;
            if (tag.func_74764_b("parameter")) {
                parameter = ParameterTools.readFromNBT(tag.func_74775_l("parameter"));
            }
            this.eventQueue.add(new QueuedEvent(card, new CompiledEvent(index, single), ticket, parameter));
        }
    }

    private void readCardInfo(NBTTagCompound tagCompound) {
        NBTTagList cardInfoList = tagCompound.func_150295_c("cardInfo", 10);
        for (int i = 0; i < cardInfoList.func_74745_c(); ++i) {
            this.cardInfo[i] = CardInfo.readFromNBT(cardInfoList.func_150305_b(i));
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("tickCount", this.tickCount);
        tagCompound.func_74778_a("channel", this.channel == null ? "" : this.channel);
        tagCompound.func_74757_a("exclusive", this.exclusive);
        tagCompound.func_74774_a("hud", (byte)this.showHud);
        if (this.lastException != null) {
            tagCompound.func_74778_a("lastExc", this.lastException);
            tagCompound.func_74772_a("lastExcT", this.lastExceptionTime);
        }
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        this.writeCardInfo(tagCompound);
        this.writeCores(tagCompound);
        this.writeEventQueue(tagCompound);
        this.writeLog(tagCompound);
        this.writeVariables(tagCompound);
        this.writeNetworkNodes(tagCompound);
        this.writeCraftingStations(tagCompound);
        this.writeWaitingForItems(tagCompound);
        this.writeLocks(tagCompound);
        this.writeRunningEvents(tagCompound);
        this.writeGraphicsOperation(tagCompound);
    }

    private void writeGraphicsOperation(NBTTagCompound tagCompound) {
        NBTTagCompound opTag = new NBTTagCompound();
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            opTag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().writeToNBT());
        }
        tagCompound.func_74782_a("gfxop", (NBTBase)opTag);
    }

    private void writeRunningEvents(NBTTagCompound tagCompound) {
        NBTTagList evList = new NBTTagList();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("card", ((Integer)pair.getLeft()).intValue());
            tag.func_74768_a("event", ((Integer)pair.getRight()).intValue());
            evList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("singev", (NBTBase)evList);
    }

    private void writeLocks(NBTTagCompound tagCompound) {
        NBTTagList lockList = new NBTTagList();
        for (String name : this.locks) {
            lockList.func_74742_a((NBTBase)new NBTTagString(name));
        }
        tagCompound.func_74782_a("locks", (NBTBase)lockList);
    }

    private void writeWaitingForItems(NBTTagCompound tagCompound) {
        NBTTagList waitingList = new NBTTagList();
        for (WaitForItem waitingForItem : this.waitingForItems) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ticket", waitingForItem.getTicket());
            if (waitingForItem.getInventory() != null) {
                tag.func_74782_a("inv", (NBTBase)InventoryUtil.writeToNBT(waitingForItem.getInventory()));
            }
            if (!waitingForItem.getItemStack().func_190926_b()) {
                tag.func_74782_a("item", (NBTBase)waitingForItem.getItemStack().serializeNBT());
            }
            waitingList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("waiting", (NBTBase)waitingList);
    }

    private void writeCraftingStations(NBTTagCompound tagCompound) {
        NBTTagList stationList = new NBTTagList();
        for (BlockPos pos : this.craftingStations) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("nodex", pos.func_177958_n());
            tag.func_74768_a("nodey", pos.func_177956_o());
            tag.func_74768_a("nodez", pos.func_177952_p());
            stationList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("stations", (NBTBase)stationList);
    }

    private void writeNetworkNodes(NBTTagCompound tagCompound) {
        NBTTagList networkList = new NBTTagList();
        for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", entry.getKey());
            tag.func_74768_a("nodex", entry.getValue().func_177958_n());
            tag.func_74768_a("nodey", entry.getValue().func_177956_o());
            tag.func_74768_a("nodez", entry.getValue().func_177952_p());
            networkList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("nodes", (NBTBase)networkList);
    }

    private void writeVariables(NBTTagCompound tagCompound) {
        NBTTagList varList = new NBTTagList();
        for (int i = 0; i < 32; ++i) {
            if (this.variables[i] == null) continue;
            NBTTagCompound var = ParameterTools.writeToNBT(this.variables[i]);
            var.func_74768_a("varidx", i);
            varList.func_74742_a((NBTBase)var);
        }
        tagCompound.func_74782_a("vars", (NBTBase)varList);
    }

    private void writeLog(NBTTagCompound tagCompound) {
        NBTTagList logList = new NBTTagList();
        for (String message : this.logMessages) {
            logList.func_74742_a((NBTBase)new NBTTagString(message));
        }
        tagCompound.func_74782_a("log", (NBTBase)logList);
    }

    private void writeCores(NBTTagCompound tagCompound) {
        NBTTagList coreList = new NBTTagList();
        for (CpuCore core : this.cpuCores) {
            coreList.func_74742_a((NBTBase)core.writeToNBT());
        }
        tagCompound.func_74782_a("cores", (NBTBase)coreList);
    }

    private void writeEventQueue(NBTTagCompound tagCompound) {
        NBTTagList eventQueueList = new NBTTagList();
        for (QueuedEvent queuedEvent : this.eventQueue) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("card", queuedEvent.getCardIndex());
            tag.func_74768_a("index", queuedEvent.getCompiledEvent().getIndex());
            tag.func_74757_a("single", queuedEvent.getCompiledEvent().isSingle());
            if (queuedEvent.getTicket() != null) {
                tag.func_74778_a("ticket", queuedEvent.getTicket());
            }
            if (queuedEvent.getParameter() != null) {
                NBTTagCompound parTag = ParameterTools.writeToNBT(queuedEvent.getParameter());
                tag.func_74782_a("parameter", (NBTBase)parTag);
            }
            eventQueueList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("events", (NBTBase)eventQueueList);
    }

    private void writeCardInfo(NBTTagCompound tagCompound) {
        NBTTagList cardInfoList = new NBTTagList();
        for (CardInfo info : this.cardInfo) {
            cardInfoList.func_74742_a((NBTBase)info.writeToNBT());
        }
        tagCompound.func_74782_a("cardInfo", (NBTBase)cardInfoList);
    }

    public boolean isFluidAllocated(int cardIndex, int fluidIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int fluidAlloc = info.getFluidAllocation();
                if ((fluidAlloc >> fluidIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int fluidA = info.getFluidAllocation();
        return (fluidA >> fluidIndex & 1) != 0;
    }

    public boolean isVarAllocated(int cardIndex, int varIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int varAlloc = info.getVarAllocation();
                if ((varAlloc >> varIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int varAlloc = info.getVarAllocation();
        return (varAlloc >> varIndex & 1) != 0;
    }

    public boolean isItemAllocated(int cardIndex, int itemIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int itemAlloc = info.getItemAllocation();
                if ((itemAlloc >> itemIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int itemAlloc = info.getItemAllocation();
        return (itemAlloc >> itemIndex & 1) != 0;
    }

    public CardInfo getCardInfo(int index) {
        return this.cardInfo[index];
    }

    public CompiledCard getCompiledCard(int index) {
        CardInfo info = this.getCardInfo(index);
        CompiledCard card = info.getCompiledCard();
        ItemStack cardStack = this.inventoryHelper.getStackInSlot(index + 16);
        if (card == null && !cardStack.func_190926_b()) {
            card = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
            this.cardInfo[index].setCompiledCard(card);
        }
        return card;
    }

    private void allocate(int card, int itemAlloc, int varAlloc, int fluidAlloc) {
        this.cardInfo[card].setItemAllocation(itemAlloc);
        this.cardInfo[card].setVarAllocation(varAlloc);
        this.cardInfo[card].setFluidAllocation(fluidAlloc);
        this.func_70296_d();
    }

    public void showNetworkInfo() {
        this.log("Channel: " + this.channel);
        this.log("Nodes: " + this.networkNodes.size());
    }

    public void listNodes() {
        if (this.networkNodes.isEmpty()) {
            this.log("No nodes!");
        } else {
            for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
                this.log("Node " + entry.getKey() + " at " + BlockPosTools.toString((BlockPos)entry.getValue()));
            }
        }
    }

    public void setupNetwork(String name) {
        this.channel = name;
        this.func_70296_d();
    }

    public void redstoneNodeChange(int previousMask, int newMask, String node) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard, node, previousMask, newMask);
            this.handleEventsRedstoneOff(i, compiledCard, node, previousMask, newMask);
        }
    }

    public void scanNodes() {
        if (!this.hasNetworkCard()) {
            this.log(TextFormatting.RED + "No network card!");
            return;
        }
        if (this.channel == null || this.channel.isEmpty()) {
            this.log(TextFormatting.RED + "Setup a channel first!");
            return;
        }
        this.networkNodes.clear();
        this.craftingStations.clear();
        int range = this.hasNetworkCard == 0 ? 8 : 16;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos n = new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z);
                    TileEntity te = this.func_145831_w().func_175625_s(n);
                    if (te instanceof NodeTileEntity) {
                        NodeTileEntity node = (NodeTileEntity)te;
                        if (!this.channel.equals(node.getChannelName())) continue;
                        if (node.getNodeName() == null || node.getNodeName().isEmpty()) {
                            this.log("Node is missing a name!");
                            continue;
                        }
                        this.networkNodes.put(node.getNodeName(), n);
                        node.setProcessor(this.func_174877_v());
                        continue;
                    }
                    if (!(te instanceof CraftingStationTileEntity)) continue;
                    CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
                    craftingStation.registerProcessor(this.field_174879_c);
                    this.craftingStations.add(n);
                }
            }
        }
        this.log("Found " + this.networkNodes.size() + " node(s)");
        this.log("Found " + this.craftingStations.size() + " crafting station(s)");
        this.func_70296_d();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_ALLOCATE.equals(command)) {
            int card = (Integer)args.get(PARAM_CARD);
            int itemAlloc = (Integer)args.get(PARAM_ITEMS);
            int varAlloc = (Integer)args.get(PARAM_VARS);
            int fluidAlloc = (Integer)args.get(PARAM_FLUID);
            this.allocate(card, itemAlloc, varAlloc, fluidAlloc);
            return true;
        }
        if (CMD_EXECUTE.equals(command)) {
            Commands.executeCommand(this, (String)args.get(PARAM_CMD));
            return true;
        }
        if (CMD_SETEXCLUSIVE.equals(command)) {
            boolean v = (Boolean)args.get(PARAM_EXCLUSIVE);
            this.setExclusive(v);
            return true;
        }
        if (CMD_SETHUDMODE.equals(command)) {
            int v = (Integer)args.get(PARAM_HUDMODE);
            this.setShowHud(v);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getLog".equals(command)) {
            return type.convert(this.getLog());
        }
        if ("getDebugLog".equals(command)) {
            return type.convert(this.getDebugLog());
        }
        if ("getVars".equals(command)) {
            return type.convert(this.getVariables());
        }
        if ("getFluids".equals(command)) {
            return type.convert(this.getFluids());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getLog".equals(command)) {
            this.clientLog = Type.STRING.convert(list);
            return true;
        }
        if ("getDebugLog".equals(command)) {
            this.clientDebugLog = Type.STRING.convert(list);
            return true;
        }
        if ("getVars".equals(command)) {
            GuiProcessor.storeVarsForClient(Type.create(Parameter.class).convert(list));
            return true;
        }
        if ("getFluids".equals(command)) {
            GuiProcessor.storeFluidsForClient(Type.create(PacketGetFluids.FluidEntry.class).convert(list));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)xCoord, (double)yCoord, (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 21), (double)(zCoord + 1));
    }
}

