/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.analog;

import java.text.DecimalFormat;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.analog.AnalogTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiAnalog
extends GenericGuiContainer<AnalogTileEntity> {
    private TextField mulEqual;
    private TextField mulLess;
    private TextField mulGreater;
    private TextField addEqual;
    private TextField addLess;
    private TextField addGreater;
    private static final DecimalFormat fmt = new DecimalFormat("#.#");

    public GuiAnalog(AnalogTileEntity te, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, RFTools.GUI_MANUAL_MAIN, "analog");
    }

    public void func_73866_w_() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/analog.gui"));
        super.func_73866_w_();
        this.initializeFields();
        this.setupEvents();
    }

    private void initializeFields() {
        this.mulEqual = (TextField)this.window.findChild("mul_eq");
        this.mulLess = (TextField)this.window.findChild("mul_less");
        this.mulGreater = (TextField)this.window.findChild("mul_greater");
        this.addEqual = (TextField)this.window.findChild("add_eq");
        this.addLess = (TextField)this.window.findChild("add_less");
        this.addGreater = (TextField)this.window.findChild("add_greater");
        this.mulEqual.setText(fmt.format(((AnalogTileEntity)this.tileEntity).getMulEqual()));
        this.mulLess.setText(fmt.format(((AnalogTileEntity)this.tileEntity).getMulLess()));
        this.mulGreater.setText(fmt.format(((AnalogTileEntity)this.tileEntity).getMulGreater()));
        this.addEqual.setText(String.valueOf(((AnalogTileEntity)this.tileEntity).getAddEqual()));
        this.addLess.setText(String.valueOf(((AnalogTileEntity)this.tileEntity).getAddLess()));
        this.addGreater.setText(String.valueOf(((AnalogTileEntity)this.tileEntity).getAddGreater()));
    }

    private void setupEvents() {
        this.window.event("update", (source, params) -> this.updateAnalog());
    }

    private static double safeDouble(String f) {
        try {
            return Double.parseDouble(f);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private static int safeInt(String f) {
        try {
            return Integer.parseInt(f);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateAnalog() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "analog.update", TypedMap.builder().put(AnalogTileEntity.PARAM_MUL_EQ, (Object)GuiAnalog.safeDouble(this.mulEqual.getText())).put(AnalogTileEntity.PARAM_MUL_LESS, (Object)GuiAnalog.safeDouble(this.mulLess.getText())).put(AnalogTileEntity.PARAM_MUL_GT, (Object)GuiAnalog.safeDouble(this.mulGreater.getText())).put(AnalogTileEntity.PARAM_ADD_EQ, (Object)GuiAnalog.safeInt(this.addEqual.getText())).put(AnalogTileEntity.PARAM_ADD_LESS, (Object)GuiAnalog.safeInt(this.addLess.getText())).put(AnalogTileEntity.PARAM_ADD_GT, (Object)GuiAnalog.safeInt(this.addGreater.getText())).build());
    }
}

