/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.IEClocheCompat.CRUD.formats;

import com.nicjames2378.IEClocheCompat.utils.ConversionUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class CropFormat {
    private ItemStack seed;
    private ItemStack[] output;
    private ItemStack soil;
    private Block crop;
    private boolean condition = true;

    public ItemStack getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = ConversionUtils.getItemStackFromStringClean(seed);
    }

    public ItemStack[] getOutputs() {
        return this.output;
    }

    public void setOutputs(String[] output) {
        this.output = ConversionUtils.StringArrayToItemStackArray(output);
    }

    public ItemStack getSoil() {
        return this.soil;
    }

    public void setSoil(String soil) {
        this.soil = ConversionUtils.getItemStackFromStringClean(soil);
    }

    public Block getCrop() {
        return this.crop;
    }

    public void setCrop(String crop) {
        this.crop = Block.func_149684_b((String)crop);
    }

    public boolean isConditionValid() {
        return this.condition;
    }

    public CropFormat setCondition(boolean condition) {
        this.condition = condition;
        return this;
    }

    public CropFormat(ItemStack seed, ItemStack[] output, ItemStack soil, Block crop, boolean condition) {
        this.seed = seed;
        this.output = output;
        this.soil = soil;
        this.crop = crop;
        this.condition = condition;
    }

    public CropFormat(ItemStack seed, ItemStack output, ItemStack soil, Block crop, boolean condition) {
        this.seed = seed;
        this.output = new ItemStack[]{output};
        this.soil = soil;
        this.crop = crop;
        this.condition = condition;
    }

    public CropFormat(ItemStack seed, String outputItemStack, String soilItemStack, String cropBlock) {
        this.seed = seed;
        this.output = new ItemStack[]{ConvertUtils.getItemStackFromString(outputItemStack, false)};
        this.soil = ConvertUtils.getItemStackFromString(soilItemStack, false);
        this.crop = Block.func_149684_b((String)cropBlock);
    }

    public CropFormat(String seedItemStack, String[] outputItemStack, String soilItemStack, String cropBlock) {
        this.seed = ConvertUtils.getItemStackFromStringClean(seedItemStack);
        this.output = ConvertUtils.StringArrayToItemStackArray(outputItemStack);
        this.soil = ConvertUtils.getItemStackFromString(soilItemStack, false);
        this.crop = Block.func_149684_b((String)cropBlock);
    }

    public CropFormat(String seedItemStack, String outputItemStack, String soilItemStack, String cropBlock) {
        this.seed = ConvertUtils.getItemStackFromStringClean(seedItemStack);
        this.output = new ItemStack[]{ConvertUtils.getItemStackFromString(outputItemStack, false)};
        this.soil = ConvertUtils.getItemStackFromString(soilItemStack, false);
        this.crop = Block.func_149684_b((String)cropBlock);
    }

    public static class ConvertUtils
    extends ConversionUtils {
    }
}

