/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.IEClocheCompat.CRUD.compats.AgriCraft;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemMaterial;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.nicjames2378.IEClocheCompat.Main;
import com.nicjames2378.IEClocheCompat.config.Configurator;
import com.nicjames2378.IEClocheCompat.utils.ConversionUtils;
import com.nicjames2378.IEClocheCompat.utils.MathUtils;
import com.nicjames2378.IEClocheCompat.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AgriClocheCompat {
    private static ArrayList<String> filterList;
    private static HashMap<String, MR> manualRenders;
    private static HashMap<SeedAgriItem, IAgriPlant> plantMap;
    private static HashMap<IAgriPlant, ItemStack[]> soilMap;
    private static HashMap<IAgriPlant, ItemStack[]> outputMap;
    public static AgricraftCropHandler agricraftHandler;

    public static void registerHandler() {
        BelljarHandler.registerHandler((BelljarHandler.IPlantHandler)agricraftHandler);
    }

    public static void initialize() {
        filterList = new ArrayList<String>(Arrays.asList(Configurator.statAgricraftList));
        manualRenders.put("Wheat".toLowerCase(), new MR(0, new ItemStack(Items.field_151014_N)));
        manualRenders.put("Potato".toLowerCase(), new MR(0, new ItemStack(Items.field_151174_bG)));
        manualRenders.put("Carrot".toLowerCase(), new MR(0, new ItemStack(Items.field_151172_bF)));
        manualRenders.put("Beets".toLowerCase(), new MR(0, new ItemStack(Items.field_185163_cU)));
        manualRenders.put("Nether Wart".toLowerCase(), new MR(0, new ItemStack(Items.field_151075_bm)));
        manualRenders.put("Red Mushroom".toLowerCase(), new MR(0, new ItemStack((Block)Blocks.field_150337_Q)));
        manualRenders.put("Brown Mushroom".toLowerCase(), new MR(0, new ItemStack((Block)Blocks.field_150338_P)));
        for (IAgriPlant plant : AgriApi.getPlantRegistry().all()) {
            if (!AgriClocheCompat.canRegister(plant)) continue;
            agricraftHandler.register(plant);
        }
        Main.log.info("-------------------------------");
    }

    private static boolean testContains(String string, String contains) {
        return string.toLowerCase().contains(contains.toLowerCase());
    }

    private static ItemStack[] getPlantOutputs(IAgriPlant agriPlant, boolean showDebug) {
        ArrayList outputs = new ArrayList();
        agriPlant.getPossibleProducts(outputs::add);
        if (showDebug && outputs.size() > 1) {
            Main.log.info("This plant has more than 1 output!");
        }
        return outputs.toArray(new ItemStack[0]);
    }

    private static ItemStack[] getPlantSoils(IAgriPlant agriPlant, boolean showDebug) {
        ArrayList<ItemStack> soils = new ArrayList<ItemStack>();
        for (IAgriSoil soil : agriPlant.getGrowthRequirement().getSoils()) {
            ItemStack soilStack;
            if (showDebug) {
                Main.log.info("getPlantSoils Debug: " + soil.getName() + ", " + new ItemStack(Item.func_111206_d((String)soil.getName())).func_77973_b().getRegistryName());
            }
            Block soilBlock = Block.func_149684_b((String)soil.getName()) != null ? Block.func_149684_b((String)soil.getName()) : Blocks.field_150483_bI;
            ItemStack addMe = soilStack = new ItemStack(soilBlock);
            switch (soil.getName().toLowerCase()) {
                case "farmland": {
                    NBTTagCompound tag;
                    NBTTagCompound nBTTagCompound = tag = agriPlant.getSeed().func_77942_o() ? agriPlant.getSeed().func_77978_p() : new NBTTagCompound();
                    if (tag.func_74764_b("agri_seed") && tag.func_74779_i("agri_seed").contains("mysticalagradditions")) {
                        switch (tag.func_74779_i("agri_seed").split(":")[1]) {
                            case "tier_six_inferium_plant": {
                                addMe = ConversionUtils.getItemStackFromStringClean("mysticalagradditions:storage");
                                break;
                            }
                            case "awakened_draconium_plant": {
                                addMe = ConversionUtils.getItemStackFromStringClean("mysticalagradditions:special=4");
                                break;
                            }
                            case "nether_star_plant": {
                                addMe = ConversionUtils.getItemStackFromStringClean("mysticalagradditions:special=0");
                                break;
                            }
                            case "dragon_egg_plant": {
                                addMe = ConversionUtils.getItemStackFromStringClean("mysticalagradditions:special=1");
                            }
                        }
                        break;
                    }
                    addMe = new ItemStack(Blocks.field_150346_d);
                    break;
                }
                case "soul sand": {
                    addMe = new ItemStack(Blocks.field_150425_aM);
                }
            }
            soils.add(addMe);
        }
        return soils.toArray(new ItemStack[0]);
    }

    private static boolean canRegister(IAgriPlant agriPlant) {
        String agriValue = null;
        if (AgriClocheCompat.testContains(agriPlant.getId(), "weed")) {
            return false;
        }
        try {
            agriValue = agriPlant.getSeed().func_77978_p().func_74779_i("agri_seed");
        }
        catch (Throwable e) {
            Main.log.error("AgriClocheCompat#canRegister: Seed does not have proper compound! Either a mod is incorrectly registering or Agricraft has changed! {" + agriPlant.getSeedName() + "}");
        }
        if (agriValue == null || agriValue.isEmpty() || agriValue.equals("")) {
            return false;
        }
        if (Configurator.statAgricraftListType.equals("BLACK") && (filterList.contains(agriValue) || filterList.contains(agriValue.split(":")[0] + ":*"))) {
            Main.log.info("Agricraft Compat - Skipping blacklisted seed: " + agriPlant.getSeedName());
            Main.log.info("-------------------------------");
            return false;
        }
        if (!(!Configurator.statAgricraftListType.equals("WHITE") || filterList.contains(agriValue) && filterList.contains(agriValue.split(":")[0] + ":*"))) {
            Main.log.info("Agricraft Compat - Skipping non-whitelisted seed: " + agriPlant.getSeedName());
            Main.log.info("-------------------------------");
            return false;
        }
        return true;
    }

    static {
        manualRenders = new HashMap();
        plantMap = new HashMap();
        soilMap = new HashMap();
        outputMap = new HashMap();
        agricraftHandler = new AgricraftCropHandler(){};
    }

    static class AgricraftCropHandler
    implements BelljarHandler.IPlantHandler {
        private HashSet<IAgriPlant> validSeeds = new HashSet();
        private static IBlockState[] currentState;

        AgricraftCropHandler() {
        }

        protected HashSet<IAgriPlant> getSeedSet() {
            return this.validSeeds;
        }

        public boolean isValid(ItemStack seed) {
            IAgriPlant plant = null;
            if (plantMap.containsKey(new SeedAgriItem(seed))) {
                plant = (IAgriPlant)plantMap.get(new SeedAgriItem(seed));
            }
            return this.getSeedSet().contains(plant);
        }

        public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
            for (ItemStack reqSoil : (ItemStack[])soilMap.get(plantMap.get(new SeedAgriItem(seed)))) {
                if (!ItemStack.func_179545_c((ItemStack)reqSoil, (ItemStack)soil)) continue;
                return true;
            }
            return false;
        }

        public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
            byte modifier = 0;
            if (seed.func_77942_o() && seed.func_77978_p().func_74764_b("agri_growth")) {
                modifier = seed.func_77978_p().func_74771_c("agri_growth");
            }
            if (modifier == 0) {
                return 0.003125f * (fertilizer + Configurator.statAgricraftStrengthMultiplier);
            }
            return 0.003125f * (fertilizer + (Configurator.statAgricraftStrengthMultiplier * (float)modifier - Configurator.statAgricraftStrengthMultiplier));
        }

        public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
            ArrayList<ItemStack> retVal = new ArrayList<ItemStack>();
            if (Configurator.verboseDebugging) {
                Main.log.info("Output: " + seed + ":, " + seed.func_77978_p().toString());
            }
            byte seedGain = seed.func_77978_p() != null ? seed.func_77978_p().func_74771_c("agri_gain") : (byte)1;
            seedGain = seedGain <= 0 ? (byte)1 : seedGain;
            for (ItemStack outputStack : (ItemStack[])outputMap.get(plantMap.get(new SeedAgriItem(seed)))) {
                String seedNBTString = seed.func_77978_p().func_74779_i("agri_seed");
                if (seedNBTString.contains("vanilla:potato_plant")) {
                    if (ItemStack.func_179545_c((ItemStack)outputStack, (ItemStack)new ItemStack(Items.field_151174_bG))) {
                        retVal.add(new ItemStack(outputStack.func_77973_b(), (int)Math.ceil((float)this.getGainYield(seedGain) * 0.7f), outputStack.func_77960_j()));
                        continue;
                    }
                    if (!ItemStack.func_179545_c((ItemStack)outputStack, (ItemStack)new ItemStack(Items.field_151170_bI)) || !MathUtils.testChanceIn(1, 50)) continue;
                    retVal.add(new ItemStack(outputStack.func_77973_b(), 1, outputStack.func_77960_j()));
                    continue;
                }
                if (seedNBTString.contains("immersiveengineering")) {
                    if (!(outputStack.func_77973_b() instanceof ItemMaterial)) continue;
                    retVal.add(new ItemStack(outputStack.func_77973_b(), this.getGainYield(seedGain), outputStack.func_77960_j()));
                    continue;
                }
                retVal.add(new ItemStack(outputStack.func_77973_b(), this.getGainYield(seedGain), outputStack.func_77960_j()));
            }
            if (MathUtils.testChanceIn(1, Configurator.statAgricraftSeedDuplicationChance)) {
                retVal.add(seed.func_77946_l());
            }
            return retVal.toArray(new ItemStack[0]);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            IAgriPlant plant = (IAgriPlant)plantMap.get(new SeedAgriItem(seed));
            if (AgriClocheCompat.testContains(plant.getId(), "immersiveengineering")) {
                currentState = new IBlockState[]{IEContent.blockCrop.func_176223_P()};
                return true;
            }
            if (AgriClocheCompat.testContains(plant.getId(), "mysticalagriculture") || AgriClocheCompat.testContains(plant.getId(), "mysticalagradditions")) {
                currentState = new IBlockState[]{Block.func_149684_b((String)plant.getId().replace("plant", "crop")).func_176223_P()};
                return false;
            }
            if (manualRenders.containsKey(plant.getPlantName().toLowerCase())) {
                MR mr = (MR)manualRenders.get(plant.getPlantName().toLowerCase());
                switch (mr.method) {
                    case 0: {
                        currentState = BelljarHandler.cropHandler.getRenderedPlant(mr.stack, soil, growth, tile);
                        return true;
                    }
                    case 1: {
                        currentState = BelljarHandler.stemHandler.getRenderedPlant(mr.stack, soil, growth, tile);
                        return true;
                    }
                    case 2: {
                        currentState = BelljarHandler.stackingHandler.getRenderedPlant(mr.stack, soil, growth, tile);
                        return true;
                    }
                }
            } else if (Configurator.cfgEnableExperiementalRenderer) {
                try {
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BlockPos blockPos = new BlockPos(0, 0, 0);
                    int index = (int)(MathUtils.roundToPortion(8.0f, growth) * 8.0f);
                    ResourceLocation resourceLocation = new ResourceLocation("agricraft", "textures/" + plant.getPrimaryPlantTexture(index).toString().split(":")[1] + ".png");
                    RenderUtils.renderAgri(blockPos, resourceLocation, tessellator);
                    return true;
                }
                catch (Exception e) {
                    Main.log.error("ERROR RENDERING!! \n");
                    e.printStackTrace();
                }
            }
            currentState = new IBlockState[]{Blocks.field_150467_bQ.func_176223_P()};
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = currentState;
            if (states != null) {
                IBlockState[] ret = new IBlockState[states.length];
                for (int i = 0; i < states.length; ++i) {
                    if (states[i] == null) continue;
                    if (states[i].func_177230_c() instanceof BlockCrops) {
                        int max = ((BlockCrops)states[i].func_177230_c()).func_185526_g();
                        ret[i] = ((BlockCrops)states[i].func_177230_c()).func_185528_e(Math.min(max, Math.round((float)max * growth)));
                        continue;
                    }
                    for (IProperty prop : states[i].func_177227_a()) {
                        if (!"age".equals(prop.func_177701_a()) || !(prop instanceof PropertyInteger)) continue;
                        int max = 0;
                        for (Integer allowed : ((PropertyInteger)prop).func_177700_c()) {
                            if (allowed == null || allowed <= max) continue;
                            max = allowed;
                        }
                        ret[i] = states[i].func_177226_a(prop, (Comparable)Integer.valueOf(Math.min(max, Math.round((float)max * growth))));
                    }
                    if (ret[i] != null) continue;
                    ret[i] = states[i];
                }
                return ret;
            }
            return null;
        }

        public void register(IAgriPlant agriPlant) {
            ItemStack seed = agriPlant.getSeed();
            Main.log.info(String.format("Agricraft Compat - Registering IAgriPlant '%1$s' (%2$s)), with output '%3$s', with soil '%4$s'%5$s", agriPlant.getPlantName(), agriPlant.getId(), ConversionUtils.ItemStackArrayToString(AgriClocheCompat.getPlantOutputs(agriPlant, true)), ConversionUtils.ItemStackArrayToString(AgriClocheCompat.getPlantSoils(agriPlant, false)), Main.PROX == Main.SIDE.SERVER ? " " : agriPlant.getPrimaryPlantTexture(1)));
            this.getSeedSet().add(agriPlant);
            plantMap.put(new SeedAgriItem(seed), agriPlant);
            soilMap.put(agriPlant, AgriClocheCompat.getPlantSoils(agriPlant, false));
            outputMap.put(agriPlant, AgriClocheCompat.getPlantOutputs(agriPlant, false));
        }

        private int getGainYield(int gainValue) {
            int normGain = Math.round(MathUtils.normalizeToRange(1.0f, 10.0f, 0.0f, 2.0f, gainValue));
            return MathUtils.clampValue(1.0f, Configurator.statAgricraftGainLimitHard, (float)gainValue * Configurator.statAgricraftGainLimitMultiplier + (float)MathUtils.getAmountToAddOrSubtract(normGain + 1, normGain) * Configurator.statAgricraftGainLimitMultiplier * Configurator.statAgricraftGainLimitMultiplier);
        }
    }

    static class MR {
        public byte method;
        public ItemStack stack;

        public MR(byte method, ItemStack stack) {
            this.method = method;
            this.stack = stack;
        }
    }

    static class SeedAgriItem {
        private Item itemSeed;
        private String agriSeed = null;

        private SeedAgriItem(ItemStack seed) {
            NBTTagCompound nbt;
            if (seed.func_77942_o() && (nbt = seed.func_77978_p()).func_74764_b("agri_seed")) {
                this.agriSeed = nbt.func_74779_i("agri_seed");
            }
            this.itemSeed = seed.func_77973_b();
        }

        private String getAgriSeed() {
            return this.agriSeed;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SeedAgriItem that = (SeedAgriItem)other;
            return Objects.equals(this.itemSeed, that.itemSeed) && Objects.equals(this.agriSeed, that.agriSeed);
        }

        public int hashCode() {
            return Objects.hash(this.itemSeed, this.agriSeed);
        }
    }
}

