/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.IEClocheCompat.CRUD;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import com.nicjames2378.IEClocheCompat.CRUD.formats.CropFormat;
import com.nicjames2378.IEClocheCompat.CRUD.formats.FertilizerFormat;
import com.nicjames2378.IEClocheCompat.Main;
import com.nicjames2378.IEClocheCompat.utils.ConversionUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class IEClocheCompat {
    public static boolean registerCrop(ItemStack seed, ItemStack[] output, ItemStack soil, Block crop, boolean condition) {
        if (condition) {
            try {
                BelljarHandler.cropHandler.register(seed, output, (Object)soil, new IBlockState[]{crop.func_176223_P()});
                Main.log.info(String.format("Registering seed '%1$s', with output '%2$s', with soil '%3$s', with crop '%4$s'", seed.func_77973_b().getRegistryName(), ConversionUtils.ItemStackArrayToString(output), soil.func_77973_b().getRegistryName(), crop.getRegistryName()));
                Main.log.info("-------------------------------");
                return true;
            }
            catch (Exception e) {
                Main.log.error(String.format("Error registering crop for seed '%1$s'. Skipping!", seed.toString()));
                Main.log.error((Object)e);
                return false;
            }
        }
        return false;
    }

    public static boolean registerCrop(CropFormat newCrop) {
        ItemStack seed = newCrop.getSeed();
        ItemStack[] output = newCrop.getOutputs();
        ItemStack soil = newCrop.getSoil();
        Block crop = newCrop.getCrop();
        boolean condition = newCrop.isConditionValid();
        return IEClocheCompat.registerCrop(seed, output, soil, crop, condition);
    }

    public static boolean[] registerAllCrops(CropFormat[] newCrops) {
        boolean[] results = new boolean[newCrops.length];
        int current = 0;
        for (CropFormat newCrop : newCrops) {
            results[current] = IEClocheCompat.registerCrop(newCrop);
        }
        return results;
    }

    public static boolean registerFertilizer(ItemStack fertilizer, float growthMultiplier, boolean condition) {
        if (condition) {
            try {
                BelljarHandler.registerBasicItemFertilizer((ItemStack)fertilizer, (float)growthMultiplier);
                Main.log.info(String.format("Registering fertilizer '%1$s', with growth multiplier of '%2$s'", fertilizer.func_77973_b().getRegistryName(), Float.valueOf(growthMultiplier)));
                Main.log.info("-------------------------------");
                return true;
            }
            catch (Exception e) {
                Main.log.error(String.format("Error registering fertilizer '%1$s'. Skipping!", fertilizer.func_77973_b().getRegistryName()));
                Main.log.error((Object)e);
                return false;
            }
        }
        return false;
    }

    public static boolean registerFertilizer(FertilizerFormat newFertilizer) {
        ItemStack fertilizer = newFertilizer.getFertilizer();
        float growthMultiplier = newFertilizer.getGrowthMultiplier();
        boolean condition = newFertilizer.isConditionValid();
        return IEClocheCompat.registerFertilizer(fertilizer, growthMultiplier, condition);
    }

    public static boolean[] registerAllFertilizers(FertilizerFormat[] newFertilizers) {
        boolean[] results = new boolean[newFertilizers.length];
        int current = 0;
        for (FertilizerFormat newFertilizer : newFertilizers) {
            results[current] = IEClocheCompat.registerFertilizer(newFertilizer);
        }
        return results;
    }
}

