/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.simplelogic.wires.logic.PartWireSignalBase;

public final class PropagationQueue {
    public final boolean clearMode;
    private final Queue<Pair<PartWireSignalBase, Integer>> wires;
    private final Deque<PartWireSignalBase> wiresFinish = new LinkedList<PartWireSignalBase>();

    public PropagationQueue(boolean clearMode) {
        this.clearMode = clearMode;
        this.wires = new LinkedList<Pair<PartWireSignalBase, Integer>>();
    }

    public void add(PartWireSignalBase wire, int color) {
        this.wires.add((Pair<PartWireSignalBase, Integer>)Pair.of((Object)((Object)wire), (Object)color));
    }

    public void propagate() {
        while (!this.wires.isEmpty()) {
            Pair<PartWireSignalBase, Integer> pair = this.wires.remove();
            PartWireSignalBase wire = (PartWireSignalBase)((Object)pair.getLeft());
            wire.propagate((Integer)pair.getRight(), this);
            this.wiresFinish.push(wire);
        }
        while (!this.wiresFinish.isEmpty()) {
            PartWireSignalBase wire = this.wiresFinish.pop();
            if (this.clearMode) {
                PropagationQueue queue1 = new PropagationQueue(false);
                queue1.add(wire, -1);
                queue1.propagate();
            }
            wire.finishPropagation();
        }
    }
}

