/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.lib.IDebuggable;
import pl.asie.charset.api.tools.IStopwatchTracker;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.api.wires.IWire;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.misc.ISimpleLogicSidedEmitter;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataProvider;
import pl.asie.charset.lib.utils.redstone.RedstoneUtils;
import pl.asie.charset.lib.wires.CharsetLibWires;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireUtils;
import pl.asie.simplelogic.wires.logic.LogicWireProvider;
import pl.asie.simplelogic.wires.logic.PropagationQueue;

public abstract class PartWireSignalBase
extends Wire
implements IWire,
ISignalMeterDataProvider,
IDebuggable,
ISimpleLogicSidedEmitter {
    public static boolean DEBUG_CLIENT_WIRE_STATE = false;
    public static boolean DEBUG = false;
    public static boolean PROPAGATING = false;
    public static boolean WIRES_CONNECT_REDSTONE = true;
    private final EnumSet<EnumFacing> propagationDirs = EnumSet.noneOf(EnumFacing.class);
    private int color = -1;
    private boolean scheduledStopwatch;

    public PartWireSignalBase(@Nonnull IWireContainer container, @Nonnull WireProvider factory, @Nonnull WireFace location) {
        super(container, factory, location);
    }

    public int getColor() {
        return this.color;
    }

    protected void setColor(int color) {
        this.color = color;
    }

    protected LogicWireProvider getSignalFactory() {
        return (LogicWireProvider)this.getProvider();
    }

    protected abstract void onSignalChanged(int var1, boolean var2);

    protected void scheduleLogicUpdate() {
        if (this.getContainer().world() != null && this.getContainer().pos() != null) {
            if (!this.getContainer().world().field_72995_K) {
                this.onSignalChanged(-1, false);
            }
        } else if (this.getContainer().world() != null) {
            Scheduler.INSTANCE.in(this.getContainer().world(), 0, this::scheduleLogicUpdate);
        }
    }

    public void onChanged(boolean external) {
        super.onChanged(external);
        this.scheduleLogicUpdate();
    }

    protected boolean canConnectWire(Wire wire) {
        if (super.canConnectWire(wire)) {
            return true;
        }
        if (!(wire instanceof PartWireSignalBase)) {
            return false;
        }
        PartWireSignalBase sWire = (PartWireSignalBase)wire;
        switch (this.getSignalFactory().type) {
            case NORMAL: {
                return sWire.getWireType() != WireType.BUNDLED;
            }
            case INSULATED: {
                return sWire.getWireType() != WireType.INSULATED;
            }
            case BUNDLED: {
                if (sWire.getWireType() == WireType.BUNDLED) {
                    return sWire.getColor() == -1 || this.getColor() == -1;
                }
                return sWire.getWireType() != WireType.NORMAL;
            }
        }
        return false;
    }

    protected boolean canConnectBlock(BlockPos pos, EnumFacing direction) {
        if (this.getSignalFactory().type == WireType.BUNDLED) {
            if (WireUtils.hasCapability((Wire)this, (BlockPos)pos, (Capability)Capabilities.BUNDLED_EMITTER, (EnumFacing)direction, (boolean)true)) {
                return true;
            }
            if (WireUtils.hasCapability((Wire)this, (BlockPos)pos, (Capability)Capabilities.BUNDLED_RECEIVER, (EnumFacing)direction, (boolean)true)) {
                return true;
            }
        } else {
            if (WireUtils.hasCapability((Wire)this, (BlockPos)pos, (Capability)Capabilities.REDSTONE_EMITTER, (EnumFacing)direction, (boolean)true)) {
                return true;
            }
            if (WireUtils.hasCapability((Wire)this, (BlockPos)pos, (Capability)Capabilities.REDSTONE_RECEIVER, (EnumFacing)direction, (boolean)true)) {
                return true;
            }
            IBlockState connectingState = this.getContainer().world().func_180495_p(pos);
            Block connectingBlock = connectingState.func_177230_c();
            if (this.getLocation() == WireFace.CENTER && !connectingBlock.isSideSolid(connectingState, (IBlockAccess)this.getContainer().world(), pos, direction)) {
                return false;
            }
            WIRES_CONNECT_REDSTONE = false;
            boolean connectRS = RedstoneUtils.canConnectFace((IBlockAccess)this.getContainer().world(), (BlockPos)pos, (IBlockState)connectingState, (EnumFacing)direction.func_176734_d(), (EnumFacing)this.getLocation().facing);
            WIRES_CONNECT_REDSTONE = true;
            if (connectRS) {
                return true;
            }
        }
        return false;
    }

    public abstract void propagate(int var1, PropagationQueue var2);

    public abstract int getSignalLevel();

    public abstract int getRedstoneLevel();

    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        super.readNBTData(nbt, isClient);
        if (nbt.func_74764_b("col")) {
            this.color = nbt.func_74771_c("col");
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        if (this.color != -1) {
            nbt.func_74774_a("col", (byte)this.color);
        }
        return super.writeNBTData(nbt, isClient);
    }

    protected void updateConnections() {
        for (int j = 0; j < 6; ++j) {
            EnumFacing facing = EnumFacing.func_82600_a((int)j);
            TileEntity tile = this.getContainer().world().func_175625_s(this.getContainer().pos().func_177972_a(facing));
            if (tile == null) continue;
            if (this.getSignalFactory().type == WireType.BUNDLED) {
                if (!tile.hasCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())) continue;
                ((IBundledReceiver)tile.getCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())).onBundledInputChange();
                continue;
            }
            if (!tile.hasCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())) continue;
            ((IRedstoneReceiver)tile.getCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())).onRedstoneInputChange();
        }
        super.updateConnections();
        this.scheduleLogicUpdate();
    }

    protected void propagateNotifyCorner(EnumFacing side, EnumFacing direction, PropagationQueue queue, int color) {
        Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos().func_177972_a(side).func_177972_a(direction), (WireFace)WireFace.get((EnumFacing)direction.func_176734_d()));
        if (wire instanceof PartWireSignalBase) {
            queue.add((PartWireSignalBase)wire, color);
        }
    }

    protected void propagateNotify(EnumFacing facing, PropagationQueue queue, int color) {
        Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos().func_177972_a(facing), (WireFace)this.getLocation());
        if (wire instanceof PartWireSignalBase) {
            queue.add((PartWireSignalBase)wire, color);
        } else {
            this.propagationDirs.add(facing);
        }
    }

    protected void finishPropagation() {
        for (EnumFacing facing : this.propagationDirs) {
            TileEntity nt = this.getContainer().world().func_175625_s(this.getContainer().pos().func_177972_a(facing));
            boolean found = false;
            if (nt != null) {
                if (this.getSignalFactory().type == WireType.BUNDLED) {
                    if (nt.hasCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())) {
                        ((IBundledReceiver)nt.getCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())).onBundledInputChange();
                        found = true;
                    }
                } else if (nt.hasCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())) {
                    ((IRedstoneReceiver)nt.getCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())).onRedstoneInputChange();
                    found = true;
                }
            }
            if (this.getSignalFactory().type == WireType.BUNDLED || found) continue;
            this.neighborChanged(this.getContainer().pos().func_177972_a(facing));
        }
        this.propagationDirs.clear();
        if (!this.scheduledStopwatch) {
            IStopwatchTracker tracker;
            this.scheduledStopwatch = true;
            if (this.getContainer().world().hasCapability(Capabilities.STOPWATCH_TRACKER, null) && (tracker = (IStopwatchTracker)this.getContainer().world().getCapability(Capabilities.STOPWATCH_TRACKER, null)) != null) {
                Scheduler.INSTANCE.in(MultipartHelper.unwrapWorld((World)this.getContainer().world()), 0, () -> {
                    tracker.markChanged(this.getContainer().pos());
                    this.scheduledStopwatch = false;
                });
            }
        }
    }

    protected final void neighborChanged(BlockPos neighborPos) {
        this.getContainer().world().func_190524_a(neighborPos, (Block)CharsetLibWires.blockWire, this.getContainer().pos());
    }

    public int getBundledSignalLevel(int i) {
        return 0;
    }

    public boolean canConnectRedstone(EnumFacing facing) {
        return WIRES_CONNECT_REDSTONE && this.connectsExternal(facing);
    }

    public int getWeakPower(EnumFacing facing) {
        if (!PROPAGATING && facing != null && this.connectsWeak(facing.func_176734_d())) {
            IBlockState state;
            if (facing == EnumFacing.UP && (state = this.getContainer().world().func_180495_p(this.getContainer().pos().func_177977_b())).func_177230_c() instanceof BlockRedstoneWire) {
                return 0;
            }
            return this.getRedstoneLevel();
        }
        return 0;
    }

    public boolean connectsWeak(EnumFacing facing) {
        if (this.getLocation().facing == facing) {
            return true;
        }
        return this.connects(facing) || this.getSignalFactory().type == WireType.NORMAL;
    }

    public WireType getWireType() {
        return this.getSignalFactory().type;
    }

    public int getStrongPower(EnumFacing facing) {
        return 0;
    }

    public EnumFacing getEmitterFace() {
        return this.getLocation().facing;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == Capabilities.DEBUGGABLE || capability == Capabilities.SIGNAL_METER_DATA_PROVIDER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.DEBUGGABLE || capability == Capabilities.SIGNAL_METER_DATA_PROVIDER) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

