/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.SignalMeterDataBundledWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireUtils;
import pl.asie.simplelogic.wires.LogicWireUtils;
import pl.asie.simplelogic.wires.SimpleLogicWires;
import pl.asie.simplelogic.wires.logic.PartWireInsulated;
import pl.asie.simplelogic.wires.logic.PartWireSignalBase;
import pl.asie.simplelogic.wires.logic.PropagationQueue;

public class PartWireBundled
extends PartWireSignalBase
implements IBundledReceiver,
IBundledEmitter {
    private int[] insulatedColorCache = null;
    private int[] signalLevel = new int[16];
    private byte[] signalValue = new byte[16];

    public PartWireBundled(@Nonnull IWireContainer container, @Nonnull WireProvider factory, @Nonnull WireFace location) {
        super(container, factory, location);
    }

    public int getBundledRenderColor() {
        int c = 0xFF000000 | EnumDyeColor.func_176764_b((int)this.getColor()).func_193350_e();
        return c & 0xFF00FF00 | c >> 16 & 0xFF | c << 16 & 0xFF0000;
    }

    protected int[] getInsulatedColorCache() {
        if (this.getContainer().world() != null && this.getContainer().pos() != null && this.insulatedColorCache == null) {
            this.insulatedColorCache = new int[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos pos = this.getContainer().pos().func_177972_a(facing);
                WireFace face = this.getLocation();
                if (this.connectsCorner(facing)) {
                    pos = pos.func_177972_a(face.facing);
                    face = WireFace.get((EnumFacing)facing.func_176734_d());
                } else if (!this.connectsExternal(facing)) {
                    this.insulatedColorCache[facing.ordinal()] = -1;
                    continue;
                }
                Wire targetWire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)pos, (WireFace)face);
                this.insulatedColorCache[facing.ordinal()] = targetWire instanceof PartWireInsulated ? ((PartWireInsulated)targetWire).getWireColor() : -1;
            }
        }
        return this.insulatedColorCache;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        return -1;
    }

    public boolean renderEquals(Wire other) {
        return super.renderEquals(other) && Arrays.equals(((PartWireBundled)other).getInsulatedColorCache(), this.getInsulatedColorCache());
    }

    public int renderHashCode() {
        return Objects.hash(super.renderHashCode(), this.getInsulatedColorCache());
    }

    @Override
    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        super.readNBTData(nbt, isClient);
        if (nbt.func_150297_b("s", 11)) {
            this.signalLevel = nbt.func_74759_k("s");
            if (this.signalLevel.length != 16) {
                this.signalLevel = new int[16];
            }
        } else {
            this.signalLevel = new int[16];
        }
        for (int i = 0; i < 16; ++i) {
            this.signalValue[i] = (byte)(this.signalLevel[i] >> 8);
        }
        this.insulatedColorCache = null;
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        super.writeNBTData(nbt, isClient);
        nbt.func_74783_a("s", this.signalLevel);
        return nbt;
    }

    private void propagate(int color, PropagationQueue queue, byte[][] nValues) {
        int newSignal;
        boolean[] isWire = new boolean[7];
        int[] neighborLevel = new int[7];
        int maxSignal = 0;
        int oldSignal = this.signalLevel[color];
        PartWireSignalBase.PROPAGATING = true;
        for (WireFace wireFace : WireFace.VALUES) {
            if (!this.connectsInternal(wireFace)) continue;
            isWire[wireFace.ordinal()] = true;
            neighborLevel[wireFace.ordinal()] = LogicWireUtils.getBundledWireLevel((IBlockAccess)this.getContainer().world(), this.getContainer().pos(), wireFace, color);
        }
        for (WireFace wireFace : EnumFacing.field_82609_l) {
            if (this.connectsExternal((EnumFacing)wireFace)) {
                if (nValues[wireFace.ordinal()] != null) {
                    int v;
                    int nv = nValues[wireFace.ordinal()][color];
                    if (nv < 0 || nv > 15) {
                        nv = 15;
                    }
                    if ((v = nv << 8) == 0) continue;
                    neighborLevel[wireFace.ordinal()] = v | 0xFF;
                    continue;
                }
                BlockPos pos = this.getContainer().pos().func_177972_a((EnumFacing)wireFace);
                Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)pos, (WireFace)this.getLocation());
                if (!(wire instanceof PartWireSignalBase)) continue;
                isWire[wireFace.ordinal()] = true;
                neighborLevel[wireFace.ordinal()] = LogicWireUtils.getBundledWireLevel((IBlockAccess)this.getContainer().world(), pos, this.getLocation(), color);
                continue;
            }
            if (!this.connectsCorner((EnumFacing)wireFace)) continue;
            BlockPos cornerPos = this.getContainer().pos().func_177972_a((EnumFacing)wireFace).func_177972_a(this.getLocation().facing);
            Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)cornerPos, (WireFace)WireFace.get((EnumFacing)wireFace.func_176734_d()));
            if (!(wire instanceof PartWireSignalBase)) continue;
            isWire[wireFace.ordinal()] = true;
            neighborLevel[wireFace.ordinal()] = LogicWireUtils.getBundledWireLevel((IBlockAccess)this.getContainer().world(), cornerPos, WireFace.get((EnumFacing)wireFace.func_176734_d()), color);
        }
        PartWireSignalBase.PROPAGATING = false;
        int maxSignalNonWire = 0;
        for (int j = 0; j < 7; ++j) {
            if (neighborLevel[j] > maxSignal) {
                maxSignal = neighborLevel[j];
            }
            if (isWire[j] || neighborLevel[j] <= maxSignalNonWire) continue;
            maxSignalNonWire = neighborLevel[j];
        }
        if (DEBUG) {
            System.out.println("[" + color + "] Levels: " + Arrays.toString(neighborLevel));
        }
        if (maxSignal > oldSignal && !queue.clearMode) {
            newSignal = maxSignal - 1;
            if ((newSignal & 0xFF) == 0 || (newSignal & 0xFF) == 255) {
                newSignal = 0;
            }
        } else {
            newSignal = maxSignalNonWire;
        }
        if (oldSignal == newSignal) {
            return;
        }
        this.signalLevel[color] = newSignal;
        this.signalValue[color] = (byte)(newSignal >> 8);
        if (DEBUG) {
            System.out.println("Switch: " + oldSignal + " -> " + newSignal);
        }
        if (newSignal == 0) {
            PropagationQueue queueToAdd = queue.clearMode ? queue : new PropagationQueue(true);
            for (WireFace nLoc : WireFace.VALUES) {
                if (this.connectsInternal(nLoc)) {
                    Wire wire;
                    if (neighborLevel[nLoc.ordinal()] <= 0 || !((wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos(), (WireFace)nLoc)) instanceof PartWireSignalBase)) continue;
                    queueToAdd.add((PartWireSignalBase)wire, color);
                    continue;
                }
                if (nLoc == WireFace.CENTER) continue;
                EnumFacing facing = nLoc.facing;
                if (this.connectsExternal(facing)) {
                    Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos().func_177972_a(facing), (WireFace)this.getLocation());
                    if (wire instanceof PartWireSignalBase && neighborLevel[facing.ordinal()] <= 0) continue;
                    this.propagateNotify(facing, queueToAdd, color);
                    continue;
                }
                if (!this.connectsCorner(facing) || neighborLevel[facing.ordinal()] <= 0) continue;
                this.propagateNotifyCorner(this.getLocation().facing, facing, queueToAdd, color);
            }
            if (queueToAdd != queue) {
                queueToAdd.propagate();
            }
        } else {
            for (WireFace nLoc : WireFace.VALUES) {
                if (neighborLevel[nLoc.ordinal()] >= newSignal - 1 && neighborLevel[nLoc.ordinal()] <= newSignal + 1) continue;
                if (this.connectsInternal(nLoc)) {
                    Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), (BlockPos)this.getContainer().pos(), (WireFace)nLoc);
                    if (!(wire instanceof PartWireSignalBase)) continue;
                    queue.add((PartWireSignalBase)wire, color);
                    continue;
                }
                if (nLoc == WireFace.CENTER) continue;
                EnumFacing facing = nLoc.facing;
                if (this.connectsExternal(facing)) {
                    this.propagateNotify(facing, queue, color);
                    continue;
                }
                if (!this.connectsCorner(facing)) continue;
                this.propagateNotifyCorner(this.getLocation().facing, facing, queue, color);
            }
        }
        if (PartWireSignalBase.DEBUG_CLIENT_WIRE_STATE) {
            if (SimpleLogicWires.useTESRs) {
                this.getContainer().requestNetworkUpdate();
            } else {
                this.getContainer().requestRenderUpdate();
            }
        }
    }

    @Override
    public void propagate(int color, PropagationQueue queue) {
        if (color == -1) {
            for (int i = 0; i < 16; ++i) {
                this.propagate(i, queue);
            }
            return;
        }
        if (DEBUG) {
            System.out.println("--- B! PROPAGATE " + this.getContainer().pos().toString() + " " + this.getLocation().name() + " --- " + color);
        }
        byte[][] nValues = new byte[6][];
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.connectsExternal(facing)) continue;
            IBundledEmitter emitter = null;
            BlockPos pos = this.getContainer().pos().func_177972_a(facing);
            if (WireUtils.hasCapability((Wire)this, (BlockPos)pos, (Capability)Capabilities.BUNDLED_EMITTER, (EnumFacing)facing.func_176734_d(), (boolean)true)) {
                emitter = (IBundledEmitter)WireUtils.getCapability((Wire)this, (BlockPos)pos, (Capability)Capabilities.BUNDLED_EMITTER, (EnumFacing)facing.func_176734_d(), (boolean)true);
            }
            if (emitter == null) continue;
            nValues[facing.ordinal()] = emitter instanceof PartWireBundled ? ((PartWireBundled)emitter).getBundledSignalUnsafe() : emitter.getBundledSignal();
        }
        this.propagate(color, queue, nValues);
    }

    @Override
    protected void onSignalChanged(int color, boolean clearMode) {
        if (this.getContainer().world() != null && this.getContainer().pos() != null && !this.getContainer().world().field_72995_K) {
            PropagationQueue queue = new PropagationQueue(clearMode);
            queue.add(this, color);
            queue.propagate();
        }
    }

    @Override
    public int getBundledSignalLevel(int i) {
        return this.signalLevel[i & 0xF];
    }

    @Override
    public boolean canConnectRedstone(EnumFacing facing) {
        return false;
    }

    @Override
    public boolean connectsWeak(EnumFacing facing) {
        return false;
    }

    @Override
    public int getSignalLevel() {
        return 0;
    }

    @Override
    public int getRedstoneLevel() {
        return 0;
    }

    public byte[] getBundledSignal() {
        return Arrays.copyOf(this.signalValue, 16);
    }

    protected byte[] getBundledSignalUnsafe() {
        return this.signalValue;
    }

    public void onBundledInputChange() {
        this.scheduleLogicUpdate();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        if (capability == Capabilities.BUNDLED_RECEIVER) {
            return this.connects(face);
        }
        if (capability == Capabilities.BUNDLED_EMITTER) {
            return this.connects(face);
        }
        return super.hasCapability(capability, face);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing face) {
        if (capability == Capabilities.BUNDLED_RECEIVER) {
            return (T)Capabilities.BUNDLED_RECEIVER.cast((Object)this);
        }
        if (capability == Capabilities.BUNDLED_EMITTER) {
            return (T)Capabilities.BUNDLED_EMITTER.cast((Object)this);
        }
        return super.getCapability(capability, face);
    }

    public String getDisplayName() {
        if (this.getColor() >= 0) {
            return String.format(I18n.func_74838_a((String)("tile.simplelogic.wire.bundled.colored" + (this.getLocation() == WireFace.CENTER ? ".freestanding.name" : ".name"))), I18n.func_74838_a((String)ColorUtils.getLangEntry((String)"charset.color.", (EnumDyeColor)EnumDyeColor.func_176764_b((int)this.getColor()))));
        }
        return I18n.func_74838_a((String)("tile.simplelogic.wire.bundled" + (this.getLocation() == WireFace.CENTER ? ".freestanding.name" : ".name")));
    }

    public void addDebugInformation(List<String> stringList, Side side) {
        if (side == Side.CLIENT && !PartWireSignalBase.DEBUG_CLIENT_WIRE_STATE) {
            return;
        }
        StringBuilder builder = new StringBuilder(this.getLocation().name());
        ArrayList<String> extraString = new ArrayList<String>();
        builder.append(' ');
        for (int i = 0; i < 16; ++i) {
            EnumDyeColor c = EnumDyeColor.func_176764_b((int)i);
            byte v = this.signalValue[i];
            builder.append(ColorUtils.getNearestTextFormatting((EnumDyeColor)c));
            builder.append(v <= 0 ? Character.valueOf('_') : Integer.toHexString(this.signalValue[i]).toUpperCase());
            if (v <= 0) continue;
            extraString.add(ColorUtils.getNearestTextFormatting((EnumDyeColor)c) + I18n.func_74838_a((String)ColorUtils.getLangEntry((String)"charset.color.", (EnumDyeColor)c)) + " R:" + v + " S:" + (this.signalLevel[i] & 0xFF));
        }
        stringList.add(builder.toString());
        stringList.addAll(extraString);
    }

    public ISignalMeterData getSignalMeterData(RayTraceResult result) {
        return new SignalMeterDataBundledWire(this.signalValue);
    }
}

