/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires;

import java.util.LinkedHashSet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.handlers.ShiftScrollHandler;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.recipe.IngredientGroup;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.wires.CharsetLibWires;
import pl.asie.charset.lib.wires.IWireRenderContainer;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireRenderHandler;
import pl.asie.charset.lib.wires.WireRenderHandlerDefault;
import pl.asie.charset.shared.SimpleLogicShared;
import pl.asie.simplelogic.wires.ShiftScrollProviderWire;
import pl.asie.simplelogic.wires.logic.LogicWireProvider;
import pl.asie.simplelogic.wires.logic.WireRenderHandlerOverlay;

@CharsetModule(name="simplelogic.wires", description="Simple wires.", dependencies={"lib.wires"}, profile=ModuleProfile.FORCED)
public class SimpleLogicWires {
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    private static WireProvider[] wireProviders;
    private static ItemWire[] wireItems;
    @CharsetModule.Configuration
    public static Configuration config;
    public static boolean useTESRs;
    public static boolean enableRedstoneCables;
    public static boolean enableInsulatedCables;
    public static boolean enableBundledCables;
    public static boolean enableColoredBundledCables;

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        useTESRs = ConfigUtils.getBoolean((Configuration)config, (String)"client", (String)"forceWireTESRs", (boolean)false, (String)"Forces redstone cables to render using TESRs.", (boolean)false);
        enableRedstoneCables = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"enableRedstoneCables", (boolean)true, (String)"Should redstone cables be enabled? Note that recipes will not be currently adapted.", (boolean)true);
        enableInsulatedCables = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"enableInsulatedCables", (boolean)true, (String)"Should insulated cables be enabled? Note that recipes will not be currently adapted.", (boolean)true);
        enableBundledCables = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"enableBundledCables", (boolean)true, (String)"Should bundled cables be enabled? Note that recipes will not be currently adapted.", (boolean)true);
        enableColoredBundledCables = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"enableColoredBundledCables", (boolean)true, (String)"Should colored bundled cables be enabled? Note that recipes will not be currently adapted.", (boolean)true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int i;
        int i2;
        if (enableRedstoneCables) {
            SimpleLogicWires.wireProviders[0] = new LogicWireProvider(WireType.NORMAL, -1).setRegistryName(new ResourceLocation("charset:logic_wire_n"));
        }
        if (enableInsulatedCables) {
            for (i2 = 0; i2 < 16; ++i2) {
                SimpleLogicWires.wireProviders[i2 + 1] = new LogicWireProvider(WireType.INSULATED, i2).setRegistryName(new ResourceLocation("charset:logic_wire_i" + i2));
            }
        }
        if (enableBundledCables) {
            SimpleLogicWires.wireProviders[17] = new LogicWireProvider(WireType.BUNDLED, -1).setRegistryName(new ResourceLocation("charset:logic_wire_b"));
        }
        if (enableColoredBundledCables) {
            for (i2 = 0; i2 < 16; ++i2) {
                SimpleLogicWires.wireProviders[i2 + 18] = new LogicWireProvider(WireType.BUNDLED, i2).setRegistryName(new ResourceLocation("charset:logic_wire_bc" + i2));
            }
        }
        boolean setIcon = false;
        for (i = 0; i < wireProviders.length; ++i) {
            if (wireProviders[i] == null) continue;
            SimpleLogicWires.wireItems[i] = new ItemWire(wireProviders[i]);
            wireItems[i].setRegistryName(wireProviders[i].getRegistryName());
            if (setIcon) continue;
            SimpleLogicShared.TAB_ICON = new ItemStack((Item)wireItems[i]);
            setIcon = true;
        }
        if (enableInsulatedCables) {
            for (i = 0; i < 16; ++i) {
                IngredientGroup.register((String)"simplelogic:wireInsulated", (int)i, (Object[])new Object[]{new ItemStack((Item)wireItems[i + 1])});
            }
        }
        if (enableColoredBundledCables) {
            for (i = 0; i < 16; ++i) {
                IngredientGroup.register((String)"simplelogic:wireBundledColored", (int)i, (Object[])new Object[]{new ItemStack((Item)wireItems[i + 18])});
            }
        }
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        for (int i = 0; i < wireItems.length; ++i) {
            if (wireItems[i] == null) continue;
            RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)wireItems[i], (String)wireItems[i].getRegistryName().func_110623_a(), (CreativeTabs)SimpleLogicShared.getTab());
        }
    }

    @SubscribeEvent
    public void onRegisterWires(RegistryEvent.Register<WireProvider> event) {
        for (int i = 0; i < wireProviders.length; ++i) {
            if (wireProviders[i] == null) continue;
            RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)wireProviders[i], (String)wireProviders[i].getRegistryName().func_110623_a(), (CreativeTabs)SimpleLogicShared.getTab());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (enableRedstoneCables) {
            CharsetLibWires.instance.registerRenderer(wireProviders[0], (IWireRenderContainer)new IWireRenderContainer.Simple((WireRenderHandler)new WireRenderHandlerDefault(wireProviders[0]){

                @SideOnly(value=Side.CLIENT)
                public boolean isDynamic() {
                    return useTESRs;
                }
            }));
        }
        if (enableBundledCables) {
            CharsetLibWires.instance.registerRenderer(wireProviders[17], (IWireRenderContainer)new WireRenderHandlerOverlay(wireProviders[17], false));
        }
        if (enableColoredBundledCables) {
            for (int i = 0; i < 16; ++i) {
                CharsetLibWires.instance.registerRenderer(wireProviders[18 + i], (IWireRenderContainer)new WireRenderHandlerOverlay(wireProviders[18 + i], true));
            }
        }
    }

    private void addWireOD(String name, Item i) {
        if (i == null) {
            return;
        }
        ItemStack nonFreestanding = new ItemStack(i, 1, 0);
        ItemStack freestanding = new ItemStack(i, 1, 1);
        OreDictionary.registerOre((String)"wireLogic", (Item)i);
        OreDictionary.registerOre((String)"wireLogicGrounded", (ItemStack)nonFreestanding);
        OreDictionary.registerOre((String)"wireLogicFreestanding", (ItemStack)freestanding);
        OreDictionary.registerOre((String)("wireLogic" + name), (Item)i);
        OreDictionary.registerOre((String)("wireLogic" + name + "Grounded"), (ItemStack)nonFreestanding);
        OreDictionary.registerOre((String)("wireLogic" + name + "Freestanding"), (ItemStack)freestanding);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int i;
        LinkedHashSet<Item> scrollableInsulated;
        if (enableInsulatedCables) {
            scrollableInsulated = new LinkedHashSet<Item>();
            for (i = 0; i < 16; ++i) {
                scrollableInsulated.add((Item)wireItems[i + 1]);
            }
            ShiftScrollHandler.INSTANCE.register((ShiftScrollHandler.Provider)new ShiftScrollProviderWire(scrollableInsulated, false));
            ShiftScrollHandler.INSTANCE.register((ShiftScrollHandler.Provider)new ShiftScrollProviderWire(scrollableInsulated, true));
        }
        if (enableColoredBundledCables) {
            scrollableInsulated = new LinkedHashSet();
            for (i = 0; i < 16; ++i) {
                scrollableInsulated.add((Item)wireItems[i + 18]);
            }
            ShiftScrollHandler.INSTANCE.register((ShiftScrollHandler.Provider)new ShiftScrollProviderWire(scrollableInsulated, false));
            ShiftScrollHandler.INSTANCE.register((ShiftScrollHandler.Provider)new ShiftScrollProviderWire(scrollableInsulated, true));
        }
        this.addWireOD("Redstone", (Item)wireItems[0]);
        this.addWireOD("Bundled", (Item)wireItems[17]);
        for (int i2 = 0; i2 < 16; ++i2) {
            this.addWireOD("Insulated", (Item)wireItems[i2 + 1]);
            this.addWireOD(ColorUtils.getOreDictEntry((String)"Insulated", (EnumDyeColor)EnumDyeColor.func_176764_b((int)i2)), (Item)wireItems[i2 + 1]);
            this.addWireOD("BundledColored", (Item)wireItems[i2 + 18]);
            this.addWireOD(ColorUtils.getOreDictEntry((String)"BundledColored", (EnumDyeColor)EnumDyeColor.func_176764_b((int)i2)), (Item)wireItems[i2 + 1]);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        wireProviders = new WireProvider[34];
        wireItems = new ItemWire[wireProviders.length];
    }
}

